/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.communication;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.fordiac.ide.monitoring.Activator;

public class MonitorInformation {
    public String origMgrID;
    public String iP;
    public Integer port = 0;

    public MonitorInformation(String mgrID) {
        if (mgrID != null) {
            String id = mgrID;
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            String[] splitID = id.split(":");
            this.origMgrID = mgrID;
            if (splitID.length == 2) {
                try {
                    InetAddress adress = InetAddress.getByName(splitID[0]);
                    this.iP = adress.getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {}
                try {
                    this.port = Integer.parseInt(splitID[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.port = 0;
                }
                if (1023 > this.port && this.port > 65536) {
                    this.port = 0;
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.iP) + ":" + this.port;
    }

    public InetAddress getInetAdress() {
        try {
            return InetAddress.getByName(this.iP);
        }
        catch (UnknownHostException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }
}

