/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.resourceloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.builder.resourceloader.ParallelResourceLoader;
import org.eclipse.xtext.builder.resourceloader.SerialResourceLoader;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public final class ResourceLoaderProviders {
    public static Provider<IResourceLoader> getParallelLoader() {
        int nThreads = ResourceLoaderProviders.getNumberOfThreads();
        return ResourceLoaderProviders.getParallelLoader(nThreads, 0);
    }

    public static Provider<IResourceLoader> getParallelLoader(long timeoutTime, TimeUnit timeoutUnit) {
        int nThreads = ResourceLoaderProviders.getNumberOfThreads();
        return ResourceLoaderProviders.getParallelLoader(nThreads, 0, timeoutTime, timeoutUnit);
    }

    private static int getNumberOfThreads() {
        int nProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = Math.max(2, Math.min(4, nProcessors));
        return nThreads;
    }

    public static Provider<IResourceLoader> getParallelLoader(int nrOfThreads) {
        return ResourceLoaderProviders.getParallelLoader(nrOfThreads, 0);
    }

    public static Provider<IResourceLoader> getParallelLoader(final int nrOfThreads, final int bufferSize) {
        return new AbstractResourceLoaderProvider(){

            public IResourceLoader get() {
                ParallelResourceLoader resourceLoader = new ParallelResourceLoader(this.getResourceSetProvider(), this.getResourceSorter(), nrOfThreads, bufferSize);
                return resourceLoader;
            }
        };
    }

    public static Provider<IResourceLoader> getParallelLoader(final int nrOfThreads, final int bufferSize, final long timeoutTime, final TimeUnit timeoutUnit) {
        return new AbstractResourceLoaderProvider(){

            public IResourceLoader get() {
                ParallelResourceLoader resourceLoader = new ParallelResourceLoader(this.getResourceSetProvider(), this.getResourceSorter(), nrOfThreads, bufferSize);
                resourceLoader.setTimeout(timeoutTime, timeoutUnit);
                return resourceLoader;
            }
        };
    }

    public static Provider<IResourceLoader> getSerialLoader() {
        return new AbstractResourceLoaderProvider(){

            public IResourceLoader get() {
                return new SerialResourceLoader(this.getResourceSetProvider(), this.getResourceSorter());
            }
        };
    }

    public static abstract class AbstractResourceLoaderProvider
    implements Provider<IResourceLoader> {
        @Inject
        private IResourceSetProvider resourceSetProvider;
        @Inject
        private IResourceLoader.Sorter resourceSorter;

        public IResourceSetProvider getResourceSetProvider() {
            return this.resourceSetProvider;
        }

        public IResourceLoader.Sorter getResourceSorter() {
            return this.resourceSorter;
        }
    }
}

