/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.imports.ImportsAcceptor;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;

public class ImportsCollector {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;

    public void collectImports(XtextResource state, ITextRegion selectedRegion, ImportsAcceptor acceptor) {
        ICompositeNode rootNode = state.getParseResult().getRootNode();
        EObject selectedSemanticObj = this.findActualSemanticObjectFor(rootNode, selectedRegion);
        Iterable contentsIterator = NodeModelUtils.findActualNodeFor((EObject)selectedSemanticObj).getLeafNodes();
        for (ILeafNode node : contentsIterator) {
            EObject semanticElement;
            ITextRegion nodeRegion = node.getTotalTextRegion();
            boolean _contains = selectedRegion.contains(nodeRegion);
            if (_contains && (semanticElement = node.getSemanticElement()) != null) {
                this.visit(semanticElement, (INode)NodeModelUtils.findActualNodeFor((EObject)semanticElement), acceptor);
            }
            if (!node.isHidden() || !this.grammarAccess.getML_COMMENTRule().equals(node.getGrammarElement())) continue;
            this.addJavaDocReferences((INode)node, selectedRegion, acceptor);
        }
    }

    public EObject findActualSemanticObjectFor(ICompositeNode rootNode, ITextRegion textRegion) {
        ILeafNode leafNodeAtOffset = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)textRegion.getOffset());
        EObject semanticElementOffset = leafNodeAtOffset.getSemanticElement();
        ICompositeNode actualOffsetNode = NodeModelUtils.findActualNodeFor((EObject)semanticElementOffset);
        int _offset = textRegion.getOffset();
        int _length = textRegion.getLength();
        int endOffset = _offset + _length;
        while (actualOffsetNode.getParent() != null && actualOffsetNode.getTotalEndOffset() < endOffset) {
            actualOffsetNode = actualOffsetNode.getParent();
        }
        EObject actualSemanticObj = actualOffsetNode.getSemanticElement();
        return actualSemanticObj;
    }

    protected void _visit(EObject semanticObj, INode originNode, ImportsAcceptor acceptor) {
    }

    protected void _visit(JvmTypeReference semanticElement, INode originNode, ImportsAcceptor acceptor) {
        this.visit((EObject)semanticElement.getType(), originNode, acceptor);
    }

    protected void _visit(XAbstractFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        this.collectStaticImportsFrom(semanticObj, acceptor);
    }

    protected void _visit(XMemberFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        boolean _isExplicitStatic;
        boolean _not;
        if (semanticObj.getFeature() instanceof JvmType && semanticObj.isTypeLiteral()) {
            JvmIdentifiableElement _feature = semanticObj.getFeature();
            this.visit((EObject)((JvmType)_feature), originNode, acceptor);
        }
        boolean bl = _not = !(_isExplicitStatic = semanticObj.isExplicitStatic());
        if (_not) {
            boolean _isTypeLiteral;
            XExpression target = semanticObj.getMemberCallTarget();
            if (target instanceof XAbstractFeatureCall && (_isTypeLiteral = ((XAbstractFeatureCall)target).isTypeLiteral())) {
                return;
            }
            this.collectStaticImportsFrom(semanticObj, acceptor);
        }
    }

    protected void _visit(XFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        if (semanticObj.getFeature() instanceof JvmType && semanticObj.isTypeLiteral()) {
            JvmIdentifiableElement _feature = semanticObj.getFeature();
            this.visit((EObject)((JvmType)_feature), originNode, acceptor);
        } else {
            this.collectStaticImportsFrom(semanticObj, acceptor);
        }
    }

    protected void _visit(JvmGenericType jvmType, INode originNode, ImportsAcceptor acceptor) {
        boolean _isAnonymous = jvmType.isAnonymous();
        if (_isAnonymous) {
            this.visit((EObject)((JvmTypeReference)IterableExtensions.last((Iterable)jvmType.getSuperTypes())).getType(), originNode, acceptor);
        } else {
            this._visit((JvmDeclaredType)jvmType, originNode, acceptor);
        }
    }

    protected void _visit(JvmDeclaredType jvmType, INode originNode, ImportsAcceptor acceptor) {
        String text;
        String outerSegment;
        JvmDeclaredType outerType;
        boolean _tripleEquals;
        JvmDeclaredType _declaringType = jvmType.getDeclaringType();
        boolean bl = _tripleEquals = _declaringType == null;
        if (_tripleEquals) {
            this.collectTypeImportFrom(jvmType, acceptor);
        }
        if ((outerType = this.findDeclaringTypeBySimpleName(jvmType, outerSegment = this.getFirstNameSegment(text = NodeModelUtils.getTokenText((INode)originNode)))) == null) {
            throw new IllegalStateException();
        }
        this.collectTypeImportFrom(outerType, acceptor);
    }

    private JvmDeclaredType findDeclaringTypeBySimpleName(JvmDeclaredType referencedType, String outerSegment) {
        if (referencedType.getDeclaringType() == null || outerSegment.equals(referencedType.getSimpleName())) {
            return referencedType;
        }
        return this.findDeclaringTypeBySimpleName(referencedType.getDeclaringType(), outerSegment);
    }

    protected void _visit(XConstructorCall semanticElement, INode originNode, ImportsAcceptor acceptor) {
        this.visit((EObject)semanticElement.getConstructor().getDeclaringType(), originNode, acceptor);
    }

    protected void _visit(XAnnotation semanticElement, INode originNode, ImportsAcceptor acceptor) {
        this.visit((EObject)semanticElement.getAnnotationType(), originNode, acceptor);
    }

    protected void _visit(XTypeLiteral semanticElement, INode originNode, ImportsAcceptor acceptor) {
        List elementNode = NodeModelUtils.findNodesForFeature((EObject)semanticElement, (EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE);
        this.visit((EObject)semanticElement.getType(), (INode)IterableExtensions.head((Iterable)elementNode), acceptor);
    }

    protected void _visit(Void nullCase, INode originNode, ImportsAcceptor acceptor) {
    }

    protected void collectTypeImportFrom(JvmDeclaredType type, ImportsAcceptor acceptor) {
        acceptor.acceptTypeImport((JvmType)type);
    }

    protected void collectStaticImportsFrom(XAbstractFeatureCall abstractFeatureCall, ImportsAcceptor acceptor) {
        boolean _isStatic = abstractFeatureCall.isStatic();
        if (_isStatic) {
            boolean _isExtension = abstractFeatureCall.isExtension();
            if (_isExtension) {
                acceptor.acceptStaticExtensionImport(abstractFeatureCall);
            } else {
                acceptor.acceptStaticImport(abstractFeatureCall);
            }
        }
    }

    protected String getFirstNameSegment(String text_finalParam_) {
        String text = text_finalParam_;
        int firstDelimiter = text.indexOf(Character.valueOf('.').charValue());
        if (firstDelimiter == -1) {
            firstDelimiter = text.indexOf(Character.valueOf('$').charValue());
        } else {
            int dollar = text.indexOf(Character.valueOf('$').charValue());
            if (dollar != -1) {
                firstDelimiter = Math.min(firstDelimiter, dollar);
            }
        }
        if (firstDelimiter == -1) {
            firstDelimiter = text.indexOf("::");
            if (firstDelimiter == text.length() - 2 && firstDelimiter >= 0) {
                text = text.substring(0, firstDelimiter);
                firstDelimiter = -1;
            }
        } else {
            int colon = text.indexOf("::");
            if (colon != text.length() - 2 && colon != -1) {
                firstDelimiter = Math.min(firstDelimiter, colon);
            }
        }
        if (firstDelimiter != -1) {
            return text.substring(0, firstDelimiter);
        }
        return text;
    }

    private void addJavaDocReferences(INode documentationNode, ITextRegion selectedRegion, ImportsAcceptor acceptor) {
        List _computeTypeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(documentationNode);
        for (ReplaceRegion docTypeReference : _computeTypeRefRegions) {
            JvmDeclaredType casted;
            boolean _equals;
            boolean _not;
            int _length;
            int _offset = docTypeReference.getOffset();
            TextRegion referenceRange = new TextRegion(_offset, _length = docTypeReference.getLength());
            boolean _contains = selectedRegion.contains((ITextRegion)referenceRange);
            if (!_contains) continue;
            String docTypeText = docTypeReference.getText();
            EObject element = NodeModelUtils.findActualSemanticObjectFor((INode)documentationNode);
            IScope scope = this.scopeProvider.getScope(element, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
            IEObjectDescription singleElement = scope.getSingleElement(QualifiedName.create((String)docTypeText));
            JvmType referencedType = null;
            if (singleElement != null) {
                EObject _eObjectOrProxy = singleElement.getEObjectOrProxy();
                referencedType = (JvmType)_eObjectOrProxy;
            }
            if (!(referencedType instanceof JvmDeclaredType) || referencedType.eIsProxy() || !(_not = !(_equals = (casted = (JvmDeclaredType)referencedType).getQualifiedName().equals(docTypeText)))) continue;
            acceptor.acceptTypeImport((JvmType)casted);
        }
    }

    public void visit(EObject jvmType, INode originNode, ImportsAcceptor acceptor) {
        if (jvmType instanceof JvmGenericType) {
            this._visit((JvmGenericType)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof JvmDeclaredType) {
            this._visit((JvmDeclaredType)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XFeatureCall) {
            this._visit((XFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XMemberFeatureCall) {
            this._visit((XMemberFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XAbstractFeatureCall) {
            this._visit((XAbstractFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XConstructorCall) {
            this._visit((XConstructorCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XTypeLiteral) {
            this._visit((XTypeLiteral)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XAnnotation) {
            this._visit((XAnnotation)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof JvmTypeReference) {
            this._visit((JvmTypeReference)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType != null) {
            this._visit(jvmType, originNode, acceptor);
            return;
        }
        if (jvmType == null) {
            this._visit((Void)null, originNode, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(jvmType, originNode, acceptor).toString());
    }
}

