/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement;

import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class FBTypeDragAssistant
extends CommonDragAdapterAssistant {
    public Transfer[] getSupportedTransferTypes() {
        Transfer[] types = new Transfer[]{TemplateTransfer.getInstance()};
        return types;
    }

    public void dragStart(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        if (aSelection.getFirstElement() instanceof IFile) {
            IFile fbTypeFile = (IFile)aSelection.getFirstElement();
            Palette fbPalette = FBTypeUtils.getPalletteForFBTypeFile(fbTypeFile);
            if (fbPalette != null) {
                PaletteEntry entry = TypeLibrary.getPaletteEntry((Palette)fbPalette, (IFile)fbTypeFile);
                if (entry != null) {
                    TemplateTransfer.getInstance().setTemplate((Object)entry);
                }
            } else {
                anEvent.doit = false;
            }
        }
        super.dragStart(anEvent, aSelection);
    }

    public boolean setDragData(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        PaletteEntry entry;
        IFile fbTypeFile;
        Palette fbPalette;
        if (aSelection.getFirstElement() instanceof IFile && (fbPalette = FBTypeUtils.getPalletteForFBTypeFile(fbTypeFile = (IFile)aSelection.getFirstElement())) != null && (entry = TypeLibrary.getPaletteEntry((Palette)fbPalette, (IFile)fbTypeFile)) != null) {
            anEvent.data = entry;
            return true;
        }
        return false;
    }
}

