/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeContentOutline;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.TypeEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AdapterInterfaceElementSection
extends AbstractSection {
    private Text nameText;
    private Text commentText;
    protected Combo typeCombo;
    Collection<DataType> typeList;

    protected IInterfaceElement getInputType(Object input) {
        if (input instanceof InterfaceEditPart) {
            return ((InterfaceEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof TypeEditPart) {
            return ((TypeEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof CommentEditPart) {
            return ((CommentEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof Event) {
            return (Event)input;
        }
        if (input instanceof VarDeclaration) {
            return (VarDeclaration)input;
        }
        return null;
    }

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        if (part instanceof FBTypeEditor) {
            return ((FBTypeEditor)part).getCommandStack();
        }
        if (part instanceof ContentOutline) {
            return ((FBTypeContentOutline)((ContentOutline)part).getCurrentPage()).getCommandStack();
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(this.leftComposite);
    }

    private void createTypeAndCommentSection(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(parent, "Name:");
        this.nameText = this.createGroupText(parent, true);
        this.nameText.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdapterInterfaceElementSection.this.removeContentAdapter();
                AdapterInterfaceElementSection.this.executeCommand((Command)new ChangeNameCommand((INamedElement)AdapterInterfaceElementSection.this.getType(), AdapterInterfaceElementSection.this.nameText.getText()));
                AdapterInterfaceElementSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(parent, "Comment:");
        this.commentText = this.createGroupText(parent, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdapterInterfaceElementSection.this.removeContentAdapter();
                AdapterInterfaceElementSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)AdapterInterfaceElementSection.this.getType(), AdapterInterfaceElementSection.this.commentText.getText()));
                AdapterInterfaceElementSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(parent, "Type: ");
        this.typeCombo = new Combo(parent, 2060);
        GridData languageComboGridData = new GridData(4, 0, true, false);
        this.typeCombo.setLayoutData((Object)languageComboGridData);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataType newType = AdapterInterfaceElementSection.this.getTypeForSelection(AdapterInterfaceElementSection.this.typeCombo.getText());
                if (newType != null) {
                    AdapterInterfaceElementSection.this.executeCommand((Command)new ChangeTypeCommand((VarDeclaration)AdapterInterfaceElementSection.this.type, newType));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setInputCode() {
        this.nameText.setEnabled(false);
        this.commentText.setEnabled(false);
        this.typeCombo.removeAll();
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.setTypeDropdown();
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setTypeDropdown() {
        this.typeCombo.removeAll();
        this.typeList = this.getTypes();
        if (this.typeList != null) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (DataType type : this.typeList) {
                typeNames.add(type.getName());
            }
            Collections.sort(typeNames);
            String currTypeName = ((VarDeclaration)this.type).getType() != null ? ((VarDeclaration)this.type).getType().getName() : "";
            int i = 0;
            while (i < typeNames.size()) {
                this.typeCombo.add((String)typeNames.get(i));
                if (((String)typeNames.get(i)).equals(currTypeName)) {
                    this.typeCombo.select(i);
                }
                ++i;
            }
        }
    }

    protected Collection<DataType> getTypes() {
        ArrayList<DataType> types = new ArrayList<DataType>();
        FBType fbType = (FBType)this.getType().eContainer().eContainer();
        PaletteEntry entry = fbType.getPaletteEntry();
        for (AdapterTypePaletteEntry adaptertype : TypeEditPart.getAdapterTypes(entry.getGroup().getPallete())) {
            types.add((DataType)adaptertype.getAdapterType());
        }
        return types;
    }

    protected DataType getTypeForSelection(String text) {
        if (this.typeList != null) {
            for (DataType dataType : this.typeList) {
                if (!dataType.getName().equals(text)) continue;
                return dataType;
            }
        }
        return null;
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    protected void setInputInit() {
    }
}

