/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.ActionCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.STAlgorithmCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.StateCreationFactory;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.resource.ImageDescriptor;

public final class ECCPaletteFactory {
    private static final String PALETTE_DOCK_LOCATION = "ECCPaletteFactory.Location";
    private static final String PALETTE_SIZE = "ECCPaletteFactory.Size";
    private static final String PALETTE_STATE = "ECCPaletteFactory.State";

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        boolean val = Activator.getDefault().getPreferenceStore().contains(PALETTE_STATE);
        FlyoutPaletteComposite.FlyoutPreferences preferences = new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return Activator.getDefault().getPreferenceStore().getInt(ECCPaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return Activator.getDefault().getPreferenceStore().getInt(ECCPaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return Activator.getDefault().getPreferenceStore().getInt(ECCPaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                Activator.getDefault().getPreferenceStore().setValue(ECCPaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                Activator.getDefault().getPreferenceStore().setValue(ECCPaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                Activator.getDefault().getPreferenceStore().setValue(ECCPaletteFactory.PALETTE_SIZE, width);
            }
        };
        if (!val) {
            preferences.setPaletteState(4);
            preferences.setPaletteWidth(125);
        }
        return preferences;
    }

    public static PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        ECCPaletteFactory.fillPalette(palette);
        return palette;
    }

    private static void fillPalette(PaletteRoot palette) {
        PaletteGroup eccGroup = new PaletteGroup(Messages.ECCPaletteFactory_LABEL_ECCGroup);
        ImageDescriptor desc = FordiacImage.ICON_ECState.getImageDescriptor();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(Messages.ECCPaletteFactory_LABEL_State, Messages.ECCPaletteFactory_TOOLTIP_State, (CreationFactory)new StateCreationFactory(), desc, desc);
        eccGroup.add((PaletteEntry)combined);
        desc = FordiacImage.ICON_ECAction.getImageDescriptor();
        combined = new CombinedTemplateCreationEntry(Messages.ECCPaletteFactory_LABEL_Action, Messages.ECCPaletteFactory_TOOLTIP_Action, (CreationFactory)new ActionCreationFactory(), desc, desc);
        eccGroup.add((PaletteEntry)combined);
        desc = FordiacImage.ICON_Algorithm.getImageDescriptor();
        combined = new CombinedTemplateCreationEntry(Messages.ECCPaletteFactory_LABEL_STAlgorithm, Messages.ECCPaletteFactory_TOOLTIP_STAlgorithm, (CreationFactory)new STAlgorithmCreationFactory(), desc, desc);
        eccGroup.add((PaletteEntry)combined);
        palette.add((PaletteEntry)eccGroup);
    }
}

