/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.TransitionCreateCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECStateEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECTransitionEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.ui.IEditorPart;

public class ReconnectTransitionCommand
extends Command {
    protected final ReconnectRequest request;
    private IEditorPart editor;
    protected DeleteTransitionCommand cmd;
    protected TransitionCreateCommand dccc;

    public boolean canUndo() {
        return this.editor.equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public ReconnectTransitionCommand(ReconnectRequest request) {
        super("Reconnect Transition");
        this.request = request;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
        if (this.request.getType().equals("Reconnection target")) {
            this.doReconnectTarget();
        }
        if (this.request.getType().equals("Reconnection source")) {
            this.doReconnectSource();
        }
    }

    protected void doReconnectSource() {
        ECTransition transition = ((ECTransitionEditPart)this.request.getConnectionEditPart()).getCastedModel();
        this.cmd = new DeleteTransitionCommand(transition);
        this.dccc = new TransitionCreateCommand();
        this.dccc.setSource(((ECStateEditPart)this.request.getTarget()).getCastedModel());
        this.dccc.setDestination(((ECStateEditPart)this.request.getConnectionEditPart().getTarget()).getCastedModel());
        this.dccc.setDestinationLocation(new Point(this.dccc.getDestination().getX(), this.dccc.getDestination().getY()));
        this.dccc.setSourceLocation(this.request.getLocation());
        this.dccc.setConditionEvent(transition.getConditionEvent());
        this.dccc.setConditionExpression(transition.getConditionExpression());
        this.cmd.execute();
        this.dccc.execute();
    }

    protected void doReconnectTarget() {
        ECTransition transition = ((ECTransitionEditPart)this.request.getConnectionEditPart()).getCastedModel();
        this.cmd = new DeleteTransitionCommand(transition);
        this.dccc = new TransitionCreateCommand();
        this.dccc.setSource(((ECStateEditPart)this.request.getConnectionEditPart().getSource()).getCastedModel());
        this.dccc.setDestination(((ECStateEditPart)this.request.getTarget()).getCastedModel());
        this.dccc.setDestinationLocation(this.request.getLocation());
        this.dccc.setSourceLocation(new Point(this.dccc.getSource().getX(), this.dccc.getSource().getY()));
        this.dccc.setConditionEvent(transition.getConditionEvent());
        this.dccc.setConditionExpression(transition.getConditionExpression());
        this.cmd.execute();
        this.dccc.execute();
    }

    public void redo() {
        this.cmd.redo();
        this.dccc.redo();
    }

    public void undo() {
        this.dccc.undo();
        this.cmd.undo();
    }
}

