/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.IAlgorithmEditor;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;

public class XTextAlgorithmEditor
implements IAlgorithmEditor {
    private EmbeddedEditor editor;
    private EmbeddedEditorModelAccess embeddedEditorModelAccess;
    private BasicFBType fbType;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (8 != notification.getEventType() && !(notification.getNotifier() instanceof Algorithm)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (XTextAlgorithmEditor.this.editor.getViewer() != null && XTextAlgorithmEditor.this.editor.getViewer().getControl() != null && !XTextAlgorithmEditor.this.editor.getViewer().getControl().isDisposed()) {
                            XTextAlgorithmEditor.this.updatePrefix();
                        }
                    }
                });
            }
        }
    };
    int prefixeLineCount = 0;
    private boolean documentValid = true;

    public XTextAlgorithmEditor(EmbeddedEditor editor, BasicFBType fbType) {
        this.editor = editor;
        this.fbType = fbType;
        this.embeddedEditorModelAccess = this.editor.createPartialEditor("", "", "", true);
        LineNumberRulerColumn lnrc = new LineNumberRulerColumn(){

            protected String createDisplayString(int line) {
                return super.createDisplayString(line -= XTextAlgorithmEditor.this.prefixeLineCount);
            }
        };
        this.getViewer().addVerticalRulerColumn((IVerticalRulerColumn)lnrc);
        AbstractRulerColumn column = new AbstractRulerColumn(){};
        this.getViewer().addVerticalRulerColumn((IVerticalRulerColumn)column);
        this.fbType.eAdapters().add((Object)this.adapter);
        editor.getViewer().getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XTextAlgorithmEditor.this.getFBType().eAdapters().remove((Object)XTextAlgorithmEditor.this.adapter);
            }
        });
        this.updatePrefix();
    }

    protected BasicFBType getFBType() {
        return this.fbType;
    }

    private XtextSourceViewer getViewer() {
        return this.editor.getViewer();
    }

    @Override
    public void addDocumentListener(IDocumentListener listener) {
        this.editor.getDocument().addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(IDocumentListener listener) {
        this.editor.getDocument().removeDocumentListener(listener);
    }

    @Override
    public void setAlgorithmText(String text) {
        this.embeddedEditorModelAccess.updateModel(this.regeneratePrefix(), text, "");
    }

    @Override
    public String getAlgorithmText() {
        return this.embeddedEditorModelAccess.getEditablePart();
    }

    @Override
    public Control getControl() {
        return this.getViewer().getControl();
    }

    private void updatePrefix() {
        this.documentValid = false;
        this.embeddedEditorModelAccess.updatePrefix(this.regeneratePrefix());
        try {
            this.prefixeLineCount = this.getViewer().getDocument().getNumberOfLines(0, this.getViewer().getVisibleRegion().getOffset());
            --this.prefixeLineCount;
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        this.documentValid = true;
    }

    protected String regeneratePrefix() {
        return "";
    }

    @Override
    public boolean isDocumentValid() {
        return this.documentValid;
    }
}

