/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtest;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.commands.StartAutomaticRemoteTest;
import org.eclipse.fordiac.ide.model.Palette.provider.PaletteItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class FBTestEditor
extends GraphicalEditorWithFlyoutPalette
implements IFBTEditorPart {
    private FBType type;
    private Composite resultContainer;
    private Document document;
    private TextViewer resultViewer;
    private ComposedAdapterFactory adapterFactory;
    private CommandStack commandStack;
    private final IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            FBTestEditor.this.document = new Document(event.getDocument().get());
            FBTestEditor.this.resultViewer.setDocument((IDocument)FBTestEditor.this.document);
            FBTestEditor.this.resultViewer.refresh();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    public FBTestEditor() {
        this.document = new Document();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.type = untypedInput.getContent();
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        this.setPartName("FBTest");
        this.setTitleImage(FordiacImage.ICON_FBTest.getImage());
        super.init(site, input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTestControl(parent);
        this.createResultView(parent);
    }

    protected void createResultView(Composite parent) {
        GridData testResultGridData = new GridData(4, 4, true, true);
        SashForm resform = new SashForm(parent, 260);
        resform.setLayout((Layout)new GridLayout());
        resform.setLayoutData((Object)testResultGridData);
        this.createSequenceTreeViewer((Composite)resform);
        this.resultContainer = new Composite((Composite)resform, 2048);
        this.resultContainer.setLayout((Layout)new GridLayout());
        this.resultContainer.setLayoutData((Object)testResultGridData);
        this.resultViewer = new TextViewer(this.resultContainer, 512);
        this.resultViewer.getControl().setLayoutData((Object)testResultGridData);
        this.resultViewer.setDocument((IDocument)this.document);
        this.document.addDocumentListener(this.listener);
        this.document.set("");
    }

    protected void createTestControl(Composite parent) {
        Composite seqContainer = new Composite(parent, 2048);
        seqContainer.setLayout((Layout)new GridLayout());
        seqContainer.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite buttonContainer = new Composite(seqContainer, 0);
        buttonContainer.setLayout((Layout)new FillLayout());
        Button addButton = new Button(buttonContainer, 0);
        addButton.setImage(FordiacImage.ICON_Download.getImage());
        addButton.setText("Start Test");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StartAutomaticRemoteTest cmd = new StartAutomaticRemoteTest(FBTestEditor.this.type, (IDocument)FBTestEditor.this.document);
                FBTestEditor.this.getCommandStack().execute((Command)cmd);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    private void createSequenceTreeViewer(Composite composite) {
        TreeViewer serviceSequencesViewer = new TreeViewer(composite, 2820);
        GridData serviceSequenceData = new GridData();
        serviceSequenceData.horizontalAlignment = 4;
        serviceSequenceData.verticalAlignment = 4;
        serviceSequenceData.grabExcessHorizontalSpace = true;
        serviceSequenceData.grabExcessVerticalSpace = true;
        serviceSequencesViewer.getTree().setLayoutData((Object)serviceSequenceData);
        serviceSequencesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory()));
        TestResultLabelProvider myLP = new TestResultLabelProvider();
        serviceSequencesViewer.setLabelProvider((IBaseLabelProvider)myLP);
        new AdapterFactoryTreeEditor(serviceSequencesViewer.getTree(), (AdapterFactory)this.adapterFactory);
        serviceSequencesViewer.setInput((Object)this.type.getService());
    }

    private ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new PaletteItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DataItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return this.adapterFactory;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public class TestResultLabelProvider
    extends ColumnLabelProvider
    implements ILabelDecorator {
        private static final int testOK = 1;
        private static final int testFailed = -1;
        private static final int noTest = 0;
        private AdapterFactoryLabelProvider adpFactLabelProvider;
        private Map<Integer, ImageDescriptor> decorators = new HashMap<Integer, ImageDescriptor>();

        public TestResultLabelProvider() {
            this.adpFactLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)FBTestEditor.this.getAdapterFactory());
            this.decorators.put(-1, FordiacImage.ICON_TestFailed.getImageDescriptor());
            this.decorators.put(1, FordiacImage.ICON_TestOK.getImageDescriptor());
            this.decorators.put(0, FordiacImage.ICON_NoTest.getImageDescriptor());
        }

        public Image getImage(Object element) {
            return this.adpFactLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            return this.adpFactLabelProvider.getText(element);
        }

        private int getStatus(Object object) {
            int retval = 0;
            if (object instanceof ServiceTransaction) {
                retval = ((ServiceTransaction)object).getTestResult();
            } else if (object instanceof ServiceSequence) {
                retval = ((ServiceSequence)object).getTestResult();
            } else {
                if (object instanceof InputPrimitive) {
                    retval = -17;
                }
                if (object instanceof OutputPrimitive) {
                    retval = ((OutputPrimitive)object).getTestResult();
                }
            }
            return retval;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element));
            Image image = this.getImage(element);
            Image decImage = this.decorateImage(image, element);
            cell.setBackground(this.getBackground(element));
            cell.setForeground(this.getForeground(element));
            cell.setImage(decImage);
            cell.setFont(this.getFont(element));
        }

        public Image decorateImage(Image image, Object element) {
            Image retval;
            ImageDescriptor imgDesc = this.decorators.get(this.getStatus(element));
            if (imgDesc != null) {
                DecorationOverlayIcon decOverlay = new DecorationOverlayIcon(image, imgDesc, 3);
                retval = decOverlay.createImage();
            } else {
                retval = image;
            }
            return retval;
        }

        public String decorateText(String text, Object element) {
            return null;
        }
    }
}

