/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.Palette.PalettePackage;
import org.eclipse.fordiac.ide.model.Palette.impl.PaletteEntryImpl;
import org.eclipse.fordiac.ide.model.dataimport.ADPImporter;
import org.eclipse.fordiac.ide.model.dataimport.DEVImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.IPaletteEntryCreator;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryTags;
import org.eclipse.fordiac.ide.ui.controls.ReferenceChooserDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TypeLibrary
implements TypeLibraryTags {
    private Palette palette = PaletteFactory.eINSTANCE.createPalette();
    private final PaletteGroup paletteGroup = PaletteFactory.eINSTANCE.createPaletteGroup();
    private static IPaletteEntryCreator[] paletteCreators = null;
    private static TypeLibrary instance;
    private static PalettePackage pack;

    static {
        pack = PalettePackage.eINSTANCE;
    }

    public static String getTypeNameFromFile(IFile element) {
        return TypeLibrary.getTypeNameFromFileName(element.getName());
    }

    public static String getTypeNameFromFileName(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (-1 != index) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static boolean isIEC61499TypeFile(String filename) {
        return filename.toUpperCase().endsWith(".FBT") || filename.toUpperCase().endsWith(".ADP") || filename.toUpperCase().endsWith(".DEV") || filename.toUpperCase().endsWith(".RES") || filename.toUpperCase().endsWith(".SEG");
    }

    public static PaletteGroup getPaletteGroup(Palette palette, IContainer groupDst) {
        String[] groups = groupDst.getProjectRelativePath().toString().split("/");
        if (groups.length == 0 || 1 == groups.length && groups[0].length() == 0) {
            return palette.getRootGroup();
        }
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.addAll(Arrays.asList(groups));
        if ("Tool Library".equals(groupList.get(0))) {
            groupList.remove(0);
        }
        return palette.findGroup(groupList);
    }

    public static PaletteGroup getPaletteGroupWithAdd(Palette palette, IContainer groupDst) {
        String[] groups = groupDst.getProjectRelativePath().toString().split("/");
        if (groups.length == 0 || 1 == groups.length && groups[0].length() == 0) {
            return palette.getRootGroup();
        }
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.addAll(Arrays.asList(groups));
        if ("Tool Library".equals(groupList.get(0))) {
            groupList.remove(0);
        }
        return palette.getGroup(groupList, false);
    }

    public static PaletteEntry getPaletteEntry(Palette palette, IFile entryTypeFile) {
        PaletteEntry retVal = null;
        PaletteGroup group = TypeLibrary.getPaletteGroup(palette, entryTypeFile.getParent());
        if (group != null) {
            retVal = group.getEntry(TypeLibrary.getTypeNameFromFile(entryTypeFile));
        }
        return retVal;
    }

    private TypeLibrary() {
    }

    public static TypeLibrary getInstance() {
        if (instance == null) {
            TypeLibrary newTypeLib = new TypeLibrary();
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject toolLibProject = myWorkspaceRoot.getProject("Tool Library");
            if (toolLibProject.exists()) {
                try {
                    toolLibProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
            }
            newTypeLib.loadPalette();
            instance = newTypeLib;
        }
        return instance;
    }

    public Palette getPalette() {
        if (this.palette.getRootGroup() == null) {
            this.palette.setRootGroup(this.paletteGroup);
        }
        if (this.palette.getRootGroup().getLabel() == null) {
            this.palette.getRootGroup().setLabel("typelibrary");
        }
        return this.palette;
    }

    public Palette loadPalette() {
        IFolder toolLibFolder = this.getToolLibFolder();
        this.palette = TypeLibrary.loadPalette((IContainer)toolLibFolder);
        return this.palette;
    }

    public static Palette loadPalette(IContainer container) {
        Palette newPalette = PaletteFactory.eINSTANCE.createPalette();
        TypeLibrary.loadPaletteGroupMembers(newPalette, container, newPalette.getRootGroup());
        return newPalette;
    }

    private static void loadPaletteGroupMembers(Palette palette, IContainer container, PaletteGroup group) {
        try {
            IResource[] members;
            if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
                container.refreshLocal(1, null);
            }
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    TypeLibrary.createPaletteGroup(palette, group, (IFolder)iResource);
                }
                if (iResource instanceof IFile) {
                    TypeLibrary.createPaleteEntry(palette, group, (IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static PaletteEntry createPaleteEntry(Palette palette, PaletteGroup group, IFile file) {
        IPaletteEntryCreator[] creators;
        PaletteEntryImpl entry = null;
        IPaletteEntryCreator[] iPaletteEntryCreatorArray = creators = TypeLibrary.getPaletteCreators();
        int n = creators.length;
        int n2 = 0;
        while (n2 < n) {
            IPaletteEntryCreator in = iPaletteEntryCreatorArray[n2];
            if (in.canHandle(file)) {
                entry = in.createPaletteEntry();
                TypeLibrary.configurePaletteEntry(entry, file, group);
            }
            ++n2;
        }
        return entry;
    }

    private static void setPaletteCreators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.model", "PaletteEntryCreator");
        int countPaletteCreater = 0;
        paletteCreators = new IPaletteEntryCreator[elems.length];
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement elem = elems[i];
            try {
                Object object = elem.createExecutableExtension("class");
                if (object instanceof IPaletteEntryCreator) {
                    TypeLibrary.paletteCreators[countPaletteCreater] = (IPaletteEntryCreator)object;
                    ++countPaletteCreater;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
            ++i;
        }
    }

    private static IPaletteEntryCreator[] getPaletteCreators() {
        if (paletteCreators == null) {
            TypeLibrary.setPaletteCreators();
        }
        return paletteCreators;
    }

    private static void configurePaletteEntry(PaletteEntry entry, IFile file, PaletteGroup parent) {
        entry.setType(null);
        entry.setLabel(TypeLibrary.getTypeNameFromFile(file));
        entry.setFile(file);
        parent.addEntry(entry);
    }

    private static void createPaletteGroup(Palette palette, PaletteGroup parent, IFolder groupFolder) {
        PaletteGroup newGroup = palette.createGroup(parent, groupFolder.getName());
        TypeLibrary.loadPaletteGroupMembers(palette, (IContainer)groupFolder, newGroup);
        if (newGroup.isEmpty()) {
            parent.getSubGroups().remove((Object)newGroup);
        }
    }

    public static void refreshPalette(Palette palette) {
        IContainer container = TypeLibrary.getLibPath(palette);
        try {
            container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        TypeLibrary.checkDeletionsForGroup(palette, container, palette.getRootGroup());
        TypeLibrary.checkAdditions(palette, container, palette.getRootGroup());
    }

    private static void checkDeletionsForGroup(Palette palette, IContainer container, PaletteGroup group) {
        int i = 0;
        while (i < group.getEntries().size()) {
            PaletteEntry paletteEntry = (PaletteEntry)group.getEntries().get(i);
            if (!paletteEntry.getFile().exists()) {
                group.getEntries().remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < group.getSubGroups().size()) {
            PaletteGroup subGroup = (PaletteGroup)group.getSubGroups().get(i);
            IFolder folder = container.getFolder((IPath)new Path(subGroup.getLabel()));
            if (!folder.exists()) {
                group.getSubGroups().remove(i);
                continue;
            }
            TypeLibrary.checkDeletionsForGroup(palette, (IContainer)folder, subGroup);
            ++i;
        }
    }

    private static void checkAdditions(Palette palette, IContainer container, PaletteGroup group) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    PaletteGroup subgroup = group.getGroup(((IFolder)iResource).getName());
                    if (subgroup == null) {
                        TypeLibrary.createPaletteGroup(palette, group, (IFolder)iResource);
                    } else {
                        TypeLibrary.checkAdditions(palette, (IContainer)((IFolder)iResource), subgroup);
                    }
                }
                if (iResource instanceof IFile && group.getEntry(TypeLibrary.getTypeNameFromFile((IFile)iResource)) == null) {
                    TypeLibrary.createPaleteEntry(palette, group, (IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static IContainer getLibPath(Palette palette) {
        Object libPath = null;
        AutomationSystem system = palette.getAutomationSystem();
        libPath = system == null ? TypeLibrary.getInstance().getToolLibFolder() : system.getProject();
        return libPath;
    }

    public IFolder getToolLibFolder() {
        IFolder toolLibFolder;
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject toolLibProject = myWorkspaceRoot.getProject("Tool Library");
        if (!toolLibProject.exists()) {
            TypeLibrary.createToolLibProject(toolLibProject);
        }
        if (!(toolLibFolder = toolLibProject.getFolder("Tool Library")).exists()) {
            TypeLibrary.createToolLibLink(toolLibProject);
            toolLibFolder = toolLibProject.getFolder("Tool Library");
        }
        return toolLibFolder;
    }

    private static void createToolLibProject(IProject toolLibProject) {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        try {
            toolLibProject.create((IProgressMonitor)progressMonitor);
            toolLibProject.open((IProgressMonitor)progressMonitor);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        TypeLibrary.createToolLibLink(toolLibProject);
    }

    private static void createToolLibLink(IProject toolLibProject) {
        String typeLibPath;
        Path location;
        IFolder link;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.validateLinkLocation((IResource)(link = toolLibProject.getFolder("Tool Library")), (IPath)(location = (typeLibPath = System.getProperty("4diac.typelib.path")) != null && !typeLibPath.isEmpty() ? new Path(typeLibPath) : new Path(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "typelibrary"))).isOK()) {
            try {
                link.createLink((IPath)location, 0, null);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public static void loadAdapterType(PaletteEntry entry, Palette palette) {
        if (((AdapterTypePaletteEntry)entry).getAdapterType() == null) {
            AdapterType type = null;
            if ("ADP".equalsIgnoreCase(entry.getFile().getFileExtension())) {
                type = ADPImporter.importAdapterType(entry.getFile());
                ((AdapterTypePaletteEntry)entry).setType(type);
            }
        }
    }

    public static boolean importTypeFile(File srcFile, Palette palette, String relativeDestionationPath, boolean overWrite, Set<String> selectedFiles, Shell shell) {
        boolean retval = false;
        if (!srcFile.isDirectory()) {
            try {
                PaletteGroup group = TypeLibrary.performTypeSpecificImportPreparation(srcFile, palette, relativeDestionationPath, overWrite, selectedFiles, shell);
                IFile dstFile = TypeLibrary.getLibPath(palette).getFile((IPath)new Path(relativeDestionationPath));
                int retVal = 64;
                if (dstFile.exists() && !overWrite) {
                    MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 192);
                    String msg = MessageFormat.format(Messages.TypeLibrary_OverwriteMessage, dstFile.getFullPath().toOSString());
                    box.setMessage(msg);
                    retVal = box.open();
                    if (retVal == 64 && group != null) {
                        group.removeEntryNamed(TypeLibrary.getTypeNameFromFile(dstFile));
                    }
                }
                if (retVal == 64) {
                    ImportUtils.copyFile(srcFile, dstFile);
                    retval = true;
                } else {
                    String msg = MessageFormat.format(Messages.TypeLibrary_ImportAbortByUser, srcFile.getName());
                    Activator.getDefault().logError(msg, new TypeImportException(Messages.TypeLibrary_FBTImportException));
                }
            }
            catch (Exception e) {
                Activator.getDefault().logError("Exception occured during type import", e);
            }
        }
        return retval;
    }

    private static PaletteGroup performTypeSpecificImportPreparation(File srcFile, Palette palette, String relativeDestionationPath, boolean overWrite, Set<String> selectedFiles, Shell shell) throws TypeImportException, CoreException {
        PaletteGroup group = null;
        if (srcFile.getName().toUpperCase().endsWith("FBT")) {
            DataTypeLibrary.getInstance().loadReferencedDataTypes(srcFile, shell);
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".FBT");
            TypeLibrary.loadReferencedFBTypes(srcFile, palette, group, relativeDestionationPath, selectedFiles, shell);
        } else if (srcFile.getName().toUpperCase().endsWith("ADP")) {
            DataTypeLibrary.getInstance().loadReferencedDataTypes(srcFile, shell);
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".ADP");
        } else if (srcFile.getName().toUpperCase().endsWith("DEV")) {
            DataTypeLibrary.getInstance().loadReferencedDataTypes(srcFile, shell);
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".DEV");
            TypeLibrary.loadReferencedRESTypes(srcFile, palette, group, relativeDestionationPath, selectedFiles, shell);
        } else if (srcFile.getName().toUpperCase().endsWith("RES")) {
            DataTypeLibrary.getInstance().loadReferencedDataTypes(srcFile, shell);
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".RES");
            TypeLibrary.loadReferencedFBTypes(srcFile, palette, group, relativeDestionationPath, selectedFiles, shell);
        } else if (srcFile.getName().toUpperCase().endsWith("SEG")) {
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".SEG");
        } else if (srcFile.getName().toUpperCase().endsWith("SUB")) {
            DataTypeLibrary.getInstance().loadReferencedDataTypes(srcFile, shell);
            group = TypeLibrary.getTargetGroup(relativeDestionationPath, palette, ".SUB");
            TypeLibrary.loadReferencedFBTypes(srcFile, palette, group, relativeDestionationPath, selectedFiles, shell);
        }
        return group;
    }

    public static void loadReferencedFBTypes(File srcFile, Palette palette, PaletteGroup group, String relativeDestionationPath, Set<String> selectedFiles, Shell shell) throws TypeImportException {
        List<String> referencedFBTypes = FBTImporter.getReferencedFBTypes(srcFile);
        for (String typeName : referencedFBTypes) {
            if (TypeLibrary.checkForReferencedTypeInPalette(palette, typeName, shell) || TypeLibrary.checkForReferencedTypeInImportList(typeName, selectedFiles)) continue;
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            FileDialog fd = new FileDialog(shell);
            String msg = MessageFormat.format(Messages.TypeLibrary_LoadReferencedFile_DialogTitle, typeName);
            fd.setText(msg);
            fd.setFilterExtensions(new String[]{"*.fbt"});
            String typeFile = fd.open();
            if (typeFile == null) {
                throw new TypeImportException(Messages.TypeLibrary_ERROR_ReferencedTypeNotFound);
            }
            TypeLibrary.importTypeFile(new File(typeFile), palette, relativeDestionationPath, false, selectedFiles, shell);
            List<PaletteEntry> currentlyImported = palette.getTypeEntries(typeName);
            if (currentlyImported.size() == 1) continue;
            throw new TypeImportException(Messages.TypeLibrary_ERROR_ReferencedTypeNotFound);
        }
    }

    private static boolean checkForReferencedTypeInImportList(String typeName, Set<String> selectedFiles) {
        for (String name : selectedFiles) {
            String[] path = name.split(ImportUtils.getSeperatorRegex());
            String fbName = path[path.length - 1];
            String[] splitFBName = fbName.split("\\.");
            if (splitFBName.length != 2 || !splitFBName[0].equals(typeName)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForReferencedTypeInPalette(Palette palette, String typeName, Shell shell) {
        final List<PaletteEntry> fbTypes = palette.getTypeEntries(typeName);
        if (fbTypes.size() != 1) {
            if (fbTypes.size() > 1) {
                ReferenceChooserDialog referenceChooser;
                int retVal;
                if (shell == null) {
                    shell = Display.getCurrent().getActiveShell();
                }
                if ((retVal = (referenceChooser = new ReferenceChooserDialog((IContentProvider)new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return fbTypes.toArray();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                }, (IBaseLabelProvider)new ITableLabelProvider(){

                    public String getColumnText(Object element, int columnIndex) {
                        return element.toString();
                    }

                    public Image getColumnImage(Object element, int columnIndex) {
                        return null;
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                }, shell)).open()) != 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static PaletteGroup getTargetGroup(String groupPath, Palette palette, String typeFileEnding) throws CoreException {
        String[] path = groupPath.split(ImportUtils.getSeperatorRegex());
        ArrayList<String> buf = new ArrayList<String>(Arrays.asList(path));
        if (path[0].length() == 0) {
            buf.remove(0);
        }
        if (buf.get(buf.size() - 1).toUpperCase().endsWith(typeFileEnding.toUpperCase())) {
            buf.remove(buf.size() - 1);
            buf.size();
        }
        return palette.getGroup(buf, true);
    }

    public static void loadReferencedRESTypes(File srcFile, Palette palette, PaletteGroup group, String relativeDestPath, Set<String> selectedFiles, Shell shell) throws TypeImportException {
        List<String> referencedTypes = DEVImporter.getReferencedTypes(srcFile);
        for (String typeName : referencedTypes) {
            if (TypeLibrary.checkForReferencedTypeInPalette(palette, typeName, shell) || TypeLibrary.checkForReferencedTypeInImportList(typeName, selectedFiles)) continue;
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            FileDialog fd = new FileDialog(shell);
            String msg = MessageFormat.format(Messages.TypeLibrary_LoadReferencedFile_DialogTitle, typeName);
            fd.setText(msg);
            fd.setFilterExtensions(new String[]{"*.fbt"});
            String typeFile = fd.open();
            if (typeFile == null) {
                throw new TypeImportException(Messages.TypeLibrary_ERROR_ReferencedTypeNotFound);
            }
            TypeLibrary.importTypeFile(new File(typeFile), palette, relativeDestPath, false, selectedFiles, shell);
            List<PaletteEntry> currentlyImported = palette.getTypeEntries(typeName);
            if (currentlyImported.size() == 1) continue;
            throw new TypeImportException(Messages.TypeLibrary_ERROR_ReferencedTypeNotFound);
        }
    }
}

