/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.spi.Service;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private List<Service> serviceList = new ArrayList<Service>();
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean indexMetaInf = false;
    private boolean createEmpty = false;
    private Vector<String> rootEntries;
    private Path indexJars;
    private StrictMode strict = new StrictMode("ignore");
    private boolean mergeClassPaths = false;
    private boolean flattenClassPaths = false;
    private static final ZipExtraField[] JAR_MARKER = new ZipExtraField[]{JarMarker.getInstance()};

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
        this.setZip64Mode(Zip.Zip64ModeAttribute.NEVER);
        this.rootEntries = new Vector();
    }

    @Override
    public void setWhenempty(Zip.WhenEmpty we) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setWhenmanifestonly(Zip.WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setStrict(StrictMode strict) {
        this.strict = strict;
    }

    public void setJarfile(File jarFile) {
        this.setDestFile(jarFile);
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setIndexMetaInf(boolean flag) {
        this.indexMetaInf = flag;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest, false, this.mergeClassPaths);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            throw new BuildException("Manifest file: " + manifestFile + " does not exist.", this.getLocation());
        }
        this.manifestFile = manifestFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File manifestFile) {
        Manifest newManifest = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(manifestFile);
            isr = this.manifestEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.manifestEncoding);
            newManifest = this.getManifest(isr);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
                catch (IOException e2) {
                    throw new BuildException("Unable to read manifest file: " + manifestFile + " (" + e2.getMessage() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(isr);
                throw throwable;
            }
        }
        FileUtils.close(isr);
        return newManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifestFromJar(File jarFile) throws IOException {
        Manifest manifest;
        java.util.zip.ZipFile zf;
        block4: {
            Manifest manifest2;
            zf = null;
            try {
                zf = new java.util.zip.ZipFile(jarFile);
                Enumeration<? extends java.util.zip.ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    java.util.zip.ZipEntry ze = e.nextElement();
                    if (!ze.getName().equalsIgnoreCase(MANIFEST_NAME)) continue;
                    InputStreamReader isr = new InputStreamReader(zf.getInputStream(ze), "UTF-8");
                    manifest = this.getManifest(isr);
                    break block4;
                }
                manifest2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.close(zf);
                throw throwable;
            }
            FileUtils.close(zf);
            return manifest2;
        }
        FileUtils.close(zf);
        return manifest;
    }

    private Manifest getManifest(Reader r) {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
        return newManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean jarHasIndex(File jarFile) throws IOException {
        boolean bl;
        java.util.zip.ZipFile zf;
        block4: {
            boolean bl2;
            zf = null;
            try {
                zf = new java.util.zip.ZipFile(jarFile);
                Enumeration<? extends java.util.zip.ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    java.util.zip.ZipEntry ze = e.nextElement();
                    if (!ze.getName().equalsIgnoreCase(INDEX_NAME)) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(zf);
                throw throwable;
            }
            FileUtils.close(zf);
            return bl2;
        }
        FileUtils.close(zf);
        return bl;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        boolean bl = this.mergeManifestsMain = config != null && "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addMetainf(ZipFileSet fs) {
        fs.setPrefix("META-INF/");
        super.addFileset(fs);
    }

    public void addConfiguredIndexJars(Path p) {
        if (this.indexJars == null) {
            this.indexJars = new Path(this.getProject());
        }
        this.indexJars.append(p);
    }

    public void addConfiguredService(Service service) {
        service.check();
        this.serviceList.add(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices(ZipOutputStream zOut) throws IOException {
        for (Service service : this.serviceList) {
            InputStream is = null;
            try {
                is = service.getAsStream();
                super.zipFile(is, zOut, "META-INF/services/" + service.getType(), System.currentTimeMillis(), null, 33188);
            }
            finally {
                FileUtils.close(is);
            }
        }
    }

    public void setMergeClassPathAttributes(boolean b) {
        this.mergeClassPaths = b;
    }

    public void setFlattenAttributes(boolean b) {
        this.flattenClassPaths = b;
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
            this.writeServices(zOut);
        }
    }

    private Manifest createManifest() throws BuildException {
        try {
            Manifest finalManifest;
            boolean mergeFileSetFirst;
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            boolean bl = mergeFileSetFirst = !this.mergeManifestsMain && this.filesetManifest != null && this.configuredManifest == null && this.manifest == null;
            if (mergeFileSetFirst) {
                finalManifest = new Manifest();
                finalManifest.merge(this.filesetManifest, false, this.mergeClassPaths);
                finalManifest.merge(Manifest.getDefaultManifest(), true, this.mergeClassPaths);
            } else {
                finalManifest = Manifest.getDefaultManifest();
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest, false, this.mergeClassPaths);
            }
            if (!mergeFileSetFirst) {
                finalManifest.merge(this.filesetManifest, false, this.mergeClassPaths);
            }
            finalManifest.merge(this.configuredManifest, !this.mergeManifestsMain, this.mergeClassPaths);
            finalManifest.merge(this.manifest, !this.mergeManifestsMain, this.mergeClassPaths);
            return finalManifest;
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest", e, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException {
        Enumeration<String> e = manifest.getWarnings();
        while (e.hasMoreElements()) {
            this.log("Manifest warning: " + e.nextElement(), 1);
        }
        this.zipDir((Resource)null, zOut, "META-INF/", 16877, JAR_MARKER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer, this.flattenClassPaths);
        if (writer.checkError()) {
            throw new IOException("Encountered an error writing the manifest");
        }
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        }
        finally {
            FileUtils.close(bais);
        }
        super.initZipOutputStream(zOut);
    }

    @Override
    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexList(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.zipFile.getName());
        this.writeIndexLikeList(new ArrayList<String>(this.addedDirs.keySet()), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            Manifest.Attribute classpath = mf.getMainSection().getAttribute("Class-Path");
            String[] cpEntries = null;
            if (classpath != null && classpath.getValue() != null) {
                StringTokenizer tok = new StringTokenizer(classpath.getValue(), " ");
                cpEntries = new String[tok.countTokens()];
                int c = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c++] = tok.nextToken();
                }
            }
            String[] indexJarEntries = this.indexJars.list();
            for (int i = 0; i < indexJarEntries.length; ++i) {
                String name = Jar.findJarName(indexJarEntries[i], cpEntries);
                if (name == null) continue;
                ArrayList<String> dirs = new ArrayList<String>();
                ArrayList<String> files = new ArrayList<String>();
                Jar.grabFilesAndDirs(indexJarEntries[i], dirs, files);
                if (dirs.size() + files.size() <= 0) continue;
                writer.println(name);
                this.writeIndexLikeList(dirs, files, writer);
                writer.println();
            }
        }
        if (writer.checkError()) {
            throw new IOException("Encountered an error writing jar index");
        }
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
        }
        finally {
            FileUtils.close(bais);
        }
    }

    @Override
    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (this.isFirstPass()) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.logWhenWriting("Warning: selected " + this.archiveType + " files include a " + INDEX_NAME + " which will be replaced by a newly generated one.", 1);
        } else {
            if (this.index && vPath.indexOf("/") == -1) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    private void filesetManifest(File file, InputStream is) throws IOException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            try {
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(isr);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.logWhenWriting("Found manifest to merge in file " + file, 3);
            try {
                Manifest newManifest = null;
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(isr);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest, false, this.mergeClassPaths);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (ManifestException e) {
                this.log("Manifest in file " + file + " is invalid: " + e.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e, this.getLocation());
            }
        }
    }

    @Override
    protected Zip.ArchiveState getResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        if (this.skipWriting) {
            Resource[][] manifests = this.grabManifests(rcs);
            int count = 0;
            for (int i = 0; i < manifests.length; ++i) {
                count += manifests[i].length;
            }
            this.log("found a total of " + count + " manifests in " + manifests.length + " resource collections", 3);
            return new Zip.ArchiveState(true, manifests);
        }
        if (zipFile.exists()) {
            try {
                this.originalManifest = this.getManifestFromJar(zipFile);
                if (this.originalManifest == null) {
                    this.log("Updating jar since the current jar has no manifest", 3);
                    needsUpdate = true;
                } else {
                    Manifest mf = this.createManifest();
                    if (!mf.equals(this.originalManifest)) {
                        this.log("Updating jar since jar manifest has changed", 3);
                        needsUpdate = true;
                    }
                }
            }
            catch (Throwable t) {
                this.log("error while reading original manifest in file: " + zipFile.toString() + " due to " + t.getMessage(), 1);
                needsUpdate = true;
            }
        } else {
            needsUpdate = true;
        }
        this.createEmpty = needsUpdate;
        if (!needsUpdate && this.index) {
            try {
                needsUpdate = !this.jarHasIndex(zipFile);
            }
            catch (IOException e) {
                needsUpdate = true;
            }
        }
        return super.getResourcesToAdd(rcs, zipFile, needsUpdate);
    }

    @Override
    protected boolean createEmptyZip(File zipFile) throws BuildException {
        if (!this.createEmpty) {
            return true;
        }
        if (this.emptyBehavior.equals("skip")) {
            if (!this.skipWriting) {
                this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
            }
            return true;
        }
        if (this.emptyBehavior.equals("fail")) {
            throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.getLocation());
        }
        ZipOutputStream zOut = null;
        try {
            if (!this.skipWriting) {
                this.log("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            }
            zOut = new ZipOutputStream(this.getDestFile());
            zOut.setEncoding(this.getEncoding());
            zOut.setUseZip64(this.getZip64Mode().getMode());
            if (this.isCompress()) {
                zOut.setMethod(8);
            } else {
                zOut.setMethod(0);
            }
            this.initZipOutputStream(zOut);
            this.finalizeZipOutputStream(zOut);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(zOut);
                this.createEmpty = false;
                throw throwable;
            }
        }
        FileUtils.close(zOut);
        this.createEmpty = false;
        return true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.checkJarSpec();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    private void checkJarSpec() {
        Manifest.Section mainSection;
        String br = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer();
        Manifest.Section section = mainSection = this.configuredManifest == null ? null : this.configuredManifest.getMainSection();
        if (mainSection == null) {
            message.append("No Implementation-Title set.");
            message.append("No Implementation-Version set.");
            message.append("No Implementation-Vendor set.");
        } else {
            if (mainSection.getAttribute("Implementation-Title") == null) {
                message.append("No Implementation-Title set.");
            }
            if (mainSection.getAttribute("Implementation-Version") == null) {
                message.append("No Implementation-Version set.");
            }
            if (mainSection.getAttribute("Implementation-Vendor") == null) {
                message.append("No Implementation-Vendor set.");
            }
        }
        if (message.length() > 0) {
            message.append(br);
            message.append("Location: ").append(this.getLocation());
            message.append(br);
            if (this.strict.getValue().equalsIgnoreCase("fail")) {
                throw new BuildException(message.toString(), this.getLocation());
            }
            this.logWhenWriting(message.toString(), this.strict.getLogLevel());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.emptyBehavior = "create";
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List<String> dirs, List<String> files, PrintWriter writer) {
        Collections.sort(dirs);
        Collections.sort(files);
        for (String dir : dirs) {
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos = dir.lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (!this.indexMetaInf && dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        for (String file : files) {
            writer.println(file);
        }
    }

    protected static String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<Object, String> matches = new TreeMap<Object, String>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o2).length() - ((String)o1).length();
                }
                return 0;
            }
        });
        block0: for (int i = 0; i < classpath.length; ++i) {
            if (fileName.endsWith(classpath[i])) {
                matches.put(classpath[i], classpath[i]);
                continue;
            }
            int slash = classpath[i].indexOf("/");
            String candidate = classpath[i];
            while (slash > -1) {
                if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                    matches.put(candidate, classpath[i]);
                    continue block0;
                }
                slash = candidate.indexOf("/");
            }
        }
        return matches.size() == 0 ? null : (String)matches.get(matches.firstKey());
    }

    protected static void grabFilesAndDirs(String file, List<String> dirs, List<String> files) throws IOException {
        try (ZipFile zf = new ZipFile(file, "utf-8");){
            Enumeration<ZipEntry> entries = zf.getEntries();
            HashSet<String> dirSet = new HashSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                if (ze.isDirectory()) {
                    dirSet.add(name);
                    continue;
                }
                if (name.indexOf("/") == -1) {
                    files.add(name);
                    continue;
                }
                dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
            }
            dirs.addAll(dirSet);
        }
    }

    private Resource[][] grabManifests(ResourceCollection[] rcs) {
        Resource[][] manifests = new Resource[rcs.length][];
        for (int i = 0; i < rcs.length; ++i) {
            Resource[][] resources = null;
            resources = rcs[i] instanceof FileSet ? this.grabResources(new FileSet[]{(FileSet)rcs[i]}) : this.grabNonFileSetResources(new ResourceCollection[]{rcs[i]});
            for (int j = 0; j < resources[0].length; ++j) {
                String name = resources[0][j].getName().replace('\\', '/');
                if (rcs[i] instanceof ArchiveFileSet) {
                    ArchiveFileSet afs = (ArchiveFileSet)rcs[i];
                    if (!"".equals(afs.getFullpath(this.getProject()))) {
                        name = afs.getFullpath(this.getProject());
                    } else if (!"".equals(afs.getPrefix(this.getProject()))) {
                        String prefix = afs.getPrefix(this.getProject());
                        if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                            prefix = prefix + "/";
                        }
                        name = prefix + name;
                    }
                }
                if (!name.equalsIgnoreCase(MANIFEST_NAME)) continue;
                manifests[i] = new Resource[]{resources[0][j]};
                break;
            }
            if (manifests[i] != null) continue;
            manifests[i] = new Resource[0];
        }
        return manifests;
    }

    public static class StrictMode
    extends EnumeratedAttribute {
        public StrictMode() {
        }

        public StrictMode(String value) {
            this.setValue(value);
        }

        @Override
        public String[] getValues() {
            return new String[]{"fail", "warn", "ignore"};
        }

        public int getLogLevel() {
            return this.getValue().equals("ignore") ? 3 : 1;
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

