/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.internal.launching.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.AntClasspathTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;

public class EditAntHomeEntryAction
extends RuntimeClasspathAction {
    private AntClasspathTab fTab;

    public EditAntHomeEntryAction(IClasspathViewer viewer, AntClasspathTab tab) {
        super(AntLaunchConfigurationMessages.EditAntHomeEntryAction_1, viewer);
        this.fTab = tab;
    }

    public void run() {
        IDialogSettings dialogSettings = AntUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get("org.eclipse.ant.ui.lastanthome");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(AntPreferencesMessages.AntClasspathBlock_3);
        dialog.setFilterPath(lastUsedPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        dialogSettings.put("org.eclipse.ant.ui.lastanthome", path);
        AntCorePreferences preferences = AntCorePlugin.getPlugin().getPreferences();
        String defaultHome = preferences.getAntHome();
        if (path.equalsIgnoreCase(defaultHome)) {
            path = null;
        }
        this.fTab.setDirty(true);
        IRuntimeClasspathEntry[] entries = this.getViewer().getEntries();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry2 entry2;
            IRuntimeClasspathEntry entry = entries[i];
            if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)((ClasspathEntry)entry).getDelegate()).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                ((AntHomeClasspathEntry)entry2).setAntHome(path);
                this.getViewer().refresh((Object)entry);
                this.getViewer().notifyChanged();
                return;
            }
            ++i;
        }
        this.getViewer().addEntries(new IRuntimeClasspathEntry[]{new AntHomeClasspathEntry(path)});
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

