/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.DataVariable;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.Event;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestPrimitive;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestSequence;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class FBTHelper {
    public static int getEISize(FBType fbType) {
        int retval = 0;
        try {
            retval = fbType.getInterfaceList().getEventInputs().size();
        }
        catch (Exception exception) {
            retval = 0;
        }
        return retval;
    }

    public static int getEOSize(FBType fbType) {
        int retval = 0;
        try {
            retval = fbType.getInterfaceList().getEventOutputs().size();
        }
        catch (Exception exception) {
            retval = 0;
        }
        return retval;
    }

    public static int getDISize(FBType fbType) {
        int retval = 0;
        try {
            retval = fbType.getInterfaceList().getInputVars().size();
        }
        catch (Exception exception) {
            retval = 0;
        }
        return retval;
    }

    public static int getDOSize(FBType fbType) {
        int retval = 0;
        try {
            retval = fbType.getInterfaceList().getOutputVars().size();
        }
        catch (Exception exception) {
            retval = 0;
        }
        return retval;
    }

    public static int getEIID(FBType fbType, String eventName) {
        int retval = -1;
        try {
            for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : fbType.getInterfaceList().getEventInputs()) {
                if (!entry.getName().equals(eventName)) continue;
                retval = fbType.getInterfaceList().getEventInputs().indexOf((Object)entry);
                break;
            }
        }
        catch (Exception exception) {
            retval = -2;
        }
        return retval;
    }

    public static int getEOID(FBType fbType, String eventName) {
        int retval = -1;
        try {
            for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : fbType.getInterfaceList().getEventOutputs()) {
                if (!entry.getName().equals(eventName)) continue;
                retval = fbType.getInterfaceList().getEventOutputs().indexOf((Object)entry);
                break;
            }
        }
        catch (Exception exception) {
            retval = -2;
        }
        return retval;
    }

    public static int getDIID(FBType fbType, String DIName) {
        int retval = -1;
        try {
            for (VarDeclaration entry : fbType.getInterfaceList().getInputVars()) {
                if (!entry.getName().equals(DIName)) continue;
                retval = fbType.getInterfaceList().getInputVars().indexOf((Object)entry);
                break;
            }
        }
        catch (Exception exception) {
            retval = -2;
        }
        return retval;
    }

    public static String getDIDataType(FBType fbType, int DIID) {
        String retval = null;
        try {
            if (DIID >= 0 && fbType.getInterfaceList().getInputVars().size() >= DIID) {
                retval = ((VarDeclaration)fbType.getInterfaceList().getInputVars().get(DIID)).getType().getName();
            }
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static int getDOID(FBType fbType, String DOName) {
        int retval = -1;
        try {
            for (VarDeclaration entry : fbType.getInterfaceList().getOutputVars()) {
                if (!entry.getName().equals(DOName)) continue;
                retval = fbType.getInterfaceList().getOutputVars().indexOf((Object)entry);
                break;
            }
        }
        catch (Exception exception) {
            retval = -2;
        }
        return retval;
    }

    public static String getDODataType(FBType fbType, int DOID) {
        String retval = null;
        try {
            if (DOID >= 0 && fbType.getInterfaceList().getOutputVars().size() >= DOID) {
                retval = ((VarDeclaration)fbType.getInterfaceList().getOutputVars().get(DOID)).getType().getName();
            }
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static String getDINameByIndex(FBType fbType, int index) {
        String retval = null;
        try {
            retval = ((VarDeclaration)fbType.getInterfaceList().getInputVars().get(index)).getName();
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static String getDONameByIndex(FBType fbType, int index) {
        String retval = null;
        try {
            retval = ((VarDeclaration)fbType.getInterfaceList().getOutputVars().get(index)).getName();
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static String getEINameByIndex(FBType fbType, int index) {
        String retval = null;
        try {
            retval = ((org.eclipse.fordiac.ide.model.libraryElement.Event)fbType.getInterfaceList().getEventInputs().get(index)).getName();
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static String getEONameByIndex(FBType fbType, int index) {
        String retval = null;
        try {
            retval = ((org.eclipse.fordiac.ide.model.libraryElement.Event)fbType.getInterfaceList().getEventOutputs().get(index)).getName();
        }
        catch (Exception exception) {
            retval = null;
        }
        return retval;
    }

    public static List<TestSequence> extractTestSequences(FBType fbType) {
        ArrayList<TestSequence> testSequences = new ArrayList<TestSequence>();
        int i = 0;
        while (i < fbType.getService().getServiceSequence().size()) {
            ServiceSequence sq = (ServiceSequence)fbType.getService().getServiceSequence().get(i);
            testSequences.add(FBTHelper.extractTestSequence(fbType, sq));
            ++i;
        }
        return testSequences;
    }

    public static TestSequence extractTestSequence(FBType fbType, ServiceSequence sq) {
        TestSequence ts = new TestSequence();
        ts.setName(sq.getName());
        ts.setRelatedModelElement(sq);
        int nNumberOfST = sq.getServiceTransaction().size();
        int j = 0;
        while (j < nNumberOfST) {
            TestTransaction tt = new TestTransaction();
            ts.addTestTransaction(tt);
            ServiceTransaction st = (ServiceTransaction)sq.getServiceTransaction().get(j);
            tt.setRelatedModelElement(st);
            if (st.getInputPrimitive() != null) {
                String event = st.getInputPrimitive().getEvent();
                Boolean inputQualifier = false;
                boolean useInputQualifier = false;
                if (event.contains("-")) {
                    event = event.substring(0, event.indexOf("-"));
                    inputQualifier = false;
                    useInputQualifier = true;
                } else if (event.contains("+")) {
                    event = event.substring(0, event.indexOf("+"));
                    inputQualifier = true;
                    useInputQualifier = true;
                }
                int eventID = FBTHelper.getEIID(fbType, event);
                if (eventID >= 0) {
                    TestPrimitive tp = new TestPrimitive(new Event(event, eventID, true));
                    tp.setRelatedModelElement(st.getInputPrimitive());
                    tt.setInputPrimitive(tp);
                    if (useInputQualifier) {
                        String qiDT = null;
                        int qiID = FBTHelper.getDIID(fbType, "QI");
                        if (qiID >= 0) {
                            qiDT = FBTHelper.getDIDataType(fbType, qiID);
                            DataVariable qi = new DataVariable("QI", qiID, qiDT, true, inputQualifier.toString());
                            tp.addData(qi);
                        }
                    }
                    if (st.getInputPrimitive().getParameters() != null) {
                        String[] parameters;
                        String[] stringArray = parameters = st.getInputPrimitive().getParameters().split(";");
                        int n = parameters.length;
                        int qi = 0;
                        while (qi < n) {
                            String param = stringArray[qi];
                            param = param.replace(" ", "");
                            String[] left = (param = param.replace("\t", "")).split(":=");
                            if (left.length == 2) {
                                String diDT = null;
                                int diID = FBTHelper.getDIID(fbType, left[0]);
                                if (diID >= 0) {
                                    diDT = FBTHelper.getDIDataType(fbType, diID);
                                    DataVariable di = new DataVariable(left[0], diID, diDT, true, left[1]);
                                    tp.addData(di);
                                }
                            }
                            ++qi;
                        }
                    }
                }
            }
            if (st.getOutputPrimitive() != null && st.getOutputPrimitive().size() > 0) {
                for (OutputPrimitive op : st.getOutputPrimitive()) {
                    String[] parameters;
                    TestPrimitive tp = new TestPrimitive(null);
                    String event = op.getEvent();
                    Boolean outputQualifier = false;
                    boolean useOutputQualifier = false;
                    if (event.contains("-")) {
                        event = event.substring(0, event.indexOf("-"));
                        outputQualifier = false;
                        useOutputQualifier = true;
                    } else if (event.contains("+")) {
                        event = event.substring(0, event.indexOf("+"));
                        outputQualifier = true;
                        useOutputQualifier = true;
                    }
                    int eventID = FBTHelper.getEOID(fbType, event);
                    if (eventID >= 0) {
                        tp.setEvent(new Event(event, eventID, false));
                        tp.setRelatedModelElement(op);
                        tt.addOutputPrimitives(tp);
                        if (useOutputQualifier) {
                            String qoDT = null;
                            int qoID = FBTHelper.getDOID(fbType, "QO");
                            if (qoID >= 0) {
                                qoDT = FBTHelper.getDODataType(fbType, qoID);
                                DataVariable qo = new DataVariable("QO", qoID, qoDT, false, outputQualifier.toString());
                                tp.addData(qo);
                            }
                        }
                    }
                    if (op.getParameters() == null) continue;
                    String[] stringArray = parameters = op.getParameters().split(";");
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String param = stringArray[n2];
                        param = param.replace(" ", "");
                        String[] left = (param = param.replace("\t", "")).split(":=");
                        if (left.length == 2) {
                            String doDT = null;
                            int doID = FBTHelper.getDOID(fbType, left[0]);
                            if (doID >= 0) {
                                doDT = FBTHelper.getDODataType(fbType, doID);
                                DataVariable dout = new DataVariable(left[0], doID, doDT, false, left[1]);
                                tp.addData(dout);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++j;
        }
        return ts;
    }

    public static int getMaxOutputPrimitives(List<TestSequence> paTests) {
        int retval = 0;
        for (TestSequence TS : paTests) {
            if (TS.getTestTransactions() == null || TS.getTestTransactions().size() <= 0) continue;
            for (TestTransaction TT : TS.getTestTransactions()) {
                if (TT.getOutputPrimitives() == null) continue;
                retval = Math.max(retval, TT.getOutputPrimitives().size());
            }
        }
        return retval;
    }
}

