/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.actions;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.util.OpenListenerManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class Open4DIACElementAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.fordiac.ide.systemmanagement.ui.OpenAction";

    public Open4DIACElementAction(IWorkbenchPart part) {
        super(Messages.OpenEditorAction_text);
        this.setId(ID);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean retval = true;
        Iterator element = this.getStructuredSelection().iterator();
        while (element.hasNext() && retval) {
            Object obj = element.next();
            if (obj instanceof Device || obj instanceof SystemConfiguration || obj instanceof Application || obj instanceof SubApp || obj instanceof Resource) continue;
            retval = obj instanceof FB ? Open4DIACElementAction.isFBInAppOrSubApp((FB)obj) : false;
        }
        return retval;
    }

    public void run() {
        for (Object obj : this.getStructuredSelection()) {
            Object refObject = null;
            if (obj instanceof FB) {
                refObject = obj;
                obj = Open4DIACElementAction.getFBRootNode((FB)obj);
            } else if (obj instanceof Device) {
                refObject = obj;
                obj = ((Device)obj).getSystemConfiguration();
            }
            IEditorPart editor = OpenListenerManager.openEditor((I4DIACElement)((I4DIACElement)obj));
            if (editor == null) continue;
        }
    }

    private static boolean isFBInAppOrSubApp(FB fb) {
        EObject rootNode = Open4DIACElementAction.getFBRootNode(fb);
        return rootNode instanceof Application || rootNode instanceof SubApp;
    }

    private static EObject getFBRootNode(FB fb) {
        EObject fbCont = fb.eContainer();
        EObject rootNode = null;
        if (fbCont instanceof FBNetwork) {
            rootNode = ((FBNetwork)fbCont).eContainer();
        }
        return rootNode;
    }
}

