/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ConnCreateDirectEditDragTrackerProxy;
import org.eclipse.fordiac.ide.gef.editparts.IDeactivatableConnectionHandleRoleEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.gef.figures.ToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.ValueEditPartChangeEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.EventImpl;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public abstract class InterfaceEditPart
extends AbstractConnectableEditPart
implements NodeEditPart,
IDeactivatableConnectionHandleRoleEditPart {
    private InterfaceFigure figure;
    private ValueEditPart referencedPart;
    protected int mouseState;
    private EContentAdapter contentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                InterfaceEditPart.this.refresh();
            }
            super.notifyChanged(notification);
        }
    };

    public InterfaceEditPart() {
        this.setConnectable(true);
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new ConnCreateDirectEditDragTrackerProxy((EditPart)this);
    }

    public int getMouseState() {
        return this.mouseState;
    }

    protected void refreshTargetConnections() {
        super.refreshTargetConnections();
        if (this.getReferencedValueEditPart() != null) {
            this.getReferencedValueEditPart().refreshValue();
        }
    }

    protected String getLabelText() {
        return this.getModel().getName();
    }

    protected IFigure createFigure() {
        if (this.figure == null) {
            this.figure = new InterfaceFigure();
        }
        return this.figure;
    }

    protected void refreshVisuals() {
    }

    protected abstract GraphicalNodeEditPolicy getNodeEditPolicy();

    public void setInOutConnectionsWidth(int with) {
        boolean hideData = Activator.getDefault().getPreferenceStore().getBoolean("hideDataConnections");
        boolean hideEvent = Activator.getDefault().getPreferenceStore().getBoolean("hideEventConnections");
        for (ConnectionEditPart cep : this.getSourceConnections()) {
            if (!(cep.getFigure() instanceof PolylineConnection)) continue;
            ((PolylineConnection)cep.getFigure()).setLineWidth(with);
            if (cep.getModel() instanceof DataConnection) {
                if (with > 1 && hideData) {
                    ((PolylineConnection)cep.getFigure()).setVisible(true);
                } else if (with < 2) {
                    ((PolylineConnection)cep.getFigure()).setVisible(!hideData);
                }
            }
            if (!(cep.getModel() instanceof EventConnection)) continue;
            if (with > 1 && hideEvent) {
                ((PolylineConnection)cep.getFigure()).setVisible(true);
                continue;
            }
            if (with >= 2) continue;
            ((PolylineConnection)cep.getFigure()).setVisible(!hideEvent);
        }
        for (ConnectionEditPart cep : this.getTargetConnections()) {
            if (!(cep.getFigure() instanceof PolylineConnection)) continue;
            ((PolylineConnection)cep.getFigure()).setLineWidth(with);
            if (cep.getModel() instanceof DataConnection) {
                if (with > 1 && hideData) {
                    ((PolylineConnection)cep.getFigure()).setVisible(true);
                } else if (with < 2) {
                    ((PolylineConnection)cep.getFigure()).setVisible(!hideData);
                }
            }
            if (!(cep.getModel() instanceof EventConnection)) continue;
            if (with > 1 && hideEvent) {
                ((PolylineConnection)cep.getFigure()).setVisible(true);
                continue;
            }
            if (with >= 2) continue;
            ((PolylineConnection)cep.getFigure()).setVisible(!hideEvent);
        }
    }

    @Override
    protected void createEditPolicies() {
        GraphicalNodeEditPolicy nodeEditPolicy = this.getNodeEditPolicy();
        if (nodeEditPolicy != null) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)nodeEditPolicy);
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void showSelection() {
                InterfaceEditPart.this.setInOutConnectionsWidth(2);
            }

            protected void hideSelection() {
                InterfaceEditPart.this.setInOutConnectionsWidth(0);
            }
        });
        if (this.isVariable()) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

                protected Command getMoveChildrenCommand(Request request) {
                    return null;
                }

                public Command getCommand(Request request) {
                    if ("create child".equals(request.getType())) {
                        return this.getCreateCommand((CreateRequest)request);
                    }
                    return null;
                }

                protected Command getCreateCommand(CreateRequest request) {
                    InterfaceEditPart host;
                    if (this.getHost() instanceof InterfaceEditPart && !(request.getNewObjectType() instanceof ResourceTypeEntry) && (host = (InterfaceEditPart)this.getHost()).getModel() instanceof VarDeclaration && !(host.getModel() instanceof AdapterDeclaration)) {
                        VarDeclaration v = (VarDeclaration)host.getModel();
                        return new ChangeValueCommand(v, request.getNewObject() != null ? request.getNewObject().toString() : "");
                    }
                    return null;
                }

                protected EditPolicy createChildEditPolicy(EditPart child) {
                    return null;
                }
            });
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ValueEditPartChangeEditPolicy(){

                @Override
                protected ValueEditPart getValueEditPart() {
                    return InterfaceEditPart.this.getReferencedValueEditPart();
                }
            });
        }
    }

    @Override
    public void setConnectionHandleRoleEnabled(boolean enabled) {
    }

    public IInterfaceElement getModel() {
        return (IInterfaceElement)super.getModel();
    }

    public boolean isInput() {
        return this.getModel().isIsInput();
    }

    public boolean isEvent() {
        return this.getModel() instanceof EventImpl;
    }

    public boolean isAdapter() {
        return this.getModel() instanceof AdapterDeclaration;
    }

    public boolean isVariable() {
        return this.getModel() instanceof VarDeclaration;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
    }

    protected EContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
        }
        this.referencedPart = null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput(), (GraphicalEditPart)this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput(), (GraphicalEditPart)this);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    protected List<?> getModelSourceConnections() {
        if (!this.isInput()) {
            return this.getModel().getOutputConnections();
        }
        return Collections.emptyList();
    }

    protected List<?> getModelTargetConnections() {
        if (this.isInput()) {
            return this.getModel().getInputConnections();
        }
        return Collections.emptyList();
    }

    public void setSelected(int value) {
        if (value == 0) {
            Activator.statusLineErrorMessage(null);
        }
        super.setSelected(value);
    }

    public void performRequest(Request request) {
        request.getType();
        if (request.getType() == "direct edit" || request.getType() == "open") {
            ValueEditPart part = this.getReferencedValueEditPart();
            if (part != null && this.isVariable() && !(this.getModel() instanceof AdapterDeclaration)) {
                part.performDirectEdit();
            }
        } else {
            super.performRequest(request);
        }
    }

    public ValueEditPart getReferencedValueEditPart() {
        Object temp;
        if (this.referencedPart == null && (temp = this.getViewer().getEditPartRegistry().get(this.getModel().getValue())) instanceof ValueEditPart) {
            this.referencedPart = (ValueEditPart)((Object)temp);
        }
        return this.referencedPart;
    }

    public class InterfaceFigure
    extends SetableAlphaLabel {
        public InterfaceFigure() {
            this.setOpaque(false);
            this.setText(InterfaceEditPart.this.getLabelText());
            this.setBorder((Border)new ConnectorBorder(InterfaceEditPart.this.getModel()));
            if (InterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
            this.setToolTip((IFigure)new ToolTipFigure((INamedElement)InterfaceEditPart.this.getModel()));
            if (InterfaceEditPart.this.isAdapter()) {
                this.addMouseMotionListener(new MouseMotionListener(){

                    public void mouseDragged(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseEntered(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseExited(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseHover(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseMoved(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }
                });
            }
        }
    }
}

