/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handles;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class PlusHandle
extends SquareHandle {
    private static final int DEFAULT_PLUS_HANDLE_SIZE = 8;
    static Color handleColor = ColorManager.getColor((RGB)new RGB(114, 175, 73));

    public PlusHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
    }

    void setHandleColor(Color col) {
        handleColor = col;
    }

    protected void init() {
        this.setPreferredSize(new Dimension(8, 8));
    }

    protected DragTracker createDragTracker() {
        return null;
    }

    protected Color getBorderColor() {
        return this.getFillColor();
    }

    protected Color getFillColor() {
        return handleColor;
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = this.getBounds();
        g.setBackgroundColor(this.getFillColor());
        g.fillRectangle(r.x, r.y, r.width, r.height);
        int yMiddle = r.y + r.height / 2;
        int xMiddle = r.x + r.width / 2;
        g.setBackgroundColor(ColorConstants.white);
        g.fillRectangle(r.x + 1, yMiddle - 1, 6, 2);
        g.fillRectangle(xMiddle - 1, r.y + 1, 2, 6);
    }
}

