/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ModuleUpdater;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironmentRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessConstructorRequestor;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.util.Util;

public class SearchableEnvironment
implements IModuleAwareNameEnvironment,
IJavaSearchConstants {
    public NameLookup nameLookup;
    protected ICompilationUnit unitToSkip;
    protected org.eclipse.jdt.core.ICompilationUnit[] workingCopies;
    protected WorkingCopyOwner owner;
    protected JavaProject project;
    protected IJavaSearchScope searchScope;
    protected boolean checkAccessRestrictions;
    private Map<String, IPackageFragmentRoot[]> knownModuleLocations;
    private ModuleUpdater moduleUpdater;
    private Map<IPackageFragmentRoot, IModuleDescription> rootToModule;

    public SearchableEnvironment(JavaProject project, org.eclipse.jdt.core.ICompilationUnit[] workingCopies) throws JavaModelException {
        int n;
        int n2;
        Object[] objectArray;
        this.project = project;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = project.newNameLookup(workingCopies);
        if (CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L) {
            objectArray = project.getPackageFragmentRoots();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IPackageFragmentRoot root = objectArray[n];
                if (root.getModuleDescription() != null) {
                    this.knownModuleLocations = new HashMap<String, IPackageFragmentRoot[]>();
                    break;
                }
                ++n;
            }
        }
        if (CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L) {
            this.moduleUpdater = new ModuleUpdater(project);
            objectArray = project.getRawClasspath();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object entry = objectArray[n];
                this.moduleUpdater.computeModuleUpdates((IClasspathEntry)entry);
                ++n;
            }
        }
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner) throws JavaModelException {
        this(project, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true));
        this.owner = owner;
    }

    private static int convertSearchFilterToModelFilter(int searchFilter) {
        switch (searchFilter) {
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 6;
            }
        }
        return 30;
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName, IPackageFragmentRoot[] moduleContext) {
        block12: {
            String source;
            if (packageName == null) {
                packageName = "";
            }
            if (this.owner != null && (source = this.owner.findSource(typeName, packageName)) != null) {
                IPackageFragmentRoot moduleElement = moduleContext != null && moduleContext.length > 0 ? moduleContext[0] : null;
                BasicCompilationUnit cu = new BasicCompilationUnit(source.toCharArray(), CharOperation.splitOn('.', packageName.toCharArray()), String.valueOf(typeName) + Util.defaultJavaExtension(), moduleElement);
                return new NameEnvironmentAnswer(cu, null);
            }
            NameLookup.Answer answer = this.nameLookup.findType(typeName, packageName, false, 30, this.checkAccessRestrictions, moduleContext);
            if (answer != null) {
                if (answer.type instanceof BinaryType) {
                    try {
                        char[] moduleName = answer.module != null ? answer.module.getElementName().toCharArray() : null;
                        return new NameEnvironmentAnswer((IBinaryType)((BinaryType)answer.type).getElementInfo(), answer.restriction, moduleName);
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    try {
                        SourceTypeElementInfo sourceType;
                        ISourceType topLevelType = sourceType = (SourceTypeElementInfo)((SourceType)answer.type).getElementInfo();
                        while (topLevelType.getEnclosingType() != null) {
                            topLevelType = topLevelType.getEnclosingType();
                        }
                        IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                        ISourceType[] sourceTypes = new ISourceType[types.length];
                        sourceTypes[0] = sourceType;
                        int length = types.length;
                        int i = 0;
                        int index = 1;
                        while (i < length) {
                            ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                            if (!otherType.equals(topLevelType) && index < length) {
                                sourceTypes[index++] = otherType;
                            }
                            ++i;
                        }
                        char[] moduleName = answer.module != null ? answer.module.getElementName().toCharArray() : null;
                        return new NameEnvironmentAnswer(sourceTypes, answer.restriction, this.getExternalAnnotationPath(answer.entry), moduleName);
                    }
                    catch (JavaModelException jme) {
                        if (!jme.isDoesNotExist() || !String.valueOf(TypeConstants.PACKAGE_INFO_NAME).equals(typeName)) break block12;
                        return new NameEnvironmentAnswer((ICompilationUnit)((Object)answer.type.getParent()), answer.restriction);
                    }
                }
            }
        }
        return null;
    }

    private String getExternalAnnotationPath(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath path = ClasspathEntry.getExternalAnnotationPath(entry, this.project.getProject(), true);
        if (path == null) {
            return null;
        }
        return path.toOSString();
    }

    public void findModules(char[] prefix, ISearchRequestor requestor, IJavaProject javaProject) {
        this.nameLookup.seekModule(prefix, true, new SearchableEnvironmentRequestor(requestor));
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor));
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor, IPackageFragmentRoot[] moduleContext) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor), moduleContext);
    }

    public void findExactTypes(char[] name, final boolean findMembers, int searchFor, final ISearchRequestor storage) {
        try {
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaElement)) {
                    this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    return;
                }
                excludePath = ((IJavaElement)((Object)this.unitToSkip)).getPath().toString();
            } else {
                excludePath = null;
            }
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String n, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String n) {
                }

                public void subTask(String n) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        return;
                    }
                    storage.acceptType(packageName, simpleTypeName, enclosingTypeNames, modifiers, access);
                }
            };
            try {
                new BasicSearchEngine(this.workingCopies).searchAllTypeNames(null, 0, name, 0, searchFor, this.getSearchScope(), typeRequestor, 2, progressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
            }
        }
        catch (JavaModelException javaModelException) {
            this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
        }
    }

    private void findExactTypes(String name, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.project, this.nameLookup);
        this.nameLookup.seekTypes(name, null, false, type, requestor);
    }

    public NameEnvironmentAnswer findTypeInModules(char[][] compoundTypeName, ModuleBinding module) {
        char[] nameForLookup = module.nameForLookup();
        NameEnvironmentAnswer answer = this.findType(compoundTypeName, nameForLookup);
        if (answer != null) {
            return answer;
        }
        if (IModuleAwareNameEnvironment.LookupStrategy.get(nameForLookup) == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            ModuleBinding[] moduleBindingArray = module.getAllRequiredModules();
            int n = moduleBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleBinding required = moduleBindingArray[n2];
                answer = this.findType(compoundTypeName, required.nameForLookup());
                if (answer != null) {
                    return answer;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName, char[] moduleName) {
        if (compoundTypeName == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null, moduleLocations);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(new String(compoundTypeName[lengthM1]), CharOperation.toString(packageName), moduleLocations);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] name, char[][] packageName, char[] moduleName) {
        if (name == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        return this.find(new String(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName), moduleLocations);
    }

    public void findTypes(char[] prefix, boolean findMembers, boolean camelCaseMatch, int searchFor, ISearchRequestor storage) {
        this.findTypes(prefix, findMembers, camelCaseMatch, searchFor, storage, null);
    }

    public void findTypes(char[] prefix, final boolean findMembers, boolean camelCaseMatch, int searchFor, final ISearchRequestor storage, IProgressMonitor monitor) {
        block17: {
            try {
                char[] simpleName;
                char[] qualification;
                String excludePath;
                if (this.unitToSkip != null) {
                    if (!(this.unitToSkip instanceof IJavaElement)) {
                        this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                        return;
                    }
                    excludePath = ((IJavaElement)((Object)this.unitToSkip)).getPath().toString();
                } else {
                    excludePath = null;
                }
                int lastDotIndex = CharOperation.lastIndexOf('.', prefix);
                if (lastDotIndex < 0) {
                    qualification = null;
                    simpleName = camelCaseMatch ? prefix : CharOperation.toLowerCase(prefix);
                } else {
                    qualification = CharOperation.subarray(prefix, 0, lastDotIndex);
                    simpleName = camelCaseMatch ? CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length) : CharOperation.toLowerCase(CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length));
                }
                IProgressMonitor progressMonitor = new IProgressMonitor(){
                    boolean isCanceled = false;

                    public void beginTask(String name, int totalWork) {
                    }

                    public void done() {
                    }

                    public void internalWorked(double work) {
                    }

                    public boolean isCanceled() {
                        return this.isCanceled;
                    }

                    public void setCanceled(boolean value) {
                        this.isCanceled = value;
                    }

                    public void setTaskName(String name) {
                    }

                    public void subTask(String name) {
                    }

                    public void worked(int work) {
                    }
                };
                IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                    @Override
                    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                        if (excludePath != null && excludePath.equals(path)) {
                            return;
                        }
                        if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                            return;
                        }
                        storage.acceptType(packageName, simpleTypeName, enclosingTypeNames, modifiers, access);
                    }
                };
                int matchRule = 1;
                if (camelCaseMatch) {
                    matchRule |= 0x80;
                }
                if (monitor != null) {
                    IndexManager indexManager = JavaModelManager.getIndexManager();
                    if (indexManager.awaitingJobsCount() == 0) {
                        new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), typeRequestor, 1, progressMonitor);
                        break block17;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (indexManager.awaitingJobsCount() == 0) {
                        new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), typeRequestor, 1, progressMonitor);
                    } else {
                        this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    }
                    break block17;
                }
                try {
                    new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), typeRequestor, 2, progressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                }
            }
            catch (JavaModelException javaModelException) {
                this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
            }
        }
    }

    public void findConstructorDeclarations(char[] prefix, boolean camelCaseMatch, final ISearchRequestor storage, IProgressMonitor monitor) {
        try {
            char[] simpleName;
            char[] qualification;
            final String excludePath = this.unitToSkip != null && this.unitToSkip instanceof IJavaElement ? ((IJavaElement)((Object)this.unitToSkip)).getPath().toString() : null;
            int lastDotIndex = CharOperation.lastIndexOf('.', prefix);
            if (lastDotIndex < 0) {
                qualification = null;
                simpleName = camelCaseMatch ? prefix : CharOperation.toLowerCase(prefix);
            } else {
                qualification = CharOperation.subarray(prefix, 0, lastDotIndex);
                simpleName = camelCaseMatch ? CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length) : CharOperation.toLowerCase(CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length));
            }
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String name, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessConstructorRequestor constructorRequestor = new IRestrictedAccessConstructorRequestor(){

                @Override
                public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    storage.acceptConstructor(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, path, access);
                }
            };
            int matchRule = 1;
            if (camelCaseMatch) {
                matchRule |= 0x80;
            }
            if (monitor != null) {
                IndexManager indexManager = JavaModelManager.getIndexManager();
                indexManager.performConcurrentJob(new IJob(){

                    @Override
                    public boolean belongsTo(String jobFamily) {
                        return true;
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void ensureReadyToRun() {
                    }

                    @Override
                    public boolean execute(IProgressMonitor progress) {
                        return progress == null || !progress.isCanceled();
                    }

                    @Override
                    public String getJobFamily() {
                        return "";
                    }
                }, 3, monitor);
                new BasicSearchEngine(this.workingCopies).searchAllConstructorDeclarations(qualification, simpleName, matchRule, this.getSearchScope(), constructorRequestor, 1, progressMonitor);
            } else {
                try {
                    new BasicSearchEngine(this.workingCopies).searchAllConstructorDeclarations(qualification, simpleName, matchRule, this.getSearchScope(), constructorRequestor, 2, progressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void findTypes(String prefix, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.project, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                int i = 0;
                int length = fragments.length;
                while (i < length) {
                    if (fragments[i] != null) {
                        this.nameLookup.seekTypes(className, fragments[i], true, type, requestor);
                    }
                    ++i;
                }
            }
        }
    }

    private IJavaSearchScope getSearchScope() {
        if (this.searchScope == null) {
            this.searchScope = this.checkAccessRestrictions ? BasicSearchEngine.createJavaSearchScope(new IJavaElement[]{this.project}) : BasicSearchEngine.createJavaSearchScope(this.nameLookup.packageFragmentRoots);
        }
        return this.searchScope;
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] parentPackageName, char[] name, char[] moduleName) {
        String[] pkgName;
        if (parentPackageName == null) {
            pkgName = new String[]{new String(name)};
        } else {
            int length = parentPackageName.length;
            pkgName = new String[length + 1];
            int i = 0;
            while (i < length) {
                pkgName[i] = new String(parentPackageName[i]);
                ++i;
            }
            pkgName[length] = new String(name);
        }
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                IPackageFragmentRoot[] moduleContext;
                if (this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.isPackage(pkgName, moduleContext)) {
                    return new char[][]{moduleName};
                }
                return null;
            }
            case Any: 
            case Unnamed: {
                if (this.knownModuleLocations == null) {
                    if (this.owner != null && this.owner.isPackage(pkgName) || this.nameLookup.isPackage(pkgName)) {
                        return new char[][]{ModuleBinding.UNNAMED};
                    }
                    return null;
                }
            }
            case AnyNamed: {
                IPackageFragmentRoot[] packageRoots;
                char[][] names = CharOperation.NO_CHAR_CHAR;
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = this.nameLookup.packageFragmentRoots;
                int n = packageRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                    IPackageFragmentRoot[] singleton = new IPackageFragmentRoot[]{packageRoot};
                    if (strategy.matches(singleton, locs -> locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription((IPackageFragmentRoot[])locs) != null) && this.nameLookup.isPackage(pkgName, singleton)) {
                        IModuleDescription moduleDescription = this.getModuleDescription(singleton);
                        char[] aName = moduleDescription != null ? moduleDescription.getElementName().toCharArray() : ModuleBinding.UNNAMED;
                        names = CharOperation.arrayConcat(names, aName);
                    }
                    ++n2;
                }
                return names == CharOperation.NO_CHAR_CHAR ? null : names;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + (Object)((Object)strategy));
    }

    @Override
    public boolean hasCompilationUnit(char[][] pkgName, char[] moduleName, boolean checkCUs) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                IPackageFragmentRoot[] moduleContext;
                return this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.hasCompilationUnit(pkgName, moduleContext);
            }
            case Any: 
            case Unnamed: {
                if (this.knownModuleLocations == null && this.nameLookup.hasCompilationUnit(pkgName, null)) {
                    return true;
                }
            }
            case AnyNamed: {
                IPackageFragmentRoot[] packageRoots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = this.nameLookup.packageFragmentRoots;
                int n = packageRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                    IPackageFragmentRoot[] singleton = new IPackageFragmentRoot[]{packageRoot};
                    if (strategy.matches(singleton, locs -> locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription((IPackageFragmentRoot[])locs) != null) && this.nameLookup.hasCompilationUnit(pkgName, singleton)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + (Object)((Object)strategy));
    }

    private IModuleDescription getModuleDescription(IPackageFragmentRoot[] roots) {
        if (this.rootToModule == null) {
            this.rootToModule = new HashMap<IPackageFragmentRoot, IModuleDescription>();
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IModuleDescription moduleDescription = NameLookup.getModuleDescription(root, this.rootToModule, this.nameLookup.rootToResolvedEntries::get);
            if (moduleDescription != null) {
                return moduleDescription;
            }
            ++n2;
        }
        return null;
    }

    private IPackageFragmentRoot[] findModuleContext(char[] moduleName) {
        NameLookup.Answer moduleAnswer;
        IPackageFragmentRoot[] moduleContext = null;
        if (this.knownModuleLocations != null && moduleName != null && moduleName.length > 0 && (moduleContext = this.knownModuleLocations.get(String.valueOf(moduleName))) == null && (moduleAnswer = this.nameLookup.findModule(moduleName)) != null) {
            IProject currentProject = moduleAnswer.module.getJavaProject().getProject();
            IJavaElement current = moduleAnswer.module.getParent();
            block8: while (moduleContext == null && current != null) {
                switch (current.getElementType()) {
                    case 3: {
                        if (!((IPackageFragmentRoot)current).isExternal()) {
                            current = current.getJavaProject();
                        } else {
                            moduleContext = new IPackageFragmentRoot[]{(IPackageFragmentRoot)current};
                            break;
                        }
                    }
                    case 2: {
                        try {
                            moduleContext = SearchableEnvironment.getOwnedPackageFragmentRoots((IJavaProject)current);
                        }
                        catch (JavaModelException javaModelException) {}
                        continue block8;
                    }
                    default: {
                        current = current.getParent();
                        if (current == null) continue block8;
                        try {
                            IJavaProject otherJavaProject;
                            IProject otherProject;
                            IResource resource = current.getUnderlyingResource();
                            if (resource == null || (otherProject = resource.getProject()) == null || otherProject.equals((Object)currentProject) || !(otherJavaProject = JavaCore.create(otherProject)).exists()) continue block8;
                            moduleContext = this.getRootsForOutputLocation(otherJavaProject, resource);
                            break;
                        }
                        catch (JavaModelException e) {
                            Util.log((Throwable)((Object)e), "Failed to find package fragment root for " + current);
                        }
                    }
                }
            }
            this.knownModuleLocations.put(String.valueOf(moduleName), moduleContext);
        }
        return moduleContext;
    }

    protected String toStringChar(char[] name) {
        return "[" + new String(name) + "]";
    }

    protected String toStringCharChar(char[][] names) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            result.append(this.toStringChar(names[i]));
            ++i;
        }
        return result.toString();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public IModule getModule(char[] name) {
        NameLookup.Answer answer = this.nameLookup.findModule(name);
        IModule module = null;
        if (answer != null) {
            module = NameLookup.getModuleDescriptionInfo(answer.module);
        }
        return module;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public void applyModuleUpdates(IUpdatableModule module, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(module, kind);
        }
    }

    private IPackageFragmentRoot[] getRootsForOutputLocation(IJavaProject otherJavaProject, IResource outputLocation) throws JavaModelException {
        IClasspathEntry classpathEntry;
        int n;
        int n2;
        IClasspathEntry[] iClasspathEntryArray;
        IPath outputPath = outputLocation.getFullPath();
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        if (outputPath.equals((Object)otherJavaProject.getOutputLocation())) {
            iClasspathEntryArray = otherJavaProject.getRawClasspath();
            n2 = iClasspathEntryArray.length;
            n = 0;
            while (n < n2) {
                classpathEntry = iClasspathEntryArray[n];
                if (classpathEntry.getOutputLocation() == null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = otherJavaProject.findPackageFragmentRoots(classpathEntry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        IResource rootResource = root.getResource();
                        if (rootResource != null && rootResource.getProject().equals((Object)otherJavaProject.getProject())) {
                            result.add(root);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (!result.isEmpty()) {
            return result.toArray(new IPackageFragmentRoot[result.size()]);
        }
        iClasspathEntryArray = otherJavaProject.getRawClasspath();
        n2 = iClasspathEntryArray.length;
        n = 0;
        while (n < n2) {
            classpathEntry = iClasspathEntryArray[n];
            if (outputPath.equals((Object)classpathEntry.getOutputLocation())) {
                return otherJavaProject.findPackageFragmentRoots(classpathEntry);
            }
            ++n;
        }
        return null;
    }

    public static IPackageFragmentRoot[] getOwnedPackageFragmentRoots(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot[] sourceRoots = Arrays.copyOf(allRoots, allRoots.length);
        int count = 0;
        int i = 0;
        while (i < allRoots.length) {
            IResource resource;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() != 2 || (resource = root.getResource()) != null && resource.getProject().equals((Object)javaProject.getProject())) {
                sourceRoots[count++] = root;
            }
            ++i;
        }
        if (count < allRoots.length) {
            return Arrays.copyOf(sourceRoots, count);
        }
        return sourceRoots;
    }
}

