/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewFBTypeWizardPage
extends WizardNewFileCreationPage {
    private Combo fbTypeCombo;
    private ArrayList<File> templates;
    private Button openTypeCheckbox;

    public NewFBTypeWizardPage(IStructuredSelection selection) {
        super("New type page", selection);
        this.setTitle("Create new Type");
        this.setDescription("Create a new type from a template type");
        this.setAllowExistingResources(true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.openTypeCheckbox = new Button(composite, 32);
        this.openTypeCheckbox.setText("Open type for editing when done");
        this.openTypeCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        String errorMessage = "";
        if (this.templates != null && this.templates.size() == 0) {
            this.setErrorMessage("No type templates found! Please check the templates directory!");
            return false;
        }
        if (this.getFileName().isEmpty()) {
            this.setErrorMessage("Empty Typename is not valid!");
            return false;
        }
        errorMessage = IdentifierVerifyer.isValidIdentifierWithErrorMessage((String)super.getFileName());
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        this.setErrorMessage(null);
        return super.validatePage();
    }

    public String getType() {
        return this.fbTypeCombo.getText();
    }

    public File getTemplate() {
        return this.templates.get(this.fbTypeCombo.getSelectionIndex());
    }

    protected String getNewFileLabel() {
        return "Type name:";
    }

    public String getFileName() {
        String[] splited;
        String retval = super.getFileName();
        if (this.fbTypeCombo != null && this.fbTypeCombo.getText() != null && (splited = this.fbTypeCombo.getText().split("\\.")).length == 2) {
            retval = String.valueOf(retval) + "." + splited[1];
        }
        return retval;
    }

    public boolean getOpenType() {
        return this.openTypeCheckbox.getSelection();
    }

    protected void createAdvancedControls(Composite parent) {
        this.createTemplateTypeSelection(parent);
        super.createAdvancedControls(parent);
    }

    private void createTemplateTypeSelection(Composite parent) {
        File[] files;
        Font font = parent.getFont();
        Composite typeGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        typeGroup.setLayout((Layout)layout);
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setFont(font);
        Label fbTypeTypeLabel = new Label(typeGroup, 0);
        fbTypeTypeLabel.setText("Type: ");
        fbTypeTypeLabel.setFont(font);
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        this.templates = new ArrayList();
        FileFilter ff = this.createTemplatesFileFilter();
        if (templateFolder.isDirectory() && (files = templateFolder.listFiles(ff)) != null) {
            this.templates.addAll(Arrays.asList(files));
            Collections.sort(this.templates);
        }
        this.fbTypeCombo = new Combo(typeGroup, 2056);
        GridData data = new GridData(768);
        this.fbTypeCombo.setLayoutData((Object)data);
        this.fbTypeCombo.setFont(font);
        for (File file : this.templates) {
            this.fbTypeCombo.add(file.getName());
        }
        this.fbTypeCombo.select(0);
        this.fbTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewFBTypeWizardPage.this.setPageComplete(NewFBTypeWizardPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewFBTypeWizardPage.this.setPageComplete(NewFBTypeWizardPage.this.validatePage());
            }
        });
    }

    protected FileFilter createTemplatesFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().endsWith(".FBT") || pathname.getName().toUpperCase().endsWith(".ADP") || pathname.getName().toUpperCase().endsWith(".SUB");
            }
        };
    }
}

