/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;

public class TransitionCreateCommand
extends Command {
    private ECState source;
    private ECState destination;
    private Point sourceLocation;
    private Point destLocation;
    private ECC parent;
    private ECTransition transition;
    private String conditionExpression;
    private Event conditionEvent;
    private EditPartViewer viewer;

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(String condition) {
        this.conditionExpression = condition;
    }

    public void setConditionEvent(Event conditionEvent) {
        this.conditionEvent = conditionEvent;
    }

    public Event getConditionEvent() {
        return this.conditionEvent;
    }

    public ECState getSource() {
        return this.source;
    }

    public void setSource(ECState source) {
        this.source = source;
    }

    public ECState getDestination() {
        return this.destination;
    }

    public void setDestination(ECState destination) {
        this.destination = destination;
    }

    public boolean canExecute() {
        return this.source != null && this.destination != null && this.source.eContainer() != null;
    }

    public void execute() {
        Object obj;
        this.parent = (ECC)this.source.eContainer();
        this.transition = LibraryElementFactory.eINSTANCE.createECTransition();
        int x1 = this.sourceLocation.x;
        int x2 = this.destLocation.x;
        int y1 = this.sourceLocation.y;
        int y2 = this.destLocation.y;
        int x = 0;
        int y = 0;
        x = x1 > x2 ? (x1 - x2) / 2 + x2 : (x2 > x1 ? (x2 - x1) / 2 + x1 : x1);
        y = y1 > y2 ? (y1 - y2) / 2 + y2 : (y2 > y1 ? (y2 - y1) / 2 + y1 : y1);
        this.parent.getECTransition().add((Object)this.transition);
        if (this.source.equals(this.destination)) {
            this.transition.setX(x + 10);
            this.transition.setY(y + 50);
        } else {
            this.transition.setX(x);
            this.transition.setY(y);
        }
        this.transition.setSource(this.source);
        this.transition.setDestination(this.destination);
        this.transition.setConditionEvent(this.conditionEvent);
        if (this.conditionExpression != null) {
            this.transition.setConditionExpression(this.conditionExpression);
        } else if (this.conditionEvent == null) {
            this.transition.setConditionExpression("1");
        }
        if (this.viewer != null && (obj = this.viewer.getEditPartRegistry().get(this.transition)) != null) {
            this.viewer.select((EditPart)obj);
        }
    }

    public boolean canUndo() {
        return this.parent != null;
    }

    public void undo() {
        this.transition.setSource(null);
        this.transition.setDestination(null);
        this.parent.getECTransition().remove((Object)this.transition);
    }

    public void redo() {
        this.transition.setSource(this.source);
        this.transition.setDestination(this.destination);
        this.parent.getECTransition().add((Object)this.transition);
    }

    public void setSourceLocation(Point location) {
        this.sourceLocation = location;
    }

    public void setDestinationLocation(Point location) {
        this.destLocation = location;
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }
}

