/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.properties;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.properties.AdapterInterfaceElementSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInitialValueCommand;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataInterfaceElementSection
extends AdapterInterfaceElementSection {
    private Text arraySizeText;
    private Text initValueText;
    private CheckboxTableViewer withEventsViewer;
    private Table tableWith;
    private Group eventComposite;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createDataSection(this.leftComposite);
        this.createEventSection(this.rightComposite);
    }

    private void createDataSection(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, "Array Size:");
        this.arraySizeText = this.createGroupText(parent, true);
        this.arraySizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataInterfaceElementSection.this.removeContentAdapter();
                DataInterfaceElementSection.this.executeCommand((Command)new ChangeArraySizeCommand((VarDeclaration)DataInterfaceElementSection.this.type, DataInterfaceElementSection.this.arraySizeText.getText()));
                DataInterfaceElementSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(parent, "Initial Value:");
        this.initValueText = this.createGroupText(parent, true);
        this.initValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataInterfaceElementSection.this.removeContentAdapter();
                DataInterfaceElementSection.this.executeCommand((Command)new ChangeInitialValueCommand((VarDeclaration)DataInterfaceElementSection.this.type, DataInterfaceElementSection.this.initValueText.getText()));
                DataInterfaceElementSection.this.addContentAdapter();
            }
        });
    }

    private void createEventSection(Composite parent) {
        this.eventComposite = this.getWidgetFactory().createGroup(parent, "With");
        this.eventComposite.setLayout((Layout)new GridLayout(1, false));
        this.eventComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.withEventsViewer = CheckboxTableViewer.newCheckList((Composite)this.eventComposite, (int)67844);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.minimumHeight = 80;
        gridDataVersionViewer.widthHint = 400;
        this.withEventsViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        this.tableWith = this.withEventsViewer.getTable();
        this.tableWith.setLinesVisible(false);
        this.tableWith.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column1.setText("Event");
        TableColumn column2 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column2.setText("DataType");
        TableColumn column3 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column3.setText("Comment");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        this.tableWith.setLayout((Layout)layout);
        this.withEventsViewer.setContentProvider((IContentProvider)new EventContentProvider());
        this.withEventsViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.tableWith.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem checkedItem = (TableItem)event.item;
                    org.eclipse.fordiac.ide.model.libraryElement.Event e = (org.eclipse.fordiac.ide.model.libraryElement.Event)checkedItem.getData();
                    if (checkedItem.getChecked()) {
                        for (With with : e.getWith()) {
                            if (!with.getVariables().equals(DataInterfaceElementSection.this.type)) continue;
                            return;
                        }
                        WithCreateCommand cmd = new WithCreateCommand();
                        cmd.setEvent(e);
                        cmd.setVarDeclaration((VarDeclaration)DataInterfaceElementSection.this.type);
                        DataInterfaceElementSection.this.executeCommand((Command)cmd);
                    } else {
                        for (With with : e.getWith()) {
                            if (!with.getVariables().equals(DataInterfaceElementSection.this.type)) continue;
                            DataInterfaceElementSection.this.executeCommand((Command)new DeleteWithCommand(with));
                            break;
                        }
                    }
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.eventComposite.setVisible(!(this.getType().eContainer().eContainer() instanceof SubAppType));
        if (this.commandStack == null) {
            this.arraySizeText.setEnabled(false);
            this.initValueText.setEnabled(false);
            this.withEventsViewer.setInput(null);
            this.withEventsViewer.setAllGrayed(true);
        }
    }

    protected VarDeclaration getType() {
        return (VarDeclaration)this.type;
    }

    @Override
    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.arraySizeText.setText(this.getType().getArraySize() <= 0 ? "" : Integer.toString(this.getType().getArraySize()));
            this.initValueText.setText(this.getType().getVarInitialization() == null ? "" : this.getType().getVarInitialization().getInitialValue());
            if (this.getType().eContainer().eContainer() instanceof FBType) {
                this.eventComposite.setVisible(true);
                this.withEventsViewer.setAllChecked(false);
                for (With with : this.getType().getWiths()) {
                    if (with.getVariables() == null) continue;
                    this.withEventsViewer.setChecked((Object)with.eContainer(), true);
                }
                this.withEventsViewer.setInput((Object)this.getType());
            } else {
                this.eventComposite.setVisible(false);
            }
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    protected Collection<DataType> getTypes() {
        return DataTypeLibrary.getInstance().getDataTypesSorted();
    }
}

