/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.util.TestConnectionUtility;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.IC;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ICDialog
extends StatusDialog
implements Listener,
SelectionListener {
    private IC ic = null;
    private Text nameText;
    private Text hrefText;
    private Button testButton;
    private boolean testConnect = false;

    public ICDialog(Shell parentShell) {
        this(parentShell, null, false);
    }

    public ICDialog(Shell parentShell, IC initialIC) {
        this(parentShell, initialIC, false);
    }

    public ICDialog(Shell parentShell, IC initialIC, boolean testConnect) {
        super(parentShell);
        this.ic = initialIC;
        this.testConnect = testConnect;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite top = (Composite)super.createDialogArea(parent);
        top.setSize(top.computeSize(-1, -1));
        Composite topGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.makeColumnsEqualWidth = false;
        topGroup.setLayout((Layout)layout);
        topGroup.setFont(top.getFont());
        topGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(topGroup, 0);
        label.setText(Messages.AddICDialog_4);
        this.nameText = new Text(topGroup, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.nameText.getOrientation() == 0x4000000) {
            this.nameText.setOrientation(0x2000000);
        }
        this.nameText.addListener(24, (Listener)this);
        label = new Label(topGroup, 0);
        label.setText(Messages.InfoCenterPage_url);
        this.hrefText = new Text(topGroup, 2048);
        this.hrefText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.hrefText.getOrientation() == 0x4000000) {
            this.hrefText.setOrientation(0x2000000);
        }
        this.hrefText.addListener(24, (Listener)this);
        if (this.ic != null) {
            this.nameText.setText(this.ic.getName());
            this.hrefText.setText(this.ic.getHref());
            this.getShell().setText(NLS.bind((String)Messages.EditICDialog_7, (Object)this.ic.getName()));
        } else {
            this.getShell().setText(Messages.AddICDialog_2);
        }
        Dialog.applyDialogFont((Control)top);
        return top;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.testButton = this.createButton(parent, 1024, Messages.HelpContentBlock_testConnectionTitle, true);
        this.testButton.addSelectionListener((SelectionListener)this);
        super.createButtonsForButtonBar(parent);
        this.updateValidity();
        if (this.testConnect) {
            this.testConnection();
        }
    }

    public void initializeBounds() {
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(location.x, location.y, size.x + 180, size.y);
    }

    public void okPressed() {
        try {
            String href = this.formalizeHref(this.hrefText.getText());
            this.ic = new IC(this.nameText.getText(), href, true);
        }
        catch (MalformedURLException malformedURLException) {}
        this.setReturnCode(0);
        this.close();
    }

    public String formalizeHref(String href) {
        if (href.endsWith("/index.jsp")) {
            href = href.substring(0, href.lastIndexOf("/index.jsp"));
        } else if (href.endsWith("/site/site.xml")) {
            href = href.substring(0, href.lastIndexOf("/site/site.xml"));
        }
        return href;
    }

    private void updateValidity() {
        IStatus status = Status.OK_STATUS;
        if (this.nameText != null && this.nameText.getText().equals("")) {
            status = new Status(4, "org.eclipse.help.ui", Messages.InfoCenterPage_invalidURL);
        } else if (this.hrefText != null) {
            try {
                String href = this.hrefText.getText();
                new URL(href);
                if (!href.matches(".*\\://.+/.+")) {
                    status = new Status(4, "org.eclipse.help.ui", Messages.InfoCenterPage_invalidURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                status = new Status(4, "org.eclipse.help.ui", Messages.InfoCenterPage_invalidURL);
            }
        }
        this.updateStatus(status);
    }

    private boolean areFieldsValid() {
        if (this.nameText != null && this.nameText.getText().equals("")) {
            return false;
        }
        if (this.hrefText != null) {
            try {
                String href = this.hrefText.getText();
                new URL(href);
                if (!href.matches(".*\\://.+/.+")) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    private void testConnection() {
        Status status;
        try {
            IC testIC = new IC(this.nameText.getText(), this.formalizeHref(this.hrefText.getText()), true);
            boolean connected = TestConnectionUtility.testConnection((String)testIC.getHost(), (String)String.valueOf(testIC.getPort()), (String)testIC.getPath(), (String)testIC.getProtocol());
            status = connected ? new Status(1, "org.eclipse.help.ui", Messages.TestConnectionDialog_12) : new Status(2, "org.eclipse.help.ui", Messages.TestConnectionDialog_13);
        }
        catch (MalformedURLException malformedURLException) {
            status = new Status(2, "org.eclipse.help.ui", Messages.TestConnectionDialog_13);
        }
        this.updateStatus((IStatus)status);
        this.getButton(0).setEnabled(this.areFieldsValid());
        this.getButton(1).setEnabled(true);
    }

    public IC getIC() {
        return this.ic;
    }

    public void handleEvent(Event event) {
        this.updateValidity();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            this.testConnection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

