/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestData;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestdataFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguration;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguratonCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestDataEditingSupport;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestingManager;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestDataLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.gef.ZoomUndoRedoContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.ruler.FordiacRulerComposite;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class FBTester
extends GraphicalEditor
implements IFBTEditorPart {
    public static final String EXPECTED_EVENTS = "ExpectedEvents";
    public static final String EVENT = "Event";
    public static final String NAME = "Name";
    public static final String COLUMN_TYPE = "ColumnType";
    public static final String INPUT_VARIABLE = "InputVariable";
    public static final String OUTPUT_VARIABLE = "OutputVariable";
    private FBType type;
    private String path;
    private KeyHandler sharedKeyHandler;
    private StackLayout stack;
    protected Palette palette;
    private final Hashtable<String, IFBTestConfiguration> configurations = new Hashtable();
    private Composite configurationParent;
    private TableViewer testDataViewer;
    private CommandStack commandStack;
    private final Hashtable<String, TableColumn> dataColumns = new Hashtable();
    private final ArrayList<TestData> testDataCollection = new ArrayList();
    private RulerComposite rulerComp;
    EContentAdapter eContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            FBTester.this.testDataViewer.refresh();
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.type = untypedInput.getContent();
            PaletteGroup group = untypedInput.getPaletteEntry().getGroup();
            while (group.eContainer() != null) {
                group = group.eContainer();
            }
            if (group instanceof Palette) {
                this.palette = (Palette)group;
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        this.setPartName("FBTester");
        this.setTitleImage(FordiacImage.ICON_FBTester.getImage());
        super.init(site, input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        SashForm s = new SashForm(parent, 66048);
        Composite interfaceEditing = new Composite((Composite)s, 2048);
        interfaceEditing.setLayout((Layout)new GridLayout(2, false));
        Label testConfiguraionLabel = new Label(interfaceEditing, 0);
        testConfiguraionLabel.setText("Test Configuration");
        final Combo configurationCombo = new Combo(interfaceEditing, 2056);
        configurationCombo.setItems(this.getTestConfigurations().toArray(new String[0]));
        GridData configurationComboData = new GridData(4, 128, false, false);
        configurationCombo.setLayoutData((Object)configurationComboData);
        configurationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println(configurationCombo.getText());
                IFBTestConfiguration testConfiguration = (IFBTestConfiguration)FBTester.this.configurations.get(configurationCombo.getText());
                ((FBTester)FBTester.this).stack.topControl = testConfiguration.getControl();
                FBTester.this.configurationParent.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData configurationParentData = new GridData();
        configurationParentData.horizontalAlignment = 4;
        configurationParentData.verticalAlignment = 4;
        configurationParentData.grabExcessHorizontalSpace = true;
        configurationParentData.grabExcessVerticalSpace = true;
        configurationParentData.horizontalSpan = 2;
        this.configurationParent = new Group(interfaceEditing, 0);
        this.stack = new StackLayout();
        this.configurationParent.setLayout((Layout)this.stack);
        this.configurationParent.setLayoutData((Object)configurationParentData);
        this.createConfigurations(this.configurationParent);
        SashForm horizontal = new SashForm((Composite)s, 65792);
        Composite testData = new Composite((Composite)horizontal, 0);
        testData.setLayout((Layout)new GridLayout(1, true));
        this.createTestData(testData);
        Composite graphicaEditor = new Composite((Composite)horizontal, 0);
        graphicaEditor.setLayout((Layout)new FillLayout());
        s.setWeights(new int[]{30, 70});
        horizontal.setWeights(new int[]{50, 50});
        super.createPartControl(graphicaEditor);
    }

    private void createTestData(Composite parent) {
        ToolBar tb = new ToolBar(parent, 0x800100);
        ToolItem runItem = new ToolItem(tb, 0);
        runItem.setToolTipText("Run selected Tests");
        runItem.setImage(FordiacImage.ICON_RundDebug.getImage());
        ToolItem stopItem = new ToolItem(tb, 0);
        stopItem.setToolTipText("Stop");
        stopItem.setImage(FordiacImage.ICON_Stop.getImage());
        ToolItem saveItem = new ToolItem(tb, 0);
        saveItem.setToolTipText("Save Test Data");
        saveItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FBTester.this.saveTestData();
            }
        });
        ToolItem addItem = new ToolItem(tb, 0);
        addItem.setToolTipText("Add Test");
        addItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FBTester.this.addTest();
            }
        });
        ToolItem deleteItem = new ToolItem(tb, 0);
        deleteItem.setToolTipText("Delete Test");
        deleteItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)FBTester.this.testDataViewer.getSelection()).getFirstElement();
                FBTester.this.testDataCollection.remove(selection);
                FBTester.this.testDataViewer.refresh();
            }
        });
        Table table = new Table(parent, 67616);
        table.setLinesVisible(true);
        this.testDataViewer = new TableViewer(table);
        this.testDataViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                System.out.println(event);
                System.out.println(event.getSelection());
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof TestData) {
                    TestData data = (TestData)selection.getFirstElement();
                    Map<String, TestElement> testElements = TestingManager.getInstance().getTestElements(FBTester.this.type);
                    for (Map.Entry<String, TestElement> entry : testElements.entrySet()) {
                        String value = data.getValueFor(entry.getValue().getPortString());
                        if (value == null) continue;
                        System.out.println("set value");
                        testElements.get(entry.getKey()).setValue(value);
                    }
                    TestElement eventToTrigger = null;
                    Hashtable<String, TestElement> triggerElements = TestingManager.getInstance().getTriggerElements(FBTester.this.type);
                    Enumeration<String> triggerkeys = triggerElements.keys();
                    while (triggerkeys.hasMoreElements()) {
                        String key = triggerkeys.nextElement();
                        TestElement element = triggerElements.get(key);
                        if (!element.getInterfaceElement().getName().equals(data.getEvent().getName())) continue;
                        eventToTrigger = element;
                    }
                    if (eventToTrigger != null) {
                        System.out.println("-------------------------------------------------------------------------------- trigger event");
                        eventToTrigger.sendEvent();
                    }
                }
                System.out.println("double clicked");
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.testDataViewer.getTable().setLayoutData((Object)gridData);
        TableViewerColumn nameColumn = new TableViewerColumn(this.testDataViewer, 16384);
        nameColumn.getColumn().setWidth(80);
        nameColumn.getColumn().setText(NAME);
        nameColumn.getColumn().setData(COLUMN_TYPE, (Object)NAME);
        nameColumn.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, nameColumn.getColumn()));
        if (this.type != null && this.type.getInterfaceList() != null) {
            this.createInputVariableColumns(this.testDataViewer, (List<VarDeclaration>)this.type.getInterfaceList().getInputVars());
        }
        TableViewerColumn eventCol = new TableViewerColumn(this.testDataViewer, 16384);
        eventCol.getColumn().setWidth(80);
        eventCol.getColumn().setText(EVENT);
        eventCol.getColumn().setData(COLUMN_TYPE, (Object)EVENT);
        TableViewerColumn expectedEvents = new TableViewerColumn(this.testDataViewer, 16384);
        expectedEvents.getColumn().setWidth(100);
        expectedEvents.getColumn().setText("Expected Events");
        expectedEvents.getColumn().setData(COLUMN_TYPE, (Object)EXPECTED_EVENTS);
        if (this.type != null && this.type.getInterfaceList() != null) {
            this.createOutputVariableColumns(this.testDataViewer, (List<VarDeclaration>)this.type.getInterfaceList().getOutputVars());
        }
        table.setHeaderVisible(true);
        this.parseTestData();
        this.testDataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return FBTester.this.testDataCollection.toArray();
            }
        });
        this.testDataViewer.setLabelProvider((IBaseLabelProvider)new TestDataLabelProvider(this.type, table));
        this.testDataViewer.setInput(new Object());
        MenuManager popupMenu = new MenuManager();
        NewTestDataAction newRowAction = new NewTestDataAction();
        popupMenu.add((IAction)newRowAction);
        SaveTestDataAction saveAction = new SaveTestDataAction();
        popupMenu.add((IAction)saveAction);
        Menu menu = popupMenu.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void saveTestData() {
        if (this.path != null) {
            File testDataFile = new File(String.valueOf(this.path) + File.separatorChar + this.type.getName() + ".forte");
            try {
                FileOutputStream outStream = new FileOutputStream(testDataFile);
                DataOutputStream dataStream = new DataOutputStream(outStream);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dataStream));
                for (TestData testData : this.testDataCollection) {
                    writer.write(testData._getLine());
                    writer.newLine();
                }
                writer.flush();
                writer.close();
                dataStream.close();
                outStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    private void parseTestData() {
        block14: {
            File testDataFile;
            if (this.path != null && (testDataFile = new File(String.valueOf(this.path) + File.separatorChar + this.type.getName() + ".forte")).exists()) {
                BufferedReader data = null;
                try {
                    try {
                        String line;
                        FileInputStream fstream = new FileInputStream(testDataFile);
                        DataInputStream in = new DataInputStream(fstream);
                        data = new BufferedReader(new InputStreamReader(in));
                        while ((line = data.readLine()) != null) {
                            TestData testData = this.createTestData(line);
                            this.testDataCollection.add(testData);
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        if (data == null) break block14;
                        try {
                            data.close();
                        }
                        catch (IOException e2) {
                            Activator.getDefault().logError(e2.getMessage(), e2);
                        }
                    }
                }
                finally {
                    if (data != null) {
                        try {
                            data.close();
                        }
                        catch (IOException e) {
                            Activator.getDefault().logError(e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    private TestData createTestData(String line) {
        TestData testData = TestdataFactory.eINSTANCE.createTestData();
        testData.eAdapters().add((Object)this.eContentAdapter);
        testData.setType(this.type);
        testData.setLine(line);
        return testData;
    }

    private void createInputVariableColumns(TableViewer testData, List<VarDeclaration> list) {
        for (VarDeclaration input : list) {
            TableViewerColumn column = new TableViewerColumn(testData, 16384);
            column.getColumn().setWidth(40);
            column.getColumn().setText(input.getName());
            column.getColumn().setData(COLUMN_TYPE, (Object)INPUT_VARIABLE);
            column.getColumn().setData(INPUT_VARIABLE, (Object)input);
            column.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, column.getColumn()));
            this.dataColumns.put(input.getName(), column.getColumn());
        }
    }

    private void createOutputVariableColumns(TableViewer testData, List<VarDeclaration> list) {
        for (VarDeclaration output : list) {
            TableViewerColumn column = new TableViewerColumn(testData, 16384);
            column.getColumn().setWidth(40);
            column.getColumn().setText(output.getName());
            column.getColumn().setData(COLUMN_TYPE, (Object)OUTPUT_VARIABLE);
            column.getColumn().setData(OUTPUT_VARIABLE, (Object)output);
            column.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, column.getColumn()));
            this.dataColumns.put(output.getName(), column.getColumn());
        }
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getEditorInput());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ZoomScalableFreeformRootEditPart root = new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)this.getEditpartFactory());
        ZoomUndoRedoContextMenuProvider cmProvider = new ZoomUndoRedoContextMenuProvider((EditPartViewer)viewer, root.getZoomManager(), this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.registry.getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.copy", action);
            }
        };
        viewer.setContextMenu((MenuManager)cmProvider);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        KeyHandler viewerKeyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(viewerKeyHandler);
    }

    public ZoomManager getZoomManger() {
        return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected FBInterfaceEditPartFactory getEditpartFactory() {
        return new FBInterfaceEditPartFactory(this, this.palette, this.getZoomManger());
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        }
        return this.sharedKeyHandler;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new FordiacRulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    public List<String> getTestConfigurations() {
        ArrayList<String> configurations = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.fbtester.fbTesterConfiguration");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IFBTestConfiguratonCreator) {
                        String label = element.getAttribute("label");
                        configurations.add(label);
                    }
                }
                catch (Exception exception) {}
                ++j;
            }
            ++i;
        }
        return configurations;
    }

    public void createConfigurations(Composite parent) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.fbtester.fbTesterConfiguration");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IFBTestConfiguratonCreator) {
                        ((IFBTestConfiguratonCreator)obj).setType(this.type);
                        ((IFBTestConfiguratonCreator)obj).setGroup(this.palette.getRootGroup());
                        IFBTestConfiguration configuration = ((IFBTestConfiguratonCreator)obj).createConfigurationPage(parent);
                        String lang = element.getAttribute("label");
                        this.configurations.put(lang, configuration);
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                ++j;
            }
            ++i;
        }
    }

    void addTest() {
        String dataLine = "Testname;";
        dataLine = String.valueOf(dataLine) + this.type.getName();
        dataLine = String.valueOf(dataLine) + ";";
        if (this.type.getInterfaceList().getEventInputs().size() > 0) {
            Event event = (Event)this.type.getInterfaceList().getEventInputs().get(0);
            dataLine = String.valueOf(dataLine) + event.getWith().size() + ";";
            for (With with : event.getWith()) {
                VarDeclaration var = with.getVariables();
                dataLine = String.valueOf(dataLine) + var.getName() + ";" + "val" + ";";
            }
            dataLine = String.valueOf(dataLine) + event.getName() + ";";
        }
        if (this.type.getInterfaceList().getEventOutputs().size() > 0) {
            dataLine = String.valueOf(dataLine) + "1;";
            dataLine = String.valueOf(dataLine) + ((Event)this.type.getInterfaceList().getEventOutputs().get(0)).getName();
            dataLine = String.valueOf(dataLine) + ";";
        } else {
            dataLine = String.valueOf(dataLine) + "0;";
        }
        if (this.type.getInterfaceList().getOutputVars().size() > 0) {
            dataLine = String.valueOf(dataLine) + this.type.getInterfaceList().getOutputVars().size();
            dataLine = String.valueOf(dataLine) + ";";
            for (VarDeclaration var : this.type.getInterfaceList().getOutputVars()) {
                dataLine = String.valueOf(dataLine) + var.getName() + ";" + "val" + ";";
            }
        }
        TestData testData = this.createTestData(dataLine);
        this.testDataCollection.add(testData);
        this.testDataViewer.refresh();
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    private class NewTestDataAction
    extends Action {
        public NewTestDataAction() {
            super("New Test");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        public void run() {
            FBTester.this.addTest();
        }
    }

    private class SaveTestDataAction
    extends Action {
        public SaveTestDataAction() {
            super("Save Testdata");
        }

        public void run() {
            FBTester.this.saveTestData();
        }
    }
}

