/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.editparts.AbstractMonitoringBaseEditPart;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.util.preferences.PreferenceGetter;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class MonitoringEditPart
extends AbstractMonitoringBaseEditPart {
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("monitoringTransparency")) {
                ((SetableAlphaLabel)MonitoringEditPart.this.getFigure()).setAlpha(PreferenceConstants.getMonitoringTransparency());
            }
        }
    };

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public boolean isEvent() {
        return this.getInterfaceElement() instanceof Event;
    }

    public boolean isVariable() {
        return this.getInterfaceElement() instanceof VarDeclaration;
    }

    @Override
    public MonitoringElement getModel() {
        return (MonitoringElement)super.getModel();
    }

    protected void createEditPolicies() {
        if (!this.isEvent()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                protected Command getDirectEditCommand(DirectEditRequest request) {
                    String value = (String)request.getCellEditor().getValue();
                    MonitoringEditPart editPart = (MonitoringEditPart)this.getHost();
                    MonitoringManager.getInstance().writeValue(editPart.getModel(), value);
                    return null;
                }

                protected void showCurrentEditValue(DirectEditRequest request) {
                    String value = (String)request.getCellEditor().getValue();
                    MonitoringEditPart editPart = (MonitoringEditPart)this.getHost();
                    if (editPart != null) {
                        editPart.getNameLabel().setText(value);
                    }
                }
            });
        }
    }

    @Override
    protected void setBackgroundColor(IFigure l) {
        if (this.getModel().isForce()) {
            l.setBackgroundColor(PreferenceGetter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"forceColor"));
        } else {
            super.setBackgroundColor(l);
        }
    }

    protected IFigure createFigureForModel() {
        SetableAlphaLabel l = new SetableAlphaLabel();
        this.setBackgroundColor((IFigure)l);
        l.setOpaque(true);
        if (this.isInput()) {
            l.setLabelAlignment(4);
            l.setTextAlignment(4);
        } else {
            l.setTextAlignment(1);
            l.setLabelAlignment(1);
        }
        l.setBorder((Border)new MarginBorder(0, 5, 0, 5));
        l.setText("N/A");
        l.setMinimumSize(new Dimension(50, 1));
        l.setAlpha(PreferenceConstants.getMonitoringTransparency());
        return l;
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MonitoringEditPart.this.setValue(MonitoringEditPart.this.getModel().getCurrentValue());
                        MonitoringEditPart.this.refreshVisuals();
                    }
                });
            }
        };
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            if (!this.isEvent()) {
                this.performDirectEdit();
            }
        } else {
            super.performRequest(request);
        }
    }

    @Override
    public boolean understandsRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return this.isVariable();
        }
        return super.understandsRequest(request);
    }

    public void setValue(String string) {
        if (this.isActive() && this.getFigure() != null) {
            if (this.getModel().isForce() && this.getModel().getForceValue() != null) {
                ((Label)this.getFigure()).setText(String.valueOf(this.getModel().getForceValue()) + " (" + string + ")");
            } else {
                ((Label)this.getFigure()).setText(string);
            }
            this.refreshVisuals();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateBreakpoint();
    }

    public void updateBreakpoint() {
        if (this.getModel().isBreakpoint()) {
            if (((Label)this.getFigure()).getIcon() == null) {
                ((Label)this.getFigure()).setIcon(FordiacImage.ICON_BreakPoint.getImage());
            }
        } else {
            ((Label)this.getFigure()).setIcon(null);
        }
        if (this.getModel().isBreakpointActive()) {
            this.getFigure().setBackgroundColor(ColorConstants.red);
        } else {
            this.setBackgroundColor(this.getFigure());
        }
    }
}

