/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionHelpers;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.gef.commands.Command;

public class ChangeConditionEventCommand
extends Command {
    private final ECTransition transition;
    private final ArrayList<Event> eventList = new ArrayList();
    private String conditionEvent;
    private String oldConditionEvent;
    private String oldConditionExpression;

    public ChangeConditionEventCommand(ECTransition transition, String conditionEvent) {
        this.transition = transition;
        this.conditionEvent = conditionEvent;
        this.getEvents();
    }

    public boolean canExecute() {
        return this.conditionEvent.equals("") || this.eventList != null && !this.eventList.isEmpty();
    }

    public ArrayList<Event> getEvents() {
        this.eventList.clear();
        BasicFBType types = (BasicFBType)this.transition.eContainer().eContainer();
        this.eventList.addAll((Collection<Event>)types.getInterfaceList().getEventInputs());
        for (AdapterDeclaration socket : types.getInterfaceList().getSockets()) {
            if (!(socket.getType() instanceof AdapterType)) continue;
            this.eventList.addAll(ECActionHelpers.createAdapterEventList((EList<Event>)((AdapterType)socket.getType()).getInterfaceList().getEventOutputs(), socket));
        }
        for (AdapterDeclaration plug : types.getInterfaceList().getPlugs()) {
            if (!(plug.getType() instanceof AdapterType)) continue;
            this.eventList.addAll(ECActionHelpers.createAdapterEventList((EList<Event>)((AdapterType)plug.getType()).getInterfaceList().getEventInputs(), plug));
        }
        return this.eventList;
    }

    public void execute() {
        String string = this.oldConditionEvent = this.transition.getConditionEvent() != null ? this.transition.getConditionEvent().getName() : "";
        if (this.conditionEvent.equals("1")) {
            this.oldConditionExpression = this.transition.getConditionExpression();
        }
        if ("1".equals(this.transition.getConditionExpression())) {
            this.oldConditionExpression = this.transition.getConditionExpression();
            this.transition.setConditionExpression("");
        }
        this.redo();
    }

    public void undo() {
        if (this.oldConditionExpression != null) {
            this.transition.setConditionExpression(this.oldConditionExpression);
        }
        this.transition.setConditionEvent(this.getEvent(this.oldConditionEvent));
    }

    public void redo() {
        if (this.conditionEvent.equals("1")) {
            this.transition.setConditionExpression("1");
            this.transition.setConditionEvent(null);
        } else {
            this.transition.setConditionEvent(this.getEvent(this.conditionEvent));
        }
    }

    private Event getEvent(String event) {
        for (Event e : this.eventList) {
            if (!e.getName().equals(event)) continue;
            return e;
        }
        return null;
    }
}

