/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public class ECActionHelpers {
    static boolean setOutputEventRunning = false;

    public static List<Event> getOutputEvents(BasicFBType type) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (type != null) {
            events.addAll((Collection<Event>)type.getInterfaceList().getEventOutputs());
            for (AdapterDeclaration socket : type.getInterfaceList().getSockets()) {
                if (!(socket.getType() instanceof AdapterType)) continue;
                events.addAll(ECActionHelpers.createAdapterEventList((EList<Event>)((AdapterType)socket.getType()).getInterfaceList().getEventInputs(), socket));
            }
            for (AdapterDeclaration plug : type.getInterfaceList().getPlugs()) {
                if (!(plug.getType() instanceof AdapterType)) continue;
                events.addAll(ECActionHelpers.createAdapterEventList((EList<Event>)((AdapterType)plug.getType()).getInterfaceList().getEventOutputs(), plug));
            }
            Collections.sort(events, NamedElementComparator.INSTANCE);
        }
        return events;
    }

    public static List<String> getOutputEventNames(BasicFBType type) {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (Event event : ECActionHelpers.getOutputEvents(type)) {
            eventNames.add(event.getName());
        }
        return eventNames;
    }

    public static List<Event> createAdapterEventList(EList<Event> events, AdapterDeclaration adapter) {
        ArrayList<Event> adapterEvents = new ArrayList<Event>();
        for (Event event : events) {
            AdapterEvent ae = LibraryElementFactory.eINSTANCE.createAdapterEvent();
            ae.setName(event.getName());
            ae.setComment(event.getComment());
            ae.setAdapterDeclaration(adapter);
            adapterEvents.add((Event)ae);
        }
        return adapterEvents;
    }

    public static List<Algorithm> getAlgorithms(BasicFBType type) {
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        algorithms.addAll((Collection<Algorithm>)type.getAlgorithm());
        Collections.sort(algorithms, NamedElementComparator.INSTANCE);
        return algorithms;
    }

    public static BasicFBType getFBType(ECAction action) {
        if (action.eContainer() != null && action.eContainer().eContainer() != null && action.eContainer().eContainer().eContainer() != null) {
            return (BasicFBType)action.eContainer().eContainer().eContainer();
        }
        return null;
    }
}

