/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeOutputCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionHelpers;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmGroup;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmList;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ActionSection
extends AbstractECSection {
    private Composite actionComposite;
    private Combo algorithmCombo;
    private Combo outputEventCombo;
    private AlgorithmGroup algorithmGroup;
    private AlgorithmList algorithmList;
    private Map<String, Event> events = new HashMap<String, Event>();

    protected ECAction getType() {
        return (ECAction)this.type;
    }

    protected Algorithm getAlgorithm() {
        return this.getType().getAlgorithm();
    }

    protected EList<Event> getOutputEvents() {
        BasicFBType fb = ECActionHelpers.getFBType(this.getType());
        return fb != null ? fb.getInterfaceList().getEventOutputs() : ECollections.emptyEList();
    }

    protected Object getInputType(Object input) {
        if (input instanceof ECActionAlgorithmEditPart) {
            return ((ECActionAlgorithmEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionAlgorithm) {
            return ((ECActionAlgorithm)input).getAction();
        }
        if (input instanceof ECActionOutputEventEditPart) {
            return ((ECActionOutputEventEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionOutputEvent) {
            return ((ECActionOutputEvent)input).getAction();
        }
        if (input instanceof ECAction) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(3, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createActionCombos(parent);
        this.algorithmGroup = new AlgorithmGroup(parent, this.getWidgetFactory());
        this.createAlgorithmView(parent);
    }

    private void createActionCombos(Composite parent) {
        this.actionComposite = this.getWidgetFactory().createComposite(parent);
        GridData actionCompositeLayoutData = new GridData(4, 0, true, false);
        actionCompositeLayoutData.horizontalSpan = 3;
        this.actionComposite.setLayoutData((Object)actionCompositeLayoutData);
        RowLayout layout = new RowLayout();
        layout.fill = true;
        this.actionComposite.setLayout((Layout)layout);
        this.getWidgetFactory().createCLabel(this.actionComposite, "Algorithm: ");
        this.algorithmCombo = new Combo(this.actionComposite, 12);
        this.algorithmCombo.addListener(13, event -> {
            this.removeContentAdapter();
            if (this.algorithmCombo.indexOf(this.algorithmCombo.getText()) > 0) {
                BasicFBType fb = ECActionHelpers.getFBType(this.getType());
                if (fb != null) {
                    this.executeCommand(new ChangeAlgorithmCommand(this.getType(), (Algorithm)fb.getAlgorithm().get(this.algorithmCombo.indexOf(this.algorithmCombo.getText()) - 1)));
                }
            } else {
                this.executeCommand(new ChangeAlgorithmCommand(this.getType(), null));
            }
            this.algorithmGroup.setAlgorithm(this.getAlgorithm());
            this.algorithmList.refresh();
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(this.actionComposite, "Output Event: ");
        this.outputEventCombo = new Combo(this.actionComposite, 12);
        this.outputEventCombo.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeOutputCommand(this.getType(), this.events.get(this.outputEventCombo.getText())));
            this.addContentAdapter();
        });
    }

    private void createAlgorithmView(Composite parent) {
        Group algorithmComposite = this.getWidgetFactory().createGroup(parent, "All Algorithms");
        algorithmComposite.setLayout((Layout)new GridLayout(1, false));
        algorithmComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.algorithmList = new AlgorithmList((Composite)algorithmComposite, this.getWidgetFactory());
        this.algorithmList.getAlgorithmViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActionSection.this.refresh();
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.outputEventCombo.removeAll();
            this.outputEventCombo.setEnabled(false);
            this.algorithmCombo.removeAll();
            this.algorithmCombo.setEnabled(false);
        }
        this.setType(input);
        BasicFBType type = ECActionHelpers.getFBType(this.getType());
        this.algorithmGroup.initialize(type, this.commandStack);
        this.algorithmList.initialize(type, this.commandStack);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.setOutputEventDropdown();
            this.outputEventCombo.select(this.getType().getOutput() != null ? this.outputEventCombo.indexOf(this.getType().getOutput().getName()) : this.outputEventCombo.indexOf(""));
            this.setAlgorithmDropdown();
            this.algorithmGroup.setAlgorithm(this.getAlgorithm());
            this.algorithmList.refresh();
        }
        this.commandStack = commandStackBuffer;
    }

    private void setOutputEventDropdown() {
        this.outputEventCombo.removeAll();
        this.events.clear();
        for (Event e : ECActionHelpers.getOutputEvents(ECActionHelpers.getFBType(this.getType()))) {
            String name = e.getName();
            this.outputEventCombo.add(name);
            this.events.put(name, e);
        }
        this.outputEventCombo.add(" ");
    }

    private void setAlgorithmDropdown() {
        this.algorithmCombo.removeAll();
        this.algorithmCombo.add("");
        BasicFBType fb = ECActionHelpers.getFBType(this.getType());
        if (fb != null) {
            for (Algorithm alg : fb.getAlgorithm()) {
                this.algorithmCombo.add(alg.getName());
            }
        }
        this.algorithmCombo.select(this.getAlgorithm() == null ? 0 : this.algorithmCombo.indexOf(this.getAlgorithm().getName()));
        this.actionComposite.layout();
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

