/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmTypeCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.AlgorithmsLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AlgorithmList {
    private static final String A_NAME = "Name";
    private static final String A_LANGUAGE = "Language";
    private static final String A_COMMENT = "Comment";
    private Button algorithmDelete;
    private TableViewer algorithmViewer;
    private Composite composite;
    private BasicFBType type;
    private CommandStack commandStack;

    TableViewer getAlgorithmViewer() {
        return this.algorithmViewer;
    }

    public AlgorithmList(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.composite = widgetFactory.createComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gridDataVersionViewer);
        this.createAddDelteButtons(widgetFactory);
        this.createAlgorithmViewer();
    }

    Composite getComposite() {
        return this.composite;
    }

    public void initialize(BasicFBType type, CommandStack commandStack) {
        this.type = type;
        this.commandStack = commandStack;
    }

    private void createAddDelteButtons(TabbedPropertySheetWidgetFactory widgetFactory) {
        Composite buttonComp = new Composite(this.composite, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        buttonComp.setLayoutData((Object)buttonCompLayoutData);
        buttonComp.setLayout((Layout)new FillLayout(512));
        Button algorithmNew = widgetFactory.createButton(buttonComp, "", 0x800000);
        algorithmNew.setToolTipText("Create new algorithm");
        algorithmNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        algorithmNew.addListener(13, event -> {
            CreateAlgorithmCommand cmd = new CreateAlgorithmCommand(this.type);
            this.executeCommand(cmd);
            this.algorithmViewer.refresh();
            if (cmd.getNewAlgorithm() != null) {
                this.algorithmViewer.setSelection((ISelection)new StructuredSelection((Object)cmd.getNewAlgorithm()), true);
            }
        });
        this.algorithmDelete = widgetFactory.createButton(buttonComp, "", 8);
        this.setAlgorithmDeleteState(false);
        this.algorithmDelete.setToolTipText("Delete selected algorithm");
        this.algorithmDelete.addListener(13, event -> {
            this.executeCommand(new DeleteAlgorithmCommand(this.type, (Algorithm)((IStructuredSelection)this.algorithmViewer.getSelection()).getFirstElement()));
            this.algorithmViewer.refresh();
        });
    }

    private void createAlgorithmViewer() {
        this.algorithmViewer = new TableViewer(this.composite, 68096);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.heightHint = 150;
        gridDataVersionViewer.widthHint = 80;
        this.algorithmViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.algorithmViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.algorithmViewer.getTable(), 16384);
        column1.setText(A_NAME);
        TableColumn column2 = new TableColumn(this.algorithmViewer.getTable(), 0x1000000);
        column2.setText(A_LANGUAGE);
        TableColumn column3 = new TableColumn(this.algorithmViewer.getTable(), 16384);
        column3.setText(A_COMMENT);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        table.setLayout((Layout)layout);
        this.algorithmViewer.setCellEditors(AlgorithmList.createAlgorithmCellEditors(table));
        this.algorithmViewer.setColumnProperties(new String[]{A_NAME, A_LANGUAGE, A_COMMENT});
        this.algorithmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.algorithmViewer.setLabelProvider((IBaseLabelProvider)new AlgorithmsLabelProvider());
        this.algorithmViewer.setCellModifier((ICellModifier)new AlgorithmViewerCellModifier());
        this.algorithmViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgorithmList.this.setAlgorithmDeleteState(((IStructuredSelection)AlgorithmList.this.algorithmViewer.getSelection()).getFirstElement() != null);
            }
        });
    }

    private void executeCommand(Command cmd) {
        if (this.type != null && this.commandStack != null) {
            this.commandStack.execute(cmd);
        }
    }

    private void setAlgorithmDeleteState(boolean enabled) {
        this.algorithmDelete.setEnabled(enabled);
        this.algorithmDelete.setImage(enabled ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    private static CellEditor[] createAlgorithmCellEditors(Table table) {
        TextCellEditor algorithmNameEditor = new TextCellEditor((Composite)table);
        ((Text)algorithmNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        return new CellEditor[]{algorithmNameEditor, new ComboBoxCellEditor((Composite)table, AbstractECSection.getLanguages().toArray(new String[0]), 8), new TextCellEditor((Composite)table)};
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.algorithmViewer.setInput((Object)this.type.getAlgorithm());
        }
        this.commandStack = commandStackBuffer;
    }

    private class AlgorithmViewerCellModifier
    implements ICellModifier {
        private AlgorithmViewerCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            switch (property) {
                case "Name": {
                    return ((Algorithm)element).getName();
                }
                case "Language": {
                    return element instanceof STAlgorithm ? 1 : 0;
                }
            }
            return ((Algorithm)element).getComment();
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Algorithm data = (Algorithm)tableItem.getData();
            Object cmd = null;
            cmd = AlgorithmList.A_NAME.equals(property) ? new ChangeNameCommand((INamedElement)data, value.toString()) : (AlgorithmList.A_LANGUAGE.equals(property) ? new ChangeAlgorithmTypeCommand(AlgorithmList.this.type, data, AbstractECSection.getLanguages().get((Integer)value)) : new ChangeCommentCommand((INamedElement)data, value.toString()));
            if (cmd != null && AlgorithmList.this.commandStack != null) {
                AlgorithmList.this.executeCommand((Command)cmd);
                AlgorithmList.this.algorithmViewer.refresh((Object)data);
                if (cmd instanceof ChangeAlgorithmTypeCommand) {
                    data = ((ChangeAlgorithmTypeCommand)((Object)cmd)).getNewAlgorithm();
                }
                if (data != null) {
                    AlgorithmList.this.algorithmViewer.setSelection((ISelection)new StructuredSelection((Object)data));
                }
                AlgorithmList.this.refresh();
            }
        }
    }
}

