/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.SimpleEtchedBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ModifiedMoveHandle
extends MoveHandle {
    private Insets insets = new Insets(2);
    private int arc = 20;

    public ModifiedMoveHandle(GraphicalEditPart owner, Insets insets, int arc) {
        super(owner);
        this.insets = insets;
        this.arc = arc;
    }

    public ModifiedMoveHandle(GraphicalEditPart owner) {
        super(owner);
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBorder(SimpleEtchedBorder.singleton);
        this.setBorder((Border)new SchemeBorder(){

            public void paint(IFigure figure, Graphics g, Insets insets) {
                Rectangle rect = 1.getPaintRectangle((IFigure)figure, (Insets)insets);
                IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
                RGB color = PreferenceConverter.getColor((IPreferenceStore)pf, (String)"SelectionColor");
                Color rgb = new Color(null, color);
                Color highlight = FigureUtilities.lighter((Color)rgb);
                this.paintEtchedBorder(g, rect, rgb, highlight);
                highlight.dispose();
                rgb.dispose();
            }

            public Insets getInsets(IFigure figure) {
                return ModifiedMoveHandle.this.insets;
            }

            private void paintEtchedBorder(Graphics g, Rectangle r, Color shadow, Color highlight) {
                int x = r.x;
                int y = r.y;
                int w = r.width;
                int h = r.height;
                g.setLineStyle(1);
                g.setLineWidth(1);
                g.setXORMode(false);
                Rectangle rect = new Rectangle(x, y, w -= 2, h -= 2);
                g.setForegroundColor(shadow);
                g.drawRoundRectangle(rect, ModifiedMoveHandle.this.arc, ModifiedMoveHandle.this.arc);
            }
        });
        this.setCursor(Cursors.SIZEALL);
    }
}

