/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.router.IConnectionRouterFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DiagramPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CONNECTION_ROUTER = "ConnectionRouter";
    public static final String SELECTION_COLOR = "SelectionColor";
    public static final String CORNER_DIM = "CornerDim";
    public static final String GRID_SPACING = "GridSpacing";
    public static final String SNAP_TO_GRID = "SnapToGrid";
    public static final String SHOW_GRID = "ShowGrid";
    public static final String SHOW_RULERS = "ShowRulers";

    public DiagramPreferences() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("General Diagram Preferences");
    }

    public void createFieldEditors() {
        Object routerFactory;
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText("Ruler and Grid");
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        BooleanFieldEditor showRulers = new BooleanFieldEditor(SHOW_RULERS, "Show Ruler", (Composite)group);
        this.addField((FieldEditor)showRulers);
        BooleanFieldEditor showGrid = new BooleanFieldEditor(SHOW_GRID, "Show Grid", (Composite)group);
        this.addField((FieldEditor)showGrid);
        BooleanFieldEditor snapToGrid = new BooleanFieldEditor(SNAP_TO_GRID, "Snap to Grid", (Composite)group);
        this.addField((FieldEditor)snapToGrid);
        IntegerFieldEditor gridSpacing = new IntegerFieldEditor(GRID_SPACING, "Grid spacing in pixels", (Composite)group);
        gridSpacing.setTextLimit(10);
        this.addField((FieldEditor)gridSpacing);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        Group router = new Group(this.getFieldEditorParent(), 0);
        router.setText("Connection Router");
        GridLayout routerLayout = new GridLayout(2, false);
        HashMap<String, Object> connectionRouter = new HashMap<String, Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.gef", "ConnectionRouterProvider");
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement element = elems[i];
            try {
                Object object = element.createExecutableExtension("class");
                String name = element.getAttribute("name");
                if (object instanceof IConnectionRouterFactory) {
                    routerFactory = (IConnectionRouterFactory)object;
                    connectionRouter.put(name, routerFactory);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading ConnectionRouter", (Exception)((Object)corex));
            }
            ++i;
        }
        Set keySet = connectionRouter.keySet();
        String[][] nameArray = new String[keySet.size()][2];
        int i2 = 0;
        routerFactory = keySet.iterator();
        while (routerFactory.hasNext()) {
            String key;
            nameArray[i2][0] = key = (String)routerFactory.next();
            nameArray[i2][1] = key;
            ++i2;
        }
        ComboFieldEditor routerEditor = new ComboFieldEditor(CONNECTION_ROUTER, "Default Router", nameArray, (Composite)router);
        this.addField((FieldEditor)routerEditor);
        GridData routerData = new GridData(768);
        routerData.grabExcessHorizontalSpace = true;
        routerData.horizontalSpan = 2;
        router.setLayoutData((Object)routerData);
        router.setLayout((Layout)routerLayout);
        Group color = new Group(this.getFieldEditorParent(), 0);
        color.setText("Colors");
        GridLayout colorLayout = new GridLayout(2, false);
        ColorFieldEditor selectionBorderColor = new ColorFieldEditor(SELECTION_COLOR, "Selection Color", (Composite)color);
        this.addField((FieldEditor)selectionBorderColor);
        color.setLayout((Layout)colorLayout);
        color.setLayoutData((Object)new GridData(768));
        Group arc = new Group(this.getFieldEditorParent(), 0);
        arc.setText("FB");
        GridLayout arcLayout = new GridLayout(2, false);
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(CORNER_DIM, "Corner Dimension", (Composite)arc);
        integerFieldEditor.setValidRange(0, 15);
        this.addField((FieldEditor)integerFieldEditor);
        arc.setLayout((Layout)arcLayout);
        arc.setLayoutData((Object)new GridData(768));
    }

    public void init(IWorkbench workbench) {
    }
}

