/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.ReferencedTypeNotFoundException;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RESImporter {
    public static ResourceType importResType(IFile resFile, Palette palette) {
        if (resFile.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            try {
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(resFile.getContents());
                Element rootNode = document.getDocumentElement();
                ResourceType type = LibraryElementFactory.eINSTANCE.createResourceType();
                return RESImporter.parseResType(type, rootNode, palette);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private static ResourceType parseResType(ResourceType type, Node rootNode, Palette palette) throws TypeImportException, ReferencedTypeNotFoundException, ParseException {
        if (rootNode.getNodeName().equals("ResourceType")) {
            NamedNodeMap map = rootNode.getAttributes();
            CommonElementImporter.readNameCommentAttributes(type, map);
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    type.setIdentification(CommonElementImporter.parseIdentification(type, n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    type.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(type, n));
                }
                if (n.getNodeName().equals("CompilerInfo")) {
                    type.setCompilerInfo(CompilableElementImporter.parseCompilerInfo(type, n));
                }
                if (n.getNodeName().equals("VarDeclaration")) {
                    VarDeclaration v = ImportUtils.parseVarDeclaration(n);
                    v.setIsInput(true);
                    type.getVarDeclaration().add((Object)v);
                }
                n.getNodeName().equals("FBTypeName");
                if (n.getNodeName().equals("FBNetwork")) {
                    type.setFBNetwork(new ResDevFBNetworkImporter(palette, type.getVarDeclaration()).parseFBNetwork(n));
                }
                ++i;
            }
            return type;
        }
        throw new ParseException(Messages.FBTImporter_PARSE_FBTYPE_PARSEEXCEPTION, 0);
    }
}

