/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtest.automatedRemoteTest;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.Activator;
import org.eclipse.fordiac.ide.util.comm.channels.ChannelManager;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.channels.IIecSender;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public class ART_TCPClient
implements IIecReceivable,
IIecSender {
    private ChannelManager manager = ChannelManager.getInstance();
    private List<List<IEC_ANY>> receiveDataList;
    private int ReceiveListSize = 0;
    private int counter = 0;
    private String channelID;

    public List<List<IEC_ANY>> getReceiveDataList() {
        return this.receiveDataList;
    }

    public ART_TCPClient(String paID, List<List<IEC_ANY>> paReceiveDataListList, int paListSize) throws CommException {
        this.channelID = paID;
        if (!this.Initialize(paID)) {
            throw new CommException("Initialisation of CommunicationChannel to Runtime failed");
        }
        this.receiveDataList = paReceiveDataListList;
        this.ReceiveListSize = paListSize;
        if (this.receiveDataList != null) {
            if (this.receiveDataList.size() != paListSize) {
                this.ReceiveListSize = this.receiveDataList.size();
            }
        } else {
            paListSize = 0;
        }
    }

    private boolean ReceivedDataTypeMatch(List<IEC_ANY> receivedList, List<IEC_ANY> localList) {
        if (receivedList.size() != localList.size()) {
            return false;
        }
        boolean equal = true;
        int i = 0;
        while (i < receivedList.size()) {
            if (receivedList.get(i).getClass() != localList.get(i).getClass()) {
                equal = false;
            }
            ++i;
        }
        return equal;
    }

    private boolean CopyData(List<IEC_ANY> receivedList, List<IEC_ANY> localList) {
        if (receivedList.size() != localList.size()) {
            return false;
        }
        int i = 0;
        while (i < receivedList.size()) {
            if (receivedList.get(i).getClass() == localList.get(i).getClass()) {
                localList.set(i, receivedList.get(i));
            }
            ++i;
        }
        return true;
    }

    public synchronized void ReceiveIECData(List<IEC_ANY> inList) {
        if (this.ReceiveListSize > this.counter) {
            if (!this.ReceivedDataTypeMatch(inList, this.receiveDataList.get(this.counter))) {
                System.out.println("did not receive expected data");
                return;
            }
            this.CopyData(inList, this.receiveDataList.get(this.counter));
            ++this.counter;
        } else {
            System.out.println("no space for received data");
        }
    }

    protected void SendIECData(String ID, List<IEC_ANY> sendData) {
        try {
            ChannelManager.send((String)ID, (int)1, sendData);
        }
        catch (CommException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void setMyReceiveDataList(List<List<IEC_ANY>> myReceiveData) {
        this.receiveDataList = myReceiveData;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public int getCounter() {
        return this.counter;
    }

    public void deRegister() throws CommException {
        this.manager.deregister(this.channelID);
    }

    public boolean Initialize(String pa_sID) {
        try {
            this.manager.register(pa_sID, 1, (IIecReceivable)this);
        }
        catch (CommException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean DeInitialize(String pa_sID) {
        try {
            this.manager.deregister(pa_sID);
        }
        catch (CommException commException) {
            return false;
        }
        return true;
    }

    public synchronized void SendIECData(List<IEC_ANY> sendData) throws CommException {
        ChannelManager.send((String)this.channelID, (int)1, sendData);
        this.counter = 0;
    }

    public void setMyReceiveData(List<IEC_ANY> pa_loReceiveData) {
        this.receiveDataList = new ArrayList<List<IEC_ANY>>();
        this.receiveDataList.add(pa_loReceiveData);
    }
}

