/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.osgi.service.prefs.BackingStoreException;

public class MissingContentManager {
    private static final String HELP_PROTOCOL = "help:";
    private static final String EXTENSION_POINT_ID_TOC = "org.eclipse.help.toc";
    private static final String ELEMENT_NAME_PLACEHOLDER = "placeholder";
    private static final String ATTRIBUTE_NAME_PLUGIN = "plugin";
    private static final String ATTRIBUTE_NAME_PLACEHOLDER_PAGE = "placeholderPage";
    public static final String IGNORE_MISSING_PLACEHOLDER_PREFERENCE = "ignorePlaceholders";
    public static final String REMOTE_STATUS_HREF = "NetworkHelpStatus.html";
    public static final String REMOTE_STATUS_HELP_VIEW_HREF = "NetworkHelpStatusHV.html";
    public static final String MISSING_TOPIC_HREF = "MissingTopicStatus.html";
    public static final String MISSING_TOPIC_PATH = "missingTopic/";
    public static final String MISSING_BOOKS_HREF = "MissingBooks.html";
    public static final String MISSING_BOOKS_HELP_VIEW_HREF = "MissingBooksHV.html";
    private static MissingContentManager instance;
    private List<Placeholder> placeholders;
    private Set<String> bundlesToIgnore;

    public static MissingContentManager getInstance() {
        if (instance == null) {
            instance = new MissingContentManager();
        }
        return instance;
    }

    private MissingContentManager() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.placeholders = new ArrayList<Placeholder>();
        this.bundlesToIgnore = new HashSet<String>();
        if (BaseHelpSystem.getMode() == 1) {
            return;
        }
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID_TOC);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            String pluginId = elem.getContributor().getName();
            if (elem.getName().equals(ELEMENT_NAME_PLACEHOLDER)) {
                try {
                    String plugin = elem.getAttribute(ATTRIBUTE_NAME_PLUGIN);
                    String path = HELP_PROTOCOL + plugin + '/';
                    String placeholder = elem.getAttribute(ATTRIBUTE_NAME_PLACEHOLDER_PAGE);
                    this.placeholders.add(new Placeholder(path, plugin, placeholder));
                }
                catch (Exception e) {
                    String msg = "Exception reading placeholder extension in bundle" + pluginId;
                    HelpPlugin.logError((String)msg, (Throwable)e);
                }
            }
            ++i;
        }
        Collections.sort(this.placeholders);
        String ignoredBundles = Platform.getPreferencesService().getString("org.eclipse.help.base", IGNORE_MISSING_PLACEHOLDER_PREFERENCE, "", null);
        if (ignoredBundles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(ignoredBundles, " ,");
            while (tokenizer.hasMoreTokens()) {
                this.bundlesToIgnore.add(tokenizer.nextToken());
            }
        }
    }

    public String getPageNotFoundPage(String path, boolean showPlaceholderPage) {
        for (Placeholder placeholder : this.placeholders) {
            if (!path.startsWith(placeholder.path) || Platform.getBundle((String)placeholder.bundle) != null) continue;
            if (showPlaceholderPage) {
                return placeholder.placeholderPage;
            }
            return "/org.eclipse.help.webapp/missingTopic/" + path.substring(HELP_PROTOCOL.length());
        }
        return Platform.getPreferencesService().getString("org.eclipse.help.base", "page_not_found", null, null);
    }

    public boolean isUnresolvedPlaceholders() {
        if (BaseHelpSystem.getMode() == 1) {
            return false;
        }
        Placeholder[] unresolvedPlaceHolders = this.getUnresolvedPlaceholders();
        return unresolvedPlaceHolders.length > 0;
    }

    public String getHelpMissingPage(boolean isHelpView) {
        Placeholder[] unresolvedPlaceHolders = this.getUnresolvedPlaceholders();
        if (unresolvedPlaceHolders.length == 0) {
            return null;
        }
        String suffix = isHelpView ? MISSING_BOOKS_HELP_VIEW_HREF : MISSING_BOOKS_HREF;
        return "/org.eclipse.help.webapp/" + suffix;
    }

    public String getRemoteHelpUnavailablePage(boolean isHelpView) {
        if (BaseHelpSystem.getMode() != 1) {
            String suffix = isHelpView ? REMOTE_STATUS_HELP_VIEW_HREF : REMOTE_STATUS_HREF;
            return "/org.eclipse.help.webapp/" + suffix;
        }
        return null;
    }

    public Placeholder[] getUnresolvedPlaceholders() {
        ArrayList<Placeholder> unresolved = new ArrayList<Placeholder>();
        for (Placeholder ph : this.placeholders) {
            String bundle = ph.bundle;
            if (bundle == null || this.bundlesToIgnore.contains(bundle) || Platform.getBundle((String)bundle) != null) continue;
            unresolved.add(ph);
        }
        return unresolved.toArray(new Placeholder[unresolved.size()]);
    }

    public void ignoreAllMissingPlaceholders() {
        Placeholder[] unresolved = this.getUnresolvedPlaceholders();
        String ignoredBundles = Platform.getPreferencesService().getString("org.eclipse.help.base", IGNORE_MISSING_PLACEHOLDER_PREFERENCE, "", null);
        int i = 0;
        while (i < unresolved.length) {
            String bundle = unresolved[i].bundle;
            this.bundlesToIgnore.add(bundle);
            if (ignoredBundles.length() > 0) {
                ignoredBundles = String.valueOf(ignoredBundles) + ',';
            }
            ignoredBundles = String.valueOf(ignoredBundles) + bundle;
            ++i;
        }
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.help.base");
        prefs.put(IGNORE_MISSING_PLACEHOLDER_PREFERENCE, ignoredBundles);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            HelpBasePlugin.logError("Cannot save preferences", e);
        }
    }

    public static class Placeholder
    implements Comparable<Placeholder> {
        public String path;
        public String bundle;
        public String placeholderPage;

        public Placeholder(String path, String bundle, String placeholderPage) {
            this.path = path;
            this.bundle = bundle;
            this.placeholderPage = placeholderPage;
        }

        @Override
        public int compareTo(Placeholder o) {
            return o.path.compareTo(this.path);
        }
    }
}

