/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte1_0_x;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.forte1_0_x.Activator;
import org.eclipse.fordiac.ide.export.forte1_0_x.ForteExportFilter1_0_x;
import org.eclipse.fordiac.ide.export.forte1_0_x.StructuredTextException;

public class StructuredTextEmitter {
    private boolean inExpression;
    private PrintWriter pwCPP = null;
    private ForteExportFilter1_0_x exportFilter;
    private LinkedList<Conditionals> condtionalQueue = new LinkedList();
    Vector<ForValBuffer> forValBuf = new Vector();
    private static final String[] elementaryTypeNames = new String[]{"BOOL", "SINT", "INT", "DINT", "LINT", "USINT", "UINT", "UDINT", "ULINT", "REAL", "LREAL", "BYTE", "WORD", "DWORD", "LWORD"};

    public StructuredTextEmitter(ForteExportFilter1_0_x exportFilter) {
        this.exportFilter = exportFilter;
    }

    public void exportStructuredTextAlgorithm(String src, PrintWriter pwCPP) {
        this.inExpression = false;
        this.condtionalQueue.clear();
        this.pwCPP = pwCPP;
        if (this.pwCPP != null) {
            StringTokenizer t = new StringTokenizer(src, " &():.=[]+-*/><;\n\r\t\"'!,", true);
            while (t.hasMoreElements()) {
                String s = t.nextToken();
                this.exportSTStatement(s, t);
            }
        }
    }

    public void exportGuardCondition(String guard, PrintWriter pwCPP) {
        this.inExpression = true;
        this.condtionalQueue.clear();
        this.pwCPP = pwCPP;
        if (this.pwCPP != null) {
            StringTokenizer t = new StringTokenizer(guard, " &():.=[]+-*/><;\n\r\t\"'!,", true);
            while (t.hasMoreElements()) {
                String s = t.nextToken();
                this.exportSTStatement(s, t);
            }
        }
    }

    private void exportSTComment(StringTokenizer tokens) {
        this.pwCPP.print("/* ");
        boolean endTag = false;
        while (!endTag) {
            String var;
            do {
                if (!tokens.hasMoreElements()) {
                    return;
                }
                var = tokens.nextToken();
                this.pwCPP.print(var);
            } while (!var.equals("*"));
            if (!tokens.hasMoreElements()) {
                return;
            }
            var = tokens.nextToken();
            if (var.equals(")")) {
                endTag = true;
                continue;
            }
            this.pwCPP.print(var);
        }
        this.pwCPP.print("/");
    }

    private void exportSTStatement(String statement, StringTokenizer tokens) {
        String upperStatement = statement.toUpperCase();
        if (upperStatement.equals("XOR")) {
            this.pwCPP.print("^");
            return;
        }
        if (upperStatement.equals("MOD")) {
            this.pwCPP.print(" % ");
            return;
        }
        if (upperStatement.equals("TRUE")) {
            this.pwCPP.print("true");
            return;
        }
        if (upperStatement.equals("FALSE")) {
            this.pwCPP.print("false");
            return;
        }
        if (upperStatement.equals("NOT")) {
            this.pwCPP.print("!");
            return;
        }
        if (statement.equals(":")) {
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            if (statement.equals("=")) {
                this.pwCPP.print(" = ");
            } else {
                this.pwCPP.print(" : ");
                this.exportSTStatement(statement, tokens);
            }
            return;
        }
        if (statement.equals(".")) {
            this.pwCPP.print(".");
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            this.exportSTStatement(statement, tokens);
            if (!Character.isDigit(statement.codePointAt(0)) && this.exportFilter.getVars().get(statement) == null) {
                this.pwCPP.print("()");
            }
            return;
        }
        if (upperStatement.equals("AND") || statement.equals("&")) {
            if (this.inExpression) {
                this.pwCPP.print(") && (");
            } else {
                this.pwCPP.print("&");
            }
            return;
        }
        if (upperStatement.equals("OR")) {
            if (this.inExpression) {
                this.pwCPP.print(") || (");
            } else {
                this.pwCPP.print("|");
            }
            return;
        }
        if (statement.equals("<")) {
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            if (statement.equals("=")) {
                this.pwCPP.print(" <= ");
            } else if (statement.equals(">")) {
                this.pwCPP.print(" != ");
            } else {
                this.pwCPP.print(" < ");
                this.exportSTStatement(statement, tokens);
            }
            return;
        }
        if (statement.equals(">")) {
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            if (statement.equals("=")) {
                this.pwCPP.print(" >= ");
            } else {
                this.pwCPP.print(" > ");
                this.exportSTStatement(statement, tokens);
            }
            return;
        }
        if (statement.equals("=")) {
            this.pwCPP.print(" == ");
            return;
        }
        if (upperStatement.equals("RETURN")) {
            this.pwCPP.print("return");
            return;
        }
        if (upperStatement.equals("EXIT")) {
            this.pwCPP.print("break");
            return;
        }
        if (upperStatement.equals("CASE")) {
            this.emitCASEStatement(tokens);
            return;
        }
        if (upperStatement.equals("END_IF")) {
            this.pwCPP.print("}");
            if (!this.condtionalQueue.isEmpty()) {
                Conditionals cond = this.condtionalQueue.removeLast();
                if (Conditionals.IF != cond && Conditionals.IF_ELSE != cond) {
                    this.exportFilter.addErrorMsg("END_IF without corresponding IF statement found!");
                }
            } else {
                this.exportFilter.addErrorMsg("END_IF without corresponding IF statement found!");
            }
            return;
        }
        if (upperStatement.equals("END_FOR")) {
            this.exportEndForStatement();
            return;
        }
        if (upperStatement.equals("END_WHILE")) {
            this.pwCPP.print("}");
            return;
        }
        if (upperStatement.equals("ELSE")) {
            Conditionals cond = this.condtionalQueue.peekLast();
            if (Conditionals.IF == cond || Conditionals.IF_ELSE == cond) {
                this.pwCPP.print("}\nelse{");
                this.condtionalQueue.removeLast();
                this.condtionalQueue.add(Conditionals.IF_ELSE);
            } else if (Conditionals.CASE == cond) {
                this.pwCPP.print(" break;\ndefault: ");
                this.condtionalQueue.removeLast();
                this.condtionalQueue.add(Conditionals.CASE_ELSE);
            } else {
                this.exportFilter.addErrorMsg("Else without preceding IF, ELSIF, or CASE statement");
            }
            return;
        }
        if (upperStatement.equals("ELSIF")) {
            this.inExpression = true;
            Conditionals cond = this.condtionalQueue.peekLast();
            if (Conditionals.IF == cond || Conditionals.IF_ELSE == cond) {
                this.pwCPP.print("}\nelse\n  if((");
                this.condtionalQueue.removeLast();
                this.condtionalQueue.add(Conditionals.IF_ELSE);
            }
            return;
        }
        if (upperStatement.equals("IF")) {
            this.inExpression = true;
            this.condtionalQueue.add(Conditionals.IF);
            this.pwCPP.print("if((");
            return;
        }
        if (upperStatement.equals("THEN")) {
            this.inExpression = false;
            this.pwCPP.print(")){");
            return;
        }
        if (upperStatement.equals("REPEAT")) {
            this.pwCPP.println("do{");
            return;
        }
        if (upperStatement.equals("UNTIL")) {
            this.pwCPP.print("}\nwhile((");
            this.inExpression = true;
            return;
        }
        if (upperStatement.equals("END_REPEAT")) {
            this.inExpression = false;
            this.pwCPP.print("));");
            return;
        }
        if (upperStatement.equals("WHILE")) {
            this.pwCPP.print("while((");
            this.inExpression = true;
            return;
        }
        if (upperStatement.equals("DO")) {
            this.inExpression = false;
            this.pwCPP.println(")){");
            return;
        }
        if (upperStatement.equals("FOR")) {
            try {
                this.exportForStatement(tokens);
            }
            catch (StructuredTextException e) {
                this.exportFilter.addErrorMsg(e.getMessage());
            }
            return;
        }
        if (upperStatement.equals("VAR")) {
            try {
                this.exportLokalVariables(tokens);
            }
            catch (StructuredTextException e) {
                this.exportFilter.addErrorMsg(e.getMessage());
            }
            return;
        }
        if (upperStatement.equals("]")) {
            this.pwCPP.print("]");
            return;
        }
        if (statement.equals("(")) {
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            if (statement.equals("*")) {
                this.exportSTComment(tokens);
            } else if (statement.equals(")")) {
                this.pwCPP.print("()");
            } else {
                this.pwCPP.print("((");
                this.exportSTStatement(statement, tokens);
            }
            return;
        }
        if (statement.equals(")")) {
            this.pwCPP.print("))");
            return;
        }
        if (statement.equals(",")) {
            this.pwCPP.print("), (");
            return;
        }
        if (statement.equals("/")) {
            this.pwCPP.print(statement);
            if (!tokens.hasMoreElements()) {
                return;
            }
            statement = tokens.nextToken();
            if (statement.equals("/")) {
                this.pwCPP.print("/ ");
                if (!tokens.hasMoreElements()) {
                    return;
                }
                statement = tokens.nextToken();
                while (!statement.equals("\n") && !statement.equals("\r")) {
                    this.pwCPP.print(statement);
                    if (!tokens.hasMoreElements()) {
                        return;
                    }
                    statement = tokens.nextToken();
                }
                this.pwCPP.println("");
            } else if (statement.equals("*")) {
                this.pwCPP.print("* ");
                if (!tokens.hasMoreElements()) {
                    return;
                }
                statement = tokens.nextToken();
                boolean endTag = false;
                while (!endTag) {
                    String var;
                    do {
                        if (!tokens.hasMoreElements()) {
                            return;
                        }
                        var = tokens.nextToken();
                        this.pwCPP.print(var);
                    } while (!var.equals("*"));
                    if (!tokens.hasMoreElements()) {
                        return;
                    }
                    var = tokens.nextToken();
                    if (var.equals("/")) {
                        endTag = true;
                        continue;
                    }
                    this.pwCPP.print(var);
                }
                this.pwCPP.print("/");
            } else {
                this.exportSTStatement(statement, tokens);
            }
            return;
        }
        if (statement.equals("!")) {
            this.exportFilter.addErrorMsg(" Found wrong statement in ST code: '!' Export may not be correct. Please check exported C++ code!");
            this.pwCPP.print(statement);
            return;
        }
        if (statement.equals("\"")) {
            this.exportWStringLiteral(tokens);
            return;
        }
        if (statement.equals("'")) {
            this.exportStringLiteral(tokens);
            return;
        }
        if (!statement.equals(" ")) {
            ExportFilter.VarDefinition var = this.exportFilter.getVars().get(statement);
            if (var != null) {
                this.pwCPP.print(String.valueOf(statement) + "()");
            } else {
                ArrayList<ForteExportFilter1_0_x.adapterInstance> myAdapters = this.exportFilter.getAdapters();
                boolean isAnAdapter = false;
                for (ForteExportFilter1_0_x.adapterInstance myAdapter : myAdapters) {
                    if (!myAdapter.stName.equals(statement)) continue;
                    isAnAdapter = true;
                    break;
                }
                if (isAnAdapter) {
                    this.pwCPP.print(String.valueOf(statement) + "()");
                } else if (statement.contains("#")) {
                    this.exportTypedLiteral(statement);
                } else {
                    this.pwCPP.print(statement);
                }
            }
        }
    }

    private void exportTypedLiteral(String statement) {
        int hashIndex = statement.indexOf(35);
        String prefix = statement.substring(0, hashIndex);
        statement = statement.substring(hashIndex + 1);
        int type = StructuredTextEmitter.isTypeName(prefix);
        if (type != 0) {
            this.pwCPP.print("CIEC_" + StructuredTextEmitter.getDataTypeNameFromPrefix(prefix) + "(");
            if (2 == type) {
                this.pwCPP.print("\"" + prefix + "#");
                hashIndex = -1;
            } else {
                hashIndex = statement.indexOf(35);
                if (-1 != hashIndex) {
                    prefix = statement.substring(0, hashIndex);
                    statement = statement.substring(hashIndex + 1);
                }
            }
        }
        if (-1 != hashIndex) {
            this.handleLiteralBasePrefix(prefix);
        }
        this.pwCPP.print(statement);
        if (type != 0) {
            if (2 == type) {
                this.pwCPP.print("\"");
            }
            this.pwCPP.print(")");
        }
    }

    private static String getDataTypeNameFromPrefix(String prefix) {
        if ("t".equals(prefix) || "T".equals(prefix)) {
            return "TIME";
        }
        if ("d".equals(prefix) || "D".equals(prefix)) {
            return "DATE";
        }
        if ("tod".equals(prefix) || "TOD".equals(prefix)) {
            return "TIME_OF_DAY";
        }
        if ("dt".equals(prefix) || "DT".equals(prefix)) {
            return "DATE_AND_TIME";
        }
        return prefix;
    }

    private static int isTypeName(String prefix) {
        int retVal = 0;
        if (!(prefix.startsWith("1") || prefix.startsWith("8") || prefix.startsWith("2"))) {
            String[] stringArray = elementaryTypeNames;
            int n = elementaryTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName = stringArray[n2];
                if (typeName.equals(prefix)) {
                    return 1;
                }
                ++n2;
            }
            retVal = 2;
        }
        return retVal;
    }

    private void handleLiteralBasePrefix(String prefix) {
        if (prefix.equals("16")) {
            this.pwCPP.print("0x");
        } else if (prefix.equals("8")) {
            this.pwCPP.print("0");
        } else if (prefix.equals("2")) {
            this.pwCPP.print("0b");
        } else {
            this.exportFilter.addErrorMsg("Wrong literal base prefix provided: " + prefix + "#");
        }
    }

    private void exportLokalVariables(StringTokenizer tokens) throws StructuredTextException {
        while (tokens.hasMoreElements()) {
            String token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
            if (token.equals("END_VAR")) {
                return;
            }
            if (token.equals("\n") || token.equals("\t") || token.equals(" ")) continue;
            String varName = token;
            token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
            if (token != null && token.equals(":")) {
                token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
                if (token != null) {
                    if (token.equals("ARRAY")) {
                        this.exportLocalArray(varName, tokens);
                    } else {
                        this.pwCPP.print("CIEC_" + token + " ");
                        this.pwCPP.print(varName);
                        this.handleVarInitialisation(tokens, "");
                    }
                    this.pwCPP.println(";");
                    continue;
                }
                throw new StructuredTextException("Variable declaration is missing the type");
            }
            throw new StructuredTextException("Variable declaration is missing the : between var name and type");
        }
        throw new StructuredTextException("VAR statement not closed with END_VAR.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportLocalArray(String varName, StringTokenizer tokens) throws StructuredTextException {
        String token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null || !token.equals("[")) throw new StructuredTextException("Array size start missing");
        StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null || !token.equals(".")) throw new StructuredTextException("Array var range missing ..");
        if (!tokens.hasMoreElements() || !tokens.nextToken().equals(".")) throw new StructuredTextException("Array var range missing ..");
        String upper = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null || !token.equals("]")) throw new StructuredTextException("Array size end missing");
        token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null || !token.equals("OF")) throw new StructuredTextException("Array OF missing");
        token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null) return;
        this.pwCPP.print("CIEC_ARRAY " + varName + "(" + upper + ", g_nStringId" + token + ")");
        this.handleVarInitialisation(tokens, ".fromString");
    }

    private static String getNextNoneSpaceToken(StringTokenizer tokens) {
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (token.equals("\n") || token.equals("\t") || token.equals(" ") || token.equals("\r")) continue;
            return token;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleVarInitialisation(StringTokenizer tokens, String initStartCode) throws StructuredTextException {
        String token = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (token == null) throw new StructuredTextException("variable statement not closed with ;.");
        if (!":".equals(tokens.nextToken())) {
            if (!";".equals(token)) throw new StructuredTextException("variable statement not closed with ;.");
            return;
        }
        if (!tokens.hasMoreElements()) throw new StructuredTextException("VAR initialisation is mising =.");
        if (!tokens.nextToken().equals("=")) throw new StructuredTextException("VAR initialisation is mising =.");
        this.pwCPP.print(String.valueOf(initStartCode) + "(\"");
        while (tokens.hasMoreElements()) {
            token = tokens.nextToken();
            if (token.equals(";")) {
                this.pwCPP.print("\")");
                return;
            }
            this.pwCPP.print(token);
        }
        throw new StructuredTextException("variable statement not closed with ;.");
    }

    private void exportEndForStatement() {
        if (!this.forValBuf.isEmpty()) {
            ForValBuffer forVals = this.forValBuf.lastElement();
            String strippedForControlVal = forVals.forControlVal.replace("()", "_");
            this.pwCPP.println("\n      if(((is" + strippedForControlVal + "Up) && ((" + forVals.forByVal + ") > 0)) || ");
            this.pwCPP.println("         ((!is" + strippedForControlVal + "Up) && ((" + forVals.forByVal + ") < 0))){");
            this.pwCPP.println("        " + forVals.forControlVal + " = " + forVals.forControlVal + " + (" + forVals.forByVal + ");");
            this.pwCPP.println("      }");
            this.pwCPP.println("      else{");
            this.pwCPP.println("        " + forVals.forControlVal + " = " + forVals.forControlVal + " - (" + forVals.forByVal + ");");
            this.pwCPP.println("      }");
            this.pwCPP.println("    }");
            this.pwCPP.println("  }");
            this.forValBuf.remove(forVals);
        } else {
            this.exportFilter.addErrorMsg("For loop closed without an according open statement!");
        }
    }

    private void exportWStringLiteral(StringTokenizer tokens) {
        String statement;
        this.pwCPP.print("\"");
        do {
            if ((statement = tokens.nextToken()).equals("$")) {
                statement = tokens.nextToken();
                if (!statement.equals("\"")) continue;
                this.pwCPP.print("\\\"");
                statement = "";
                continue;
            }
            this.pwCPP.print(statement);
        } while (!statement.equals("\""));
    }

    private void exportStringLiteral(StringTokenizer tokens) {
        String statement;
        this.pwCPP.print("\"");
        do {
            if ((statement = tokens.nextToken()).equals("\"")) {
                this.pwCPP.print("\\\"");
                continue;
            }
            if (statement.equals("'")) {
                this.pwCPP.print("\"");
                continue;
            }
            if (statement.equals("$")) {
                statement = tokens.nextToken();
                if (!statement.equals("'")) continue;
                this.pwCPP.print("'");
                statement = "";
                continue;
            }
            this.pwCPP.print(statement);
        } while (!statement.equals("'"));
    }

    private void exportForStatement(StringTokenizer tokens) throws StructuredTextException {
        ForValBuffer forVals = new ForValBuffer();
        forVals.forByVal = "1";
        forVals.forControlVal = this.getForVar(tokens, ":");
        this.inExpression = true;
        String buf = tokens.nextToken();
        if (buf == null || !buf.equals("=")) {
            throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting '=' statement.");
        }
        String forInitialVal = this.getForVar(tokens, "TO");
        String forToVal = this.getForToAndBy(tokens, forVals);
        String strippedForControlVal = forVals.forControlVal.replace("()", "_");
        this.pwCPP.println("  {");
        this.pwCPP.println("    bool is" + strippedForControlVal + "Up = ((" + forVals.forByVal + ") > 0);");
        this.pwCPP.println("    " + forVals.forControlVal + " = " + forInitialVal + ";");
        this.pwCPP.println("    while(!(((is" + strippedForControlVal + "Up) && (" + forVals.forControlVal + " > (" + forToVal + "))) ||");
        this.pwCPP.println("            ((!is" + strippedForControlVal + "Up) && (" + forVals.forControlVal + " < (" + forToVal + "))))){");
        this.forValBuf.add(forVals);
        this.inExpression = false;
    }

    /*
     * Unable to fully structure code
     */
    private String getForVar(StringTokenizer tokens, String delim) throws StructuredTextException {
        result = new StringWriter();
        printWriter = new PrintWriter(result);
        bufPrintWriter = this.pwCPP;
        this.pwCPP = printWriter;
        buf = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
        if (buf != null) ** GOTO lbl12
        throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting variable statement.");
lbl-1000:
        // 1 sources

        {
            this.exportSTStatement(buf, tokens);
            buf = StructuredTextEmitter.getNextNoneSpaceToken(tokens);
            if (buf != null) continue;
            throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting: " + delim);
lbl12:
            // 2 sources

            ** while (!buf.equalsIgnoreCase((String)delim))
        }
lbl13:
        // 1 sources

        this.pwCPP = bufPrintWriter;
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String getForToAndBy(StringTokenizer tokens, ForValBuffer forVals) throws StructuredTextException {
        result = new StringWriter();
        printWriter = new PrintWriter(result);
        bufPrintWriter = this.pwCPP;
        this.pwCPP = printWriter;
        hadBYStatement = false;
        if (!tokens.hasMoreTokens()) {
            throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting DO or BY");
        }
        buf = tokens.nextToken();
        retval = "";
        ** GOTO lbl27
        {
            if (!tokens.hasMoreTokens()) {
                throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting DO or BY");
            }
            buf = tokens.nextToken();
            do {
                if (buf.equals(" ")) continue block0;
                if (buf.equalsIgnoreCase("DO")) continue;
                if (buf.equalsIgnoreCase("BY")) {
                    hadBYStatement = true;
                    retval = result.toString();
                    result = new StringWriter();
                    this.pwCPP = printWriter = new PrintWriter(result);
                } else {
                    this.exportSTStatement(buf, tokens);
                }
                if (!tokens.hasMoreTokens()) {
                    throw new StructuredTextException("Unexpected end of algorithm in for argument parsing! Expecting DO or BY");
                }
                buf = tokens.nextToken();
lbl27:
                // 3 sources

            } while (!buf.equalsIgnoreCase("DO"));
        }
        if (hadBYStatement) {
            forVals.forByVal = result.toString();
        } else {
            retval = result.toString();
        }
        this.pwCPP = bufPrintWriter;
        return retval;
    }

    private void emitCASEStatement(StringTokenizer tokens) {
        String s;
        StringTokenizer t;
        int pos;
        this.condtionalQueue.add(Conditionals.CASE);
        boolean caseElementEnded = false;
        String statement = tokens.nextToken().toUpperCase();
        String buf = "";
        this.pwCPP.print("switch(");
        while (!statement.equals("OF")) {
            this.exportSTStatement(statement, tokens);
            statement = tokens.nextToken().toUpperCase();
        }
        this.pwCPP.print(" ){");
        Boolean first = true;
        statement = tokens.nextToken().toUpperCase();
        while (true) {
            if (!caseElementEnded && !statement.equals("END_CASE")) {
                buf = String.valueOf(buf) + statement;
                if (statement.equalsIgnoreCase("CASE")) {
                    this.exportSTStatement(statement, tokens);
                    buf = statement = tokens.nextToken().toUpperCase();
                }
                if (statement.equals(":")) {
                    while ((statement = tokens.nextToken().toUpperCase()).equals(" ")) {
                    }
                    if (statement.equals("=")) continue;
                    caseElementEnded = true;
                    continue;
                }
                statement = tokens.nextToken().toUpperCase();
                continue;
            }
            pos = buf.lastIndexOf(59);
            if (pos != -1) {
                t = new StringTokenizer(buf.substring(0, pos), " &():=[]+-*/><;\n\r\t\"'", true);
                while (t.hasMoreElements()) {
                    s = t.nextToken();
                    this.exportSTStatement(s, t);
                }
            }
            if (!caseElementEnded) break;
            t = pos != -1 ? new StringTokenizer(buf.substring(pos), " &():=[]+-*/><;\n\r\t\"'.,", true) : new StringTokenizer(buf, " &():=[]+-*/><;\n\r\t\"'.,", true);
            if (!first.booleanValue()) {
                this.pwCPP.println("\nbreak;");
            } else {
                first = false;
            }
            this.pwCPP.print("\ncase ");
            String[] alltokens = new String[t.countTokens()];
            int tokenID = 0;
            while (t.hasMoreElements()) {
                String s2 = "";
                do {
                    s2 = t.nextToken();
                    alltokens[tokenID++] = s2;
                } while (s2.equals(" ") || s2.equals("\n") || s2.equals("\t)"));
                if (s2.equals(",")) {
                    this.pwCPP.print(":\ncase ");
                    continue;
                }
                if (s2.equals(".") && t.nextToken().equals(".")) {
                    int i;
                    int lower = 0;
                    int upper = 0;
                    try {
                        lower = Integer.parseInt(alltokens[tokenID - 2]);
                        upper = Integer.parseInt(t.nextToken());
                    }
                    catch (NumberFormatException nex) {
                        Activator.getDefault().logError(nex.getMessage(), nex);
                    }
                    if (lower < upper) {
                        i = lower + 1;
                        while (i <= upper) {
                            this.pwCPP.print(":\ncase " + i);
                            ++i;
                        }
                    } else {
                        i = lower - 1;
                        while (i >= upper) {
                            this.pwCPP.print(":\ncase " + i);
                            --i;
                        }
                    }
                }
                if (s2.equals(";") || s2.equals(".")) continue;
                this.pwCPP.print(s2);
            }
            caseElementEnded = false;
            buf = "";
        }
        if (pos == -1 && buf.length() != 0) {
            t = new StringTokenizer(buf, " &():=[]+-*/><;\n\r\t\"'", true);
            while (t.hasMoreElements()) {
                s = t.nextToken();
                this.exportSTStatement(s, t);
            }
        }
        this.pwCPP.print("\n }");
        Conditionals cond = this.condtionalQueue.removeLast();
        if (Conditionals.CASE != cond && Conditionals.CASE_ELSE != cond) {
            this.exportFilter.addErrorMsg("END_CASE without corresponding IF statement found!");
        }
    }

    private static enum Conditionals {
        IF,
        IF_ELSE,
        CASE,
        CASE_ELSE;

    }

    private static class ForValBuffer {
        public String forByVal;
        public String forControlVal;

        private ForValBuffer() {
        }
    }
}

