/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.util.OpenListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenSubApplicationEditorAction
extends OpenListener {
    private static final String OPEN_SUBAPP_LISTENER_ID = "org.eclipse.fordiac.ide.application.actions.OpenSubApplicationEditorAction";
    private SubApp subApp;

    public OpenSubApplicationEditorAction(SubApp subApp) {
        this.subApp = subApp;
    }

    public OpenSubApplicationEditorAction() {
    }

    public void run() {
        SubApplicationEditorInput input = new SubApplicationEditorInput(this.subApp);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.editor = activePage.openEditor((IEditorInput)input, SubAppNetworkEditor.class.getName());
        }
        catch (PartInitException e) {
            this.editor = null;
            ApplicationPlugin.getDefault().logError(Messages.OpenSubApplicationEditorAction_ERROR_OpenSubapplicationEditor, (Exception)((Object)e));
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSel;
        if (selection instanceof IStructuredSelection && (structuredSel = (IStructuredSelection)selection).getFirstElement() instanceof SubApp) {
            this.subApp = (SubApp)structuredSel.getFirstElement();
        }
    }

    public String getActionText() {
        return Messages.OpenSubApplicationEditorAction_Name;
    }

    public Class<? extends I4DIACElement> getHandledClass() {
        return SubApp.class;
    }

    public String getOpenListenerID() {
        return OPEN_SUBAPP_LISTENER_ID;
    }
}

