/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.LinkConstraints;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public class EventConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    public EventConnectionCreateCommand(FBNetwork parent) {
        super(parent);
    }

    @Override
    protected Connection createConnectionElement() {
        return LibraryElementFactory.eINSTANCE.createEventConnection();
    }

    @Override
    public boolean canExecute() {
        if (this.source == null || this.destination == null) {
            return false;
        }
        if (this.source == this.destination) {
            return false;
        }
        if (!(this.source instanceof Event)) {
            return false;
        }
        if (!(this.destination instanceof Event)) {
            return false;
        }
        if (this.duplicateConnection()) {
            return false;
        }
        boolean retVal = LinkConstraints.canExistEventConnection((Event)this.source, (Event)this.destination);
        return retVal;
    }

    private boolean duplicateConnection() {
        for (Connection con : this.source.getInputConnections()) {
            if (con.getSource() != this.destination && con.getDestination() != this.destination) continue;
            return true;
        }
        for (Connection con : this.source.getOutputConnections()) {
            if (con.getSource() != this.destination && con.getDestination() != this.destination) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork fbNetwork) {
        return new EventConnectionCreateCommand(fbNetwork);
    }
}

