/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeActionOrderCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeTransitionPriorityCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ActionContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.StateContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECStateEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class StateSection
extends AbstractECSection {
    private Text nameText;
    private Text commentText;
    private TreeViewer actionViewer;
    private Button actionUp;
    private Button actionDown;
    private Button actionNew;
    private Button actionDelete;
    private TreeViewer transitionsOutViewer;
    private Button transitionUp;
    private Button transitionDown;

    protected ECState getType() {
        return (ECState)this.type;
    }

    protected Object getInputType(Object input) {
        if (input instanceof ECStateEditPart) {
            return ((ECStateEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof ECState) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createNameCommentControls(parent);
        this.createActionTransitionControls(parent);
    }

    public void createNameCommentControls(Composite parent) {
        Composite nameComposite = this.getWidgetFactory().createComposite(parent);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        nameComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(nameComposite, "Name:");
        this.nameText = this.createGroupText(nameComposite, true);
        this.nameText.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.nameText.addListener(24, e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeNameCommand((INamedElement)this.getType(), this.nameText.getText()));
            this.addContentAdapter();
        });
        Composite commentComposite = this.getWidgetFactory().createComposite(parent);
        commentComposite.setLayout((Layout)new GridLayout(2, false));
        commentComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(commentComposite, "Comment:");
        this.commentText = this.createGroupText(commentComposite, true);
        this.commentText.addListener(24, e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    public void createActionCreateButton(Composite actionButtonComp) {
        this.actionNew = this.getWidgetFactory().createButton(actionButtonComp, "", 0x800000);
        this.actionNew.setToolTipText("Create new action");
        this.actionNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.actionNew.addListener(13, e -> {
            this.executeCommand(new CreateECActionCommand(LibraryElementFactory.eINSTANCE.createECAction(), this.getType()));
            this.actionViewer.refresh();
        });
    }

    private void createActionDeleteButton(Composite actionButtonComp) {
        this.actionDelete = this.getWidgetFactory().createButton(actionButtonComp, "", 8);
        this.actionDelete.setToolTipText("Delete selected action");
        this.actionDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.actionDelete.addListener(13, e -> {
            ECAction action = (ECAction)((IStructuredSelection)this.actionViewer.getSelection()).getFirstElement();
            this.executeCommand(new DeleteECActionCommand(action));
            this.actionViewer.refresh();
        });
    }

    public void createActionTransitionControls(Composite parent) {
        Group actionGroup = this.getWidgetFactory().createGroup(parent, "Actions");
        actionGroup.setLayout((Layout)new GridLayout(2, false));
        actionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        this.createActionViewer(actionGroup, gridData);
        Composite actionButtonComp = new Composite((Composite)actionGroup, 0);
        actionButtonComp.setLayout((Layout)new FillLayout(512));
        this.createActionCreateButton(actionButtonComp);
        this.createActionUpButton(actionButtonComp);
        this.createActionDownButton(actionButtonComp);
        this.createActionDeleteButton(actionButtonComp);
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Outgoing Transitions");
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTransitionViewer(gridData, transactionGroup);
        Composite buttonComp = new Composite((Composite)transactionGroup, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.createTransitionUpButton(buttonComp);
        this.createTransitionDownButton(buttonComp);
    }

    private void createActionViewer(Group actionGroup, GridData gridData) {
        this.actionViewer = new TreeViewer((Composite)actionGroup, 2820);
        this.actionViewer.getTree().setLayoutData((Object)gridData);
        this.actionViewer.setContentProvider((IContentProvider)new ActionContentProvider());
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.actionViewer.getTree(), (AdapterFactory)this.adapterFactory);
    }

    private void createTransitionViewer(GridData gridData, Group transactionGroup) {
        this.transitionsOutViewer = new TreeViewer((Composite)transactionGroup, 2820);
        this.transitionsOutViewer.getTree().setLayoutData((Object)gridData);
        this.transitionsOutViewer.setContentProvider((IContentProvider)new StateContentProvider());
        this.transitionsOutViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.transitionsOutViewer.getTree(), (AdapterFactory)this.adapterFactory);
    }

    private void createTransitionDownButton(Composite buttonComp) {
        this.transitionDown = this.getWidgetFactory().createButton(buttonComp, "SWT.ARROW |SWT.UP", 1028);
        this.transitionDown.setToolTipText("Move transition down");
        this.transitionDown.addListener(13, e -> {
            Object selection = ((TreeSelection)this.transitionsOutViewer.getSelection()).getFirstElement();
            if (selection instanceof ECTransition) {
                this.executeCommand(new ChangeTransitionPriorityCommand(this.getType(), (ECTransition)selection, false));
                this.transitionsOutViewer.refresh();
                this.transitionsOutViewer.setSelection((ISelection)new StructuredSelection(selection));
            }
        });
    }

    private void createTransitionUpButton(Composite buttonComp) {
        this.transitionUp = this.getWidgetFactory().createButton(buttonComp, "", 132);
        this.transitionUp.setToolTipText("Move transition up");
        this.transitionUp.addListener(13, e -> {
            Object selection = ((TreeSelection)this.transitionsOutViewer.getSelection()).getFirstElement();
            if (selection instanceof ECTransition) {
                this.executeCommand(new ChangeTransitionPriorityCommand(this.getType(), (ECTransition)selection, true));
                this.transitionsOutViewer.refresh();
                this.transitionsOutViewer.setSelection((ISelection)new StructuredSelection(selection));
            }
        });
    }

    private void createActionDownButton(Composite actionButtonComp) {
        this.actionDown = this.getWidgetFactory().createButton(actionButtonComp, "Down", 1028);
        this.actionDown.setToolTipText("Move action down");
        this.actionDown.addListener(13, e -> {
            Object selection = ((TreeSelection)this.actionViewer.getSelection()).getFirstElement();
            if (selection instanceof ECAction) {
                this.executeCommand(new ChangeActionOrderCommand(this.getType(), (ECAction)selection, false));
                this.actionViewer.refresh();
                this.actionViewer.setSelection((ISelection)new StructuredSelection(selection));
            }
        });
    }

    private void createActionUpButton(Composite actionButtonComp) {
        this.actionUp = this.getWidgetFactory().createButton(actionButtonComp, "", 132);
        this.actionUp.setToolTipText("Move action up");
        this.actionUp.addListener(13, e -> {
            Object selection = ((TreeSelection)this.actionViewer.getSelection()).getFirstElement();
            if (selection instanceof ECAction) {
                this.executeCommand(new ChangeActionOrderCommand(this.getType(), (ECAction)selection, true));
                this.actionViewer.refresh();
                this.actionViewer.setSelection((ISelection)new StructuredSelection(selection));
            }
        });
    }

    protected void setInputCode() {
        this.commentText.setEnabled(false);
        this.nameText.setEnabled(false);
        this.transitionsOutViewer.setInput(null);
        this.actionViewer.setInput(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.transitionsOutViewer.setInput((Object)this.getType());
            this.actionViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputInit() {
    }
}

