/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.util.comm.channels.ChannelManager;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public abstract class IIecNetCommRcv
implements IIecReceivable {
    protected ChannelManager m_oManager = ChannelManager.getInstance();
    protected List<IEC_ANY> m_loReceiveData = new ArrayList<IEC_ANY>();
    protected boolean m_bInitialized = false;
    protected String m_sID;

    protected boolean Initialize(String pa_sID, int pa_nChannelType) {
        try {
            this.m_oManager.register(pa_sID, pa_nChannelType, this);
        }
        catch (CommException commException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean DeInitialize(String pa_sID) {
        try {
            this.m_oManager.deregister(pa_sID);
        }
        catch (CommException commException) {
            return false;
        }
        return true;
    }

    protected boolean ReceivedDataTypeMatch(List<IEC_ANY> receivedList) {
        if (receivedList.size() != this.m_loReceiveData.size()) {
            return false;
        }
        boolean equal = true;
        int i = 0;
        while (i < receivedList.size()) {
            if (receivedList.get(i).getClass() != this.m_loReceiveData.get(i).getClass()) {
                equal = false;
            }
            ++i;
        }
        return equal;
    }

    @Override
    public void ReceiveIECData(List<IEC_ANY> inList) {
        if (!this.ReceivedDataTypeMatch(inList)) {
            System.out.println("did not receive expected data");
            return;
        }
        int i = 0;
        while (i < inList.size()) {
            this.m_loReceiveData.get(i).setValue(inList.get(i));
            ++i;
        }
        for (IEC_ANY elem : inList) {
            System.out.println("Value: " + elem.toString());
        }
    }

    @Override
    public void setMyReceiveData(List<IEC_ANY> pa_loReceiveData) {
        this.m_loReceiveData = pa_loReceiveData;
        System.out.println(pa_loReceiveData.toString());
    }
}

