/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes.derived;

import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;
import org.eclipse.fordiac.ide.util.comm.exceptions.IllegalEncodingException;

public class DerivedDataTypeFactory {
    private static final int MAX_LOW_TAG_NUMBER = 30;

    public static IEC_ANY getDerivedType(int IdentifierOctet, DataInputStream in) {
        boolean Constructed;
        int ASN1typeID = IdentifierOctet & 0x1F;
        int Class2 = IdentifierOctet & 0xC0;
        boolean bl = Constructed = (IdentifierOctet & 0x20) > 0;
        if (ASN1typeID >= 30) {
            boolean finished = false;
            int buf = 0;
            while (!finished) {
                try {
                    buf = in.readUnsignedByte();
                }
                catch (IOException iOException) {
                    throw new IllegalEncodingException("Illegal encoding of tag number.");
                }
                if ((buf & 0x80) == 0) {
                    finished = true;
                }
                ASN1typeID = (ASN1typeID << 7) + buf;
            }
        }
        switch (Class2) {
            case 0: {
                return DerivedDataTypeFactory.getUNIVERSALType(ASN1typeID, Constructed, in);
            }
            case 64: {
                return DerivedDataTypeFactory.getAPPLICATIONType(ASN1typeID, Constructed, in);
            }
            case 128: {
                return DerivedDataTypeFactory.getCONTEXTType(ASN1typeID, Constructed, in);
            }
            case 192: {
                return DerivedDataTypeFactory.getPRIVATEType(ASN1typeID, Constructed, in);
            }
        }
        return null;
    }

    private static IEC_ANY getUNIVERSALType(int ASN1TypeID, boolean constructed, DataInputStream in) {
        throw new DataTypeValueOutOfBoundsException("Derived Types are supposed to be of class ASN1.PRIVATE!");
    }

    private static IEC_ANY getAPPLICATIONType(int ASN1TypeID, boolean constructed, DataInputStream in) {
        if (ASN1TypeID <= 22) {
            throw new DataTypeValueOutOfBoundsException("TypeIDs <23 are reserved for elementary datatypes in Class \"Application\"");
        }
        throw new DataTypeValueOutOfBoundsException("Derived Types are supposed to be of class ASN1.PRIVATE!");
    }

    private static IEC_ANY getCONTEXTType(int ASN1TypeID, boolean constructed, DataInputStream in) {
        throw new DataTypeValueOutOfBoundsException("Derived Types are supposed to be of class ASN1.PRIVATE!");
    }

    private static IEC_ANY getPRIVATEType(int ASN1TypeID, boolean constructed, DataInputStream in) {
        if (constructed) {
            throw new DataTypeValueOutOfBoundsException("Datatype not supported yet.");
        }
        throw new DataTypeValueOutOfBoundsException("Datatype not supported yet.");
    }
}

