/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractInterfaceElementEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.TypeField;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ComboCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ComboDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboBoxCellEditor;

public class TypeEditPart
extends AbstractInterfaceElementEditPart
implements EditPart {
    private Palette systemPalette;
    private Label comment;

    public TypeEditPart(Palette systemPalette) {
        this.systemPalette = systemPalette;
    }

    @Override
    public IInterfaceElement getCastedModel() {
        return ((TypeField)this.getModel()).getReferencedElement();
    }

    protected IFigure createFigure() {
        this.comment = new TypeFigure();
        this.update();
        return this.comment;
    }

    @Override
    protected void update() {
        this.comment.setText(this.getTypeName());
    }

    private String getTypeName() {
        return ((TypeField)this.getModel()).getLabel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected void showCurrentEditValue(DirectEditRequest request) {
            }

            protected Command getDirectEditCommand(DirectEditRequest request) {
                int index;
                if (this.getHost() instanceof AbstractDirectEditableEditPart && (index = ((Integer)request.getCellEditor().getValue()).intValue()) > 0 && index < ((ComboDirectEditManager)TypeEditPart.this.getManager()).getComboBox().getItemCount()) {
                    String typeName = ((ComboDirectEditManager)TypeEditPart.this.getManager()).getComboBox().getItem(index);
                    ChangeTypeCommand cmd = TypeEditPart.this.getCastedModel() instanceof AdapterDeclaration ? new ChangeTypeCommand((VarDeclaration)TypeEditPart.this.getCastedModel(), (DataType)TypeEditPart.getAdapterTypeEntry(TypeEditPart.this.systemPalette, typeName).getAdapterType()) : new ChangeTypeCommand((VarDeclaration)TypeEditPart.this.getCastedModel(), DataTypeLibrary.getInstance().getType(typeName));
                    return cmd;
                }
                return null;
            }
        });
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        if (request.getType() == "direct edit") {
            if (this.getCastedModel() instanceof VarDeclaration) {
                super.performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    public DirectEditManager getManager() {
        if (this.manager == null) {
            this.manager = new ComboDirectEditManager((GraphicalEditPart)this, ComboBoxCellEditor.class, (CellEditorLocator)new ComboCellEditorLocator(this.comment), this.comment);
        }
        return this.manager;
    }

    public void performDirectEdit() {
        ArrayList<String> dataTypeNames = new ArrayList<String>();
        if (this.getCastedModel() instanceof AdapterDeclaration) {
            for (AdapterTypePaletteEntry adapterType : TypeEditPart.getAdapterTypes(this.systemPalette)) {
                dataTypeNames.add(adapterType.getLabel());
            }
            Collections.sort(dataTypeNames);
        } else {
            for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
                dataTypeNames.add(dataType.getName());
            }
        }
        ((ComboDirectEditManager)this.getManager()).updateComboData(dataTypeNames);
        ((ComboDirectEditManager)this.getManager()).setSelectedItem(dataTypeNames.indexOf(this.getTypeName()));
        this.getManager().show();
    }

    public static AdapterTypePaletteEntry getAdapterTypeEntry(Palette systemPalette, String typeName) {
        PaletteEntry entry = systemPalette.getTypeEntry(typeName);
        return entry instanceof AdapterTypePaletteEntry ? (AdapterTypePaletteEntry)entry : null;
    }

    public static ArrayList<AdapterTypePaletteEntry> getAdapterTypes(Palette systemPalette) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        Palette pal = systemPalette;
        if (pal == null) {
            pal = TypeLibrary.getInstance().getPalette();
        }
        retVal.addAll(TypeEditPart.getAdapterGroup(pal.getRootGroup()));
        return retVal;
    }

    private static ArrayList<AdapterTypePaletteEntry> getAdapterGroup(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteGroup paletteGroup : group.getSubGroups()) {
            retVal.addAll(TypeEditPart.getAdapterGroup(paletteGroup));
        }
        retVal.addAll(TypeEditPart.getAdapterGroupEntries(group));
        return retVal;
    }

    private static ArrayList<AdapterTypePaletteEntry> getAdapterGroupEntries(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            if (!(entry instanceof AdapterTypePaletteEntry)) continue;
            retVal.add((AdapterTypePaletteEntry)entry);
        }
        return retVal;
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    public class TypeFigure
    extends Label {
        public TypeFigure() {
            this.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        }

        public void setText(String s) {
            VarDeclaration varDec;
            if (TypeEditPart.this.getCastedModel() instanceof VarDeclaration && (varDec = (VarDeclaration)TypeEditPart.this.getCastedModel()).isArray()) {
                s = String.valueOf(s) + "[" + varDec.getArraySize() + "]";
            }
            super.setText(s);
        }
    }
}

