/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.network.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.editparts.CompositeFBNetworkLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class CompositeNetworkEditPart
extends EditorWithInterfaceEditPart {
    protected EContentAdapter adapter;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
            this.getModel().eContainer().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            this.getModel().eContainer().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    public EContentAdapter getContentAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    int type = notification.getEventType();
                    switch (type) {
                        case 3: 
                        case 5: {
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                        case 7: {
                            if (!(notification.getNewValue() instanceof IInterfaceElement)) break;
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                        case 4: 
                        case 6: {
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CompositeFBNetworkLayoutEditPolicy());
    }

    protected List<?> getModelChildren() {
        ArrayList children = new ArrayList();
        if (this.getModel() != null) {
            CompositeFBType fbType = this.getFbType();
            children.addAll(fbType.getInterfaceList().getEventInputs());
            children.addAll(fbType.getInterfaceList().getEventOutputs());
            children.addAll(fbType.getInterfaceList().getInputVars());
            children.addAll(fbType.getInterfaceList().getOutputVars());
            if (fbType instanceof SubAppType) {
                children.addAll(fbType.getInterfaceList().getPlugs());
                children.addAll(fbType.getInterfaceList().getSockets());
            }
            children.addAll(super.getModelChildren());
        }
        return children;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IInterfaceElement iElement;
        boolean visible = true;
        if (childEditPart instanceof InterfaceEditPart && (iElement = ((InterfaceEditPart)childEditPart).getModel()) instanceof AdapterDeclaration) {
            visible = iElement.eContainer().eContainer() instanceof SubAppType;
        }
        EditPart refEditPart = null;
        if (index < this.getChildren().size()) {
            refEditPart = (EditPart)this.getChildren().get(index);
        }
        if (childEditPart instanceof InterfaceEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            if (((InterfaceEditPart)childEditPart).getModel().isIsInput()) {
                if (((InterfaceEditPart)childEditPart).isEvent()) {
                    CompositeNetworkEditPart.insertChild(this.getLeftEventInterfaceContainer(), refEditPart, child);
                } else if (visible) {
                    CompositeNetworkEditPart.insertChild(this.getLeftVarInterfaceContainer(), refEditPart, child);
                } else {
                    CompositeNetworkEditPart.insertChild(this.getLeftInterfaceContainer(), refEditPart, child);
                }
            } else if (((InterfaceEditPart)childEditPart).isEvent()) {
                CompositeNetworkEditPart.insertChild(this.getRightEventInterfaceContainer(), refEditPart, child);
            } else if (visible) {
                CompositeNetworkEditPart.insertChild(this.getRightVarInterfaceContainer(), refEditPart, child);
            } else {
                CompositeNetworkEditPart.insertChild(this.getRightInterfaceContainer(), refEditPart, child);
            }
            child.setVisible(visible);
        } else {
            super.addChildVisual(childEditPart, -1);
        }
    }

    private static void insertChild(Figure container, EditPart refEditPart, IFigure child) {
        if (refEditPart != null) {
            int index = container.getChildren().indexOf(((GraphicalEditPart)refEditPart).getFigure());
            container.add(child, index);
        } else {
            container.add(child);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        boolean visible = true;
        if (childEditPart.getModel() instanceof AdapterDeclaration) {
            visible = false;
        }
        if (childEditPart instanceof InterfaceEditPart) {
            if (((InterfaceEditPart)childEditPart).getModel().isIsInput()) {
                IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
                if (((InterfaceEditPart)childEditPart).isEvent()) {
                    this.getLeftEventInterfaceContainer().remove(child);
                } else if (visible) {
                    this.getLeftVarInterfaceContainer().remove(child);
                } else {
                    this.getLeftInterfaceContainer().remove(child);
                }
            } else {
                IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
                if (((InterfaceEditPart)childEditPart).isEvent()) {
                    this.getRightEventInterfaceContainer().remove(child);
                } else if (visible) {
                    this.getRightVarInterfaceContainer().remove(child);
                } else {
                    this.getRightInterfaceContainer().remove(child);
                }
            }
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected void reorderChild(EditPart editpart, int index) {
        IFigure childFigure = ((GraphicalEditPart)editpart).getFigure();
        LayoutManager layout = this.getContentPane().getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        this.removeChildVisual(editpart);
        this.addChildVisual(editpart, index);
        List children = this.getChildren();
        children.remove(editpart);
        children.add(index, editpart);
        this.setLayoutConstraint(editpart, childFigure, constraint);
    }

    protected void addChild(EditPart child, int index) {
        Assert.isNotNull((Object)child);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        this.addChildVisual(child, index);
        this.children.add(index, child);
        child.setParent((EditPart)this);
        child.addNotify();
        if (this.isActive()) {
            child.activate();
        }
        this.fireChildAdded(child, index);
    }

    private CompositeFBType getFbType() {
        return (CompositeFBType)this.getModel().eContainer();
    }
}

