/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.fbtypeeditor.FBInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.ruler.FordiacRulerComposite;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class FBInterfaceEditor
extends GraphicalEditorWithFlyoutPalette
implements IFBTEditorPart {
    private RulerComposite rulerComp;
    private CommandStack commandStack;
    private FBType fbType;
    protected ZoomManager zoomManager;
    private KeyHandler sharedKeyHandler;
    protected PaletteRoot paletteRoot;
    protected Palette palette;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.fbType = untypedInput.getContent();
            PaletteGroup group = untypedInput.getPaletteEntry().getGroup();
            while (group.eContainer() != null) {
                group = group.eContainer();
            }
            if (group instanceof Palette) {
                this.palette = (Palette)group;
            }
            if (this.palette == null) {
                this.palette = TypeLibrary.getInstance().getPalette();
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setEditDomain(new FBTypeEditDomain(this, this.commandStack));
        this.setPartName("Interface");
        this.setTitleImage(FordiacImage.ICON_InterfaceEditor.getImage());
        super.init(site, input);
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new FordiacRulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected Control getGraphicalControl() {
        return this.rulerComp;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ZoomScalableFreeformRootEditPart root = new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.getEditPartFactory());
        viewer.setContextMenu((MenuManager)new InterfaceContextMenuProvider((EditPartViewer)viewer, root.getZoomManager(), this.getActionRegistry()));
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        KeyHandler viewerKeyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(viewerKeyHandler);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, registry, this.fbType);
        super.createActions();
    }

    protected EditPartFactory getEditPartFactory() {
        return new FBInterfaceEditPartFactory((GraphicalEditor)this, this.palette, this.zoomManager);
    }

    public void createPartControl(Composite parent) {
        Composite graphicaEditor = new Composite(parent, 0);
        graphicaEditor.setLayout((Layout)new FillLayout());
        super.createPartControl(graphicaEditor);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)viewer));
        viewer.setContents((Object)this.fbType);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        }
        return this.sharedKeyHandler;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    protected PaletteRoot getPaletteRoot() {
        this.paletteRoot = FBInterfacePaletteFactory.createPalette(this.palette);
        return this.paletteRoot;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public boolean outlineSelectionChanged(Object selectedElement) {
        Object editpart = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        this.getGraphicalViewer().flush();
        if (editpart != null && editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
            this.getGraphicalViewer().select((EditPart)editpart);
            return true;
        }
        return selectedElement instanceof InterfaceList;
    }

    @Override
    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FBInterfacePaletteFactory.createPalettePreferences();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }
}

