/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.fordiac.ide.deployment.AbstractDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.IDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateConnectionException;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateFBInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateResourceInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.StartException;
import org.eclipse.fordiac.ide.deployment.exceptions.WriteDeviceParameterException;
import org.eclipse.fordiac.ide.deployment.exceptions.WriteFBParameterException;
import org.eclipse.fordiac.ide.deployment.exceptions.WriteResourceParameterException;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DeploymentExecutor
implements IDeploymentExecutor {
    private static final String PROFILE_NAME = "HOLOBLOC";
    private final HashSet<String> genFBs = new HashSet();
    protected int id = 0;
    AbstractDeviceManagementCommunicationHandler devMgmCommHandler = null;

    public DeploymentExecutor() {
        this.genFBs.add("PUBLISH");
        this.genFBs.add("SUBSCRIBE");
        this.genFBs.add("PUBL");
        this.genFBs.add("SUBL");
        this.genFBs.add("SERVER");
        this.genFBs.add("CLIENT");
    }

    public void setDeviceManagementCommunicationHandler(AbstractDeviceManagementCommunicationHandler handler) {
        this.devMgmCommHandler = handler;
    }

    public AbstractDeviceManagementCommunicationHandler getDevMgmComHandler() {
        return this.devMgmCommHandler;
    }

    private String getValidType(FB fb) {
        if (fb != null && fb.getPaletteEntry() != null) {
            return fb.getTypeName();
        }
        return null;
    }

    public void sendREQ(String destination, String request) throws IOException {
        this.devMgmCommHandler.sendREQ(destination, request);
    }

    public void sendQUERY(String destination, String request) throws IOException {
        this.devMgmCommHandler.sendQUERY(destination, request);
    }

    public boolean supports(String profile) {
        return this.getProfileName().equals(profile);
    }

    public String getProfileName() {
        return PROFILE_NAME;
    }

    public void createResource(Resource resource) throws CreateResourceInstanceException {
        String request = MessageFormat.format(Messages.DeploymentExecutor_CreateResourceInstance, this.id++, resource.getName(), resource.getTypeName());
        try {
            this.sendREQ("", request);
        }
        catch (EOFException eOFException) {
            throw new CreateResourceInstanceException(MessageFormat.format(Messages.DeploymentExecutor_DeviceConnectionClosed, resource.getName()));
        }
        catch (IOException iOException) {
            throw new CreateResourceInstanceException(MessageFormat.format(Messages.DeploymentExecutor_CreateResourceFailed, resource.getName()));
        }
    }

    public void writeResourceParameter(Resource resource, String parameter, String value) throws WriteResourceParameterException {
        String encodedValue = this.encodeXMLChars(value);
        String request = this.generateWriteParmaRequest(resource.getName(), parameter, encodedValue);
        try {
            this.sendREQ("", request);
        }
        catch (IOException iOException) {
            throw new WriteResourceParameterException(MessageFormat.format(Messages.DeploymentExecutor_WriteResourceParameterFailed, resource.getName(), parameter));
        }
    }

    protected String generateWriteParmaRequest(String targetElementName, String parameter, String value) {
        return MessageFormat.format(this.getWriteParameterMessage(), this.id++, value, String.valueOf(targetElementName) + "." + parameter);
    }

    protected String getWriteParameterMessage() {
        return Messages.DeploymentExecutor_WriteParameter;
    }

    private String encodeXMLChars(String value) {
        String retVal = value;
        retVal = retVal.replaceAll("\"", "&quot;");
        retVal = retVal.replaceAll("'", "&apos;");
        retVal = retVal.replaceAll("<", "&lt;");
        retVal = retVal.replaceAll(">", "&gt;");
        return retVal;
    }

    public void writeFBParameter(Resource resource, String value, FBDeploymentData fbData, VarDeclaration varDecl) throws WriteFBParameterException {
        String encodedValue = this.encodeXMLChars(value);
        String request = this.generateWriteParmaRequest(String.valueOf(fbData.prefix) + fbData.fb.getName(), varDecl.getName(), encodedValue);
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException iOException) {
            throw new WriteFBParameterException(MessageFormat.format(Messages.DeploymentExecutor_WriteFBParameterFailed, resource.getName(), varDecl.getName()));
        }
    }

    public void createConnection(Resource resource, ConnectionDeploymentData connData) throws CreateConnectionException {
        IInterfaceElement source = connData.source;
        IInterfaceElement destination = connData.destination;
        if (source != null && destination != null && source.getFBNetworkElement() != null && destination.getFBNetworkElement() != null) {
            FBNetworkElement sourceFB = source.getFBNetworkElement();
            FBNetworkElement destFB = destination.getFBNetworkElement();
            String request = MessageFormat.format(Messages.DeploymentExecutor_CreateConnection, this.id++, String.valueOf(connData.sourcePrefix) + sourceFB.getName() + "." + source.getName(), String.valueOf(connData.destinationPrefix) + destFB.getName() + "." + destination.getName());
            try {
                this.sendREQ(resource.getName(), request);
            }
            catch (IOException iOException) {
                throw new CreateConnectionException(Messages.DeploymentExecutor_CreateConnectionFailed);
            }
        } else {
            throw new CreateConnectionException(Messages.DeploymentExecutor_CreateConnectionFailed);
        }
    }

    public void startResource(Resource res) throws StartException {
        String request = MessageFormat.format(Messages.DeploymentExecutor_Start, this.id++);
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException iOException) {
            throw new StartException(MessageFormat.format(Messages.DeploymentExecutor_StartingResourceFailed, res.getName()));
        }
    }

    public void startDevice(Device dev) throws StartException {
        String request = MessageFormat.format(Messages.DeploymentExecutor_Start, this.id++);
        try {
            this.sendREQ("", request);
        }
        catch (IOException iOException) {
            throw new StartException(MessageFormat.format(Messages.DeploymentExecutor_StartingDeviceFailed, dev.getName()));
        }
    }

    public void writeDeviceParameter(Device device, String parameter, String value) throws WriteDeviceParameterException {
        String request = MessageFormat.format(this.getWriteParameterMessage(), this.id++, value, parameter);
        try {
            this.sendREQ("", request);
        }
        catch (IOException iOException) {
            throw new WriteDeviceParameterException(MessageFormat.format(Messages.DeploymentExecutor_WriteDeviceParameterFailed, device.getName(), parameter));
        }
    }

    public void deleteResource(Resource res) throws Exception {
        String kill = MessageFormat.format(Messages.DeploymentExecutor_KillFB, this.id++, res.getName());
        String delete = MessageFormat.format(Messages.DeploymentExecutor_DeleteFB, this.id++, res.getName());
        try {
            this.sendREQ("", kill);
        }
        catch (IOException iOException) {
            throw new WriteDeviceParameterException(MessageFormat.format(Messages.DeploymentExecutor_KillFBFailed, res.getName()));
        }
        try {
            this.sendREQ("", delete);
        }
        catch (IOException iOException) {
            throw new WriteDeviceParameterException(MessageFormat.format(Messages.DeploymentExecutor_DeleteFBFailed, res.getName()));
        }
    }

    public void clearDevice(Device dev) throws Exception {
        for (Resource res : dev.getResource()) {
            if (res.isDeviceTypeResource()) continue;
            this.deleteResource(res);
        }
    }

    public void deleteConnection(Resource res, ConnectionDeploymentData conData) throws Exception {
    }

    public void deleteFB(Resource res, FBDeploymentData fbData) throws Exception {
    }

    public void startFB(Resource res, FBDeploymentData fbData) throws StartException {
        String fullFbInstanceName = String.valueOf(fbData.prefix) + fbData.fb.getName();
        String request = MessageFormat.format(Messages.DeploymentExecutor_StartFB, this.id++, fullFbInstanceName, fbData.fb.getTypeName());
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException iOException) {
            throw new StartException(MessageFormat.format(Messages.DeploymentExecutor_StartingFBFailed, fullFbInstanceName));
        }
    }

    public void createFBInstance(FBDeploymentData fbData, Resource res) throws CreateFBInstanceException {
        String fbType = this.getValidType(fbData.fb);
        String fullFbInstanceName = String.valueOf(fbData.prefix) + fbData.fb.getName();
        if ("".equals(fbType)) {
            throw new CreateFBInstanceException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailedNoTypeFound, fullFbInstanceName));
        }
        String request = MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstance, this.id++, fullFbInstanceName, fbType);
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException iOException) {
            throw new CreateFBInstanceException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailed, fullFbInstanceName));
        }
    }

    public void killDevice(Device dev) throws Exception {
        String kill = MessageFormat.format(Messages.DeploymentExecutor_KillDevice, this.id++);
        try {
            try {
                this.sendREQ("", kill);
            }
            catch (IOException e) {
                if (!(e instanceof EOFException)) {
                    throw new Exception(MessageFormat.format(Messages.DeploymentExecutor_KillDeviceFailed, dev.getName()));
                }
                this.devMgmCommHandler.resetTypes();
            }
        }
        finally {
            this.devMgmCommHandler.resetTypes();
        }
    }
}

