/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.internal.core.ComparePlugin;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CompareContentViewerSwitchingPane
extends CompareViewerSwitchingPane {
    private static final String OPTIMIZED_INFO_IMAGE_NAME = "obj16/message_info.png";
    public static final String OPTIMIZED_ALGORITHM_USED = "OPTIMIZED_ALGORITHM_USED";
    public static final String DISABLE_CAPPING_TEMPORARILY = "DISABLE_CAPPING_TEMPORARILY";
    private CompareEditorInput fCompareEditorInput;
    private ViewerDescriptor fSelectedViewerDescriptor;
    private ToolBar toolBar;
    private CLabel labelOptimized;
    private Link recomputeLink;
    private boolean menuShowing;

    public CompareContentViewerSwitchingPane(Splitter parent, int style, CompareEditorInput editorInput) {
        super((Composite)parent, style);
        this.fCompareEditorInput = editorInput;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.fCompareEditorInput.getCompareConfiguration();
    }

    @Override
    protected Viewer getViewer(Viewer oldViewer, Object input) {
        if (this.fSelectedViewerDescriptor != null) {
            List<Object> list;
            ViewerDescriptor[] array = CompareUIPlugin.getDefault().findContentViewerDescriptor(oldViewer, input, this.getCompareConfiguration());
            List<Object> list2 = list = array != null ? Arrays.asList(array) : Collections.emptyList();
            if (list.contains(this.fSelectedViewerDescriptor)) {
                this.fCompareEditorInput.setContentViewerDescriptor(this.fSelectedViewerDescriptor);
                Viewer viewer = this.fCompareEditorInput.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
                return viewer;
            }
            this.fSelectedViewerDescriptor = null;
        }
        if (input instanceof ICompareInput) {
            this.fCompareEditorInput.setContentViewerDescriptor(null);
            Viewer viewer = this.fCompareEditorInput.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
            this.fCompareEditorInput.setContentViewerDescriptor(this.fSelectedViewerDescriptor);
            return viewer;
        }
        return null;
    }

    @Override
    protected Control createTopLeft(Composite p) {
        Composite composite = new Composite(p, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        layout.center = true;
        layout.wrap = false;
        composite.setLayout((Layout)layout);
        CLabel cl = new CLabel(composite, 0);
        cl.setText(null);
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.setVisible(false);
        ToolItem toolItem = new ToolItem(this.toolBar, 8, 0);
        toolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_VIEW_MENU"));
        toolItem.setToolTipText(CompareMessages.CompareContentViewerSwitchingPane_switchButtonTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareContentViewerSwitchingPane.this.showMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CompareContentViewerSwitchingPane.this.showMenu();
            }
        });
        this.labelOptimized = new CLabel(composite, 0);
        this.labelOptimized.setToolTipText(CompareMessages.CompareContentViewerSwitchingPane_optimizedTooltip);
        this.labelOptimized.setImage(CompareUIPlugin.getImageDescriptor(OPTIMIZED_INFO_IMAGE_NAME).createImage());
        this.labelOptimized.setVisible(false);
        this.labelOptimized.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img = CompareContentViewerSwitchingPane.this.labelOptimized.getImage();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
        this.recomputeLink = new Link(composite, 0);
        this.recomputeLink.setText(CompareMessages.CompareContentViewerSwitchingPane_optimizedLinkLabel);
        this.recomputeLink.setToolTipText(CompareMessages.CompareContentViewerSwitchingPane_optimizedTooltip);
        this.recomputeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore preferenceStore = CompareUIPlugin.getDefault().getPreferenceStore();
                boolean wasDisabled = preferenceStore.getBoolean("org.eclipse.compare.CappingDisable");
                ComparePlugin.getDefault().setCappingDisabled(true);
                preferenceStore.setValue("org.eclipse.compare.CappingDisable", true);
                try {
                    CompareContentViewerSwitchingPane.this.getCompareConfiguration().setProperty(CompareContentViewerSwitchingPane.DISABLE_CAPPING_TEMPORARILY, Boolean.TRUE);
                }
                finally {
                    if (!wasDisabled) {
                        ComparePlugin.getDefault().setCappingDisabled(false);
                        preferenceStore.setValue("org.eclipse.compare.CappingDisable", false);
                    }
                }
            }
        });
        this.recomputeLink.setVisible(false);
        return composite;
    }

    @Override
    protected boolean inputChanged(Object input) {
        return this.getInput() != input || this.fCompareEditorInput.getContentViewerDescriptor() != this.fSelectedViewerDescriptor;
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        if (this.getViewer() == null || !Utilities.okToUse((Widget)this.getViewer().getControl())) {
            return;
        }
        ViewerDescriptor[] vd = CompareUIPlugin.getDefault().findContentViewerDescriptor(this.getViewer(), this.getInput(), this.getCompareConfiguration());
        this.toolBar.setVisible(vd != null && vd.length > 1);
        CompareConfiguration cc = this.getCompareConfiguration();
        Boolean isOptimized = (Boolean)cc.getProperty(OPTIMIZED_ALGORITHM_USED);
        boolean optimizedVisible = isOptimized != null && isOptimized != false;
        this.labelOptimized.setVisible(optimizedVisible);
        this.recomputeLink.setVisible(optimizedVisible);
    }

    private void showMenu() {
        if (this.menuShowing) {
            return;
        }
        this.menuShowing = true;
        ViewerDescriptor[] vd = CompareUIPlugin.getDefault().findContentViewerDescriptor(this.getViewer(), this.getInput(), this.getCompareConfiguration());
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        String label = CompareMessages.CompareContentViewerSwitchingPane_defaultViewer;
        MenuItem defaultItem = new MenuItem(menu, 16);
        defaultItem.setText(label);
        defaultItem.addSelectionListener(this.createSelectionListener(null));
        defaultItem.setSelection(this.fSelectedViewerDescriptor == null);
        new MenuItem(menu, 2);
        int i = 0;
        while (i < vd.length) {
            block6: {
                ViewerDescriptor vdi;
                block5: {
                    vdi = vd[i];
                    label = vdi.getLabel();
                    if (label != null && !label.isEmpty()) break block5;
                    String l = CompareUIPlugin.getDefault().findContentTypeNameOrType((ICompareInput)this.getInput(), vdi, this.getCompareConfiguration());
                    if (l == null) break block6;
                    label = NLS.bind((String)CompareMessages.CompareContentViewerSwitchingPane_discoveredLabel, (Object)l);
                }
                MenuItem item = new MenuItem(menu, 16);
                item.setText(label);
                item.addSelectionListener(this.createSelectionListener(vdi));
                item.setSelection(vdi == this.fSelectedViewerDescriptor);
            }
            ++i;
        }
        Rectangle bounds = this.toolBar.getItem(0).getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                CompareContentViewerSwitchingPane.this.menuShowing = false;
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
    }

    private SelectionListener createSelectionListener(final ViewerDescriptor vd) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem mi = (MenuItem)e.widget;
                if (mi.getSelection()) {
                    Viewer oldViewer = CompareContentViewerSwitchingPane.this.getViewer();
                    CompareContentViewerSwitchingPane.this.fSelectedViewerDescriptor = vd;
                    CompareContentViewerSwitchingPane.this.setInput(oldViewer.getInput());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    @Override
    public void setText(String text) {
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel label = (CLabel)child;
                if (label != null && !label.isDisposed()) {
                    label.setText(text);
                    c.layout();
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public void setImage(Image image) {
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel label = (CLabel)child;
                if (label != null && !label.isDisposed()) {
                    label.setImage(image);
                }
                return;
            }
            ++n2;
        }
    }

    public void addMouseListener(MouseListener listener) {
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel label = (CLabel)child;
                label.addMouseListener(listener);
            }
            ++n2;
        }
    }
}

