/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.IAlgorithmEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.IAlgorithmEditorCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext.XTextAlgorithmEditor;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class XTextAlgorithmCreator
implements IAlgorithmEditorCreator {
    private static final String LINKING_FILE_EXTENSION = "xtextfbt";
    @Inject
    protected EmbeddedEditorFactory editorFactory;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    @Named(value="file.extensions")
    public String fileExtension;

    @Override
    public IAlgorithmEditor createAlgorithmEditor(Composite parent, final BasicFBType fbType) {
        IEditedResourceProvider resourceProvider = new IEditedResourceProvider(){

            public XtextResource createResource() {
                XtextResourceSet resourceSet = (XtextResourceSet)XTextAlgorithmCreator.this.resourceSetProvider.get();
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.LINKING_FILE_EXTENSION));
                fbResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)fbType)));
                for (AdapterDeclaration adapter : fbType.getInterfaceList().getSockets()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                for (AdapterDeclaration adapter : fbType.getInterfaceList().getPlugs()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                copier.copyReferences();
                Resource resource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.this.fileExtension));
                return (XtextResource)resource;
            }

            private void createAdapterResource(XtextResourceSet resourceSet, EcoreUtil.Copier copier, AdapterDeclaration adapter) {
                if (adapter.getType() instanceof AdapterType) {
                    Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.LINKING_FILE_EXTENSION));
                    copier.copy((EObject)adapter.getType());
                    adapterResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)((AdapterType)adapter.getType()).getAdapterFBType())));
                }
            }

            protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
                String name = "__synthetic";
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    URI syntheticUri = URI.createURI((String)(String.valueOf(name) + i + "." + fileExtension));
                    if (resourceSet.getResource(syntheticUri, false) == null) {
                        return syntheticUri;
                    }
                    ++i;
                }
                throw new IllegalStateException();
            }
        };
        EmbeddedEditor editor = this.editorFactory.newEditor(resourceProvider).showErrorAndWarningAnnotations().withParent(parent);
        return this.createXTextAlgorithmEditor(fbType, editor);
    }

    protected XTextAlgorithmEditor createXTextAlgorithmEditor(BasicFBType fbType, EmbeddedEditor editor) {
        return new XTextAlgorithmEditor(editor, fbType);
    }
}

