/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY_DATE;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_DATE
extends IEC_ANY_DATE {
    public IEC_DATE() {
        Calendar c = Calendar.getInstance();
        this.reduceToDate(c);
        this.value = c.getTimeInMillis();
    }

    public IEC_DATE(long initial) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(initial));
        this.reduceToDate(c);
        this.value = c.getTimeInMillis();
    }

    private void reduceToDate(Calendar c) {
        int[] temp = new int[]{c.get(1), c.get(2), c.get(5)};
        c.clear();
        c.set(temp[0], temp[1], temp[2]);
    }

    public IEC_DATE(Date initial) {
        Calendar c = Calendar.getInstance();
        c.setTime(initial);
        this.reduceToDate(c);
        this.value = initial.getTime();
    }

    public IEC_DATE(String initial) {
        this.fromString(initial);
    }

    private void fromString(String paValueString) throws DataTypeValueOutOfBoundsException, NumberFormatException {
        String valueString = paValueString.toLowerCase();
        if (!valueString.startsWith("d#") && !valueString.startsWith("date#")) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        String[] temp = (valueString = valueString.split("#")[1]).split("-");
        if (temp.length == 3) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        Calendar instance = Calendar.getInstance();
        instance.set(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]) - 1, Integer.parseInt(temp[2]));
        this.value = instance.getTimeInMillis();
    }

    public IEC_DATE(DataInputStream in) {
        super(in);
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{77};
        return retval;
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_DATE)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.fromString(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

