/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.common.utils.AcceleoNonStandardLibrary;
import org.eclipse.acceleo.common.utils.AcceleoStandardLibrary;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoUMLReflection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEnvironment
extends EcoreEnvironment {
    private AcceleoNonStandardLibrary acceleoNonStdLib;
    private AcceleoStandardLibrary acceleoStdLib;
    private Collection<EPackage> metamodels = new ArrayList<EPackage>();
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> umlReflection;

    protected AcceleoEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
    }

    protected AcceleoEnvironment(Resource oclEnvironmentResource) {
        super(EPackage.Registry.INSTANCE, oclEnvironmentResource);
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getInteger(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getInteger()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getReal(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getReal()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOclAny(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOclAny()));
    }

    public void addMetamodel(EPackage metamodel) {
        this.metamodels.add(metamodel);
    }

    public void removeMetamodel(EPackage metamodel) {
        this.metamodels.remove(metamodel);
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier classifier = null;
        if (names.size() > 0 && (classifier = this.lookupClassifier(names.get(names.size() - 1))) == null) {
            classifier = super.lookupClassifier(names);
        }
        return classifier;
    }

    public EClassifier lookupClassifier(String name) {
        if (name != null) {
            for (EClassifier eClassifier : this.getTypes()) {
                if (!name.equals(eClassifier.getName())) continue;
                return eClassifier;
            }
        }
        return null;
    }

    public AcceleoNonStandardLibrary getAcceleoNonStandardLibrary() {
        if (this.acceleoNonStdLib == null) {
            this.acceleoNonStdLib = new AcceleoNonStandardLibrary();
        }
        return this.acceleoNonStdLib;
    }

    public AcceleoStandardLibrary getAcceleoStandardLibrary() {
        if (this.acceleoStdLib == null) {
            this.acceleoStdLib = new AcceleoStandardLibrary();
        }
        return this.acceleoStdLib;
    }

    public List<EClassifier> getTypes() {
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        for (EPackage ePackage : this.metamodels) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                this.computeOCLType(result, eClassifier);
            }
        }
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getBag());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getBoolean());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getCollection());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getInteger());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getInvalid());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclAny());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclElement());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclExpression());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclMessage());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclType());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOclVoid());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getOrderedSet());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getReal());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getSequence());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getSet());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getState());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getString());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getT());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getT2());
        this.computeOCLType(result, (EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural());
        return result;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.umlReflection == null) {
            this.umlReflection = new AcceleoUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection());
        }
        return this.umlReflection;
    }

    private void computeOCLType(List<EClassifier> result, EClassifier type) {
        EClassifier oclType = (EClassifier)this.getTypeResolver().resolve((Object)type);
        if (oclType != null) {
            result.add(oclType);
        } else {
            result.add(type);
        }
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }

    public void addHelperOperations(EClassifier owner, List<EOperation> operations) {
        for (EOperation operation : operations) {
            this.addHelperOperation(owner, operation);
        }
    }
}

