/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.popupMenus;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.CreateTemplateData;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.AcceleoNewProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMigrateProjectWizardAction
implements IWorkbenchWindowActionDelegate {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private ISelection currentSelection;

    public void run(IAction action) {
        if (this.currentSelection instanceof IStructuredSelection && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            AcceleoNewProjectWizard wizard = new AcceleoNewProjectWizard(){

                protected boolean multipleTemplates() {
                    return false;
                }
            };
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.currentSelection);
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            Point defaultSize = dialog.getShell().getSize();
            dialog.getShell().setSize(Math.max(500, defaultSize.x), Math.max(500, defaultSize.y));
            ArrayList<IProject> projects = new ArrayList<IProject>();
            Object[] objects = ((IStructuredSelection)this.currentSelection).toArray();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProject) {
                    projects.add((IProject)objects[i]);
                }
                ++i;
            }
            try {
                if (wizard.getTemplatePage().getControllers().size() > 0) {
                    AcceleoNewTemplatesWizardController first = wizard.getTemplatePage().getControllers().get(0);
                    CreateTemplateData data = first.getModel();
                    data.setTemplateShortName("chain");
                    data.setTemplateHasFileBlock(false);
                    data.setTemplateIsInitialized(false);
                    this.browseTemplates(projects.toArray(new IProject[projects.size()]));
                    String metamodelURIs = this.computeMetamodelURIs();
                    data.setTemplateMetamodel(metamodelURIs);
                    first.initView(false);
                    if (dialog.open() == 0 && wizard.getTemplatePage().getControllers().size() > 0) {
                        first = wizard.getTemplatePage().getControllers().get(0);
                        data = first.getModel();
                        Path baseFolder = new Path(data.getTemplateContainer());
                        IPath mainTemplate = baseFolder.append(data.getTemplateShortName()).addFileExtension("mtl");
                        this.generateMTL((IPath)baseFolder, mainTemplate);
                    }
                }
            }
            catch (CoreException e) {
                AcceleoCommonPlugin.log((IStatus)e.getStatus());
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.acceleo.common", e.getMessage().toString(), (Throwable)e);
                AcceleoCommonPlugin.log((IStatus)status);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    protected abstract void browseTemplates(IProject[] var1) throws CoreException;

    protected abstract void generateMTL(IPath var1, IPath var2) throws IOException, CoreException;

    protected abstract String computeMetamodelURIs();
}

