/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoCompileOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoBuilderTask
extends Task {
    private IProject project;
    private IFolder bin;
    private File target;

    public void setProject(String projectPath) {
        String projectName = projectPath != null ? new Path(projectPath).lastSegment() : null;
        if (projectName != null && ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).isAccessible()) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.bin = this.getOutputFolder(this.project);
        } else {
            this.project = null;
            this.bin = null;
        }
    }

    public void setTarget(String targetPath) {
        File folder = new File(targetPath);
        this.target = folder.exists() && folder.isDirectory() ? folder : null;
    }

    public void execute() throws BuildException {
        try {
            this.executeAndThrowMessages();
        }
        catch (BuildException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage()));
            throw e;
        }
    }

    private void executeAndThrowMessages() throws BuildException {
        if (this.project == null) {
            throw new BuildException(AcceleoUIMessages.getString("AcceleoBuilderTask.ProjectIssue"));
        }
        if (this.bin == null) {
            throw new BuildException(AcceleoUIMessages.getString("AcceleoBuilderTask.BinIssue"));
        }
        if (this.target == null) {
            throw new BuildException(AcceleoUIMessages.getString("AcceleoBuilderTask.TargetIssue"));
        }
        try {
            String messages = this.fullBuild();
            Project p = new Project();
            Copy copy = new Copy();
            copy.setProject(p);
            copy.setTodir(this.target);
            FileSet fs = new FileSet();
            fs.setProject(p);
            fs.setDir(this.bin.getLocation().toFile());
            fs.setIncludes("**/*.emtl");
            fs.setExcludes("**/*.class");
            copy.addFileset(fs);
            copy.execute();
            if (messages.length() > 0) {
                throw new BuildException(messages);
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String fullBuild() throws CoreException {
        ArrayList<IFile> filesOutput = new ArrayList<IFile>();
        this.members(filesOutput, (IContainer)this.project);
        if (filesOutput.size() > 0) {
            Collections.sort(filesOutput, new Comparator<IFile>(){

                @Override
                public int compare(IFile arg0, IFile arg1) {
                    long m1;
                    long m0 = arg0.getLocation().toFile().lastModified();
                    if (m0 < (m1 = arg1.getLocation().toFile().lastModified())) {
                        return 1;
                    }
                    return -1;
                }
            });
            IFile[] files = filesOutput.toArray(new IFile[filesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.project, files, false);
            compileOperation.run((IProgressMonitor)new NullProgressMonitor());
            return compileOperation.getMessages();
        }
        return "";
    }

    private void members(List<IFile> filesOutput, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    filesOutput.add((IFile)resource);
                } else if (resource instanceof IContainer && (this.bin == null || !this.bin.getFullPath().isPrefixOf(resource.getFullPath()))) {
                    this.members(filesOutput, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    private IFolder getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }
}

