/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.MacroInvocation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.internal.debug.ui.LocalFileStorageEditorInput;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public final class OpenDeclarationUtils {
    private OpenDeclarationUtils() {
    }

    public static IRegion createRegion(EObject eObj) {
        int b;
        Variable eVariable;
        Region res = null;
        if (eObj instanceof ModuleElement) {
            int b2;
            ModuleElement eModuleElement = (ModuleElement)eObj;
            if (eModuleElement.eResource() != null && (b2 = eModuleElement.getStartPosition()) > -1) {
                int e = eModuleElement.getEndPosition();
                res = new Region(b2, e - b2);
            }
        } else if (eObj instanceof Variable && (eVariable = (Variable)eObj).eResource() != null && (b = eVariable.getStartPosition()) > -1) {
            res = new Region(b, eVariable.getEndPosition() - b);
        }
        return res;
    }

    public static EObject findDeclarationFromAST(ASTNode astNode) {
        Template res = null;
        if (astNode instanceof TemplateInvocation) {
            Template eTemplate;
            res = eTemplate = ((TemplateInvocation)astNode).getDefinition();
        } else if (astNode instanceof QueryInvocation) {
            Query eQuery = ((QueryInvocation)astNode).getDefinition();
            res = eQuery;
        } else if (astNode instanceof MacroInvocation) {
            Macro eMacro = ((MacroInvocation)astNode).getDefinition();
            res = eMacro;
        } else if (astNode instanceof VariableExp) {
            Variable eVariable = (Variable)((VariableExp)astNode).getReferredVariable();
            res = eVariable;
        } else if (astNode instanceof OperationCallExp) {
            EOperation eOperation = (EOperation)((OperationCallExp)astNode).getReferredOperation();
            res = eOperation;
        } else if (astNode instanceof PropertyCallExp) {
            EStructuralFeature eProperty = (EStructuralFeature)((PropertyCallExp)astNode).getReferredProperty();
            res = eProperty;
        } else if (astNode instanceof Variable) {
            EClassifier eClassifier = (EClassifier)((Variable)astNode).getType();
            res = eClassifier;
        }
        return res;
    }

    public static EObject findDeclarationFromCST(AcceleoEditor editor, ASTNode astNode, CSTNode cstNode) {
        EPackage res;
        block5: {
            String overridesName;
            block7: {
                block6: {
                    block4: {
                        EPackage ePackage;
                        res = null;
                        if (!(cstNode instanceof TypedModel)) break block4;
                        EList ePackages = ((TypedModel)cstNode).getTakesTypesFrom();
                        if (ePackages.size() <= 0) break block5;
                        res = ePackage = (EPackage)ePackages.get(0);
                        break block5;
                    }
                    if (!(cstNode instanceof ModuleImportsValue)) break block6;
                    String importName = ((ModuleImportsValue)cstNode).getName();
                    if (importName == null || editor.getContent().getAST() == null) break block5;
                    Iterator eModules = editor.getContent().getAST().getImports().iterator();
                    while (res == null && eModules.hasNext()) {
                        Module eModule = (Module)eModules.next();
                        if (!importName.equalsIgnoreCase(eModule.getName())) continue;
                        res = eModule;
                    }
                    break block5;
                }
                if (!(cstNode instanceof ModuleExtendsValue)) break block7;
                String extendsName = ((ModuleExtendsValue)cstNode).getName();
                if (extendsName == null || editor.getContent().getAST() == null) break block5;
                Iterator eModules = editor.getContent().getAST().getExtends().iterator();
                while (res == null && eModules.hasNext()) {
                    Module eModule = (Module)eModules.next();
                    if (!extendsName.equalsIgnoreCase(eModule.getName())) continue;
                    res = eModule;
                }
                break block5;
            }
            if (cstNode instanceof TemplateOverridesValue && (overridesName = ((TemplateOverridesValue)cstNode).getName()) != null && astNode instanceof Template) {
                Iterator eOverrides = ((Template)astNode).getOverrides().iterator();
                while (res == null && eOverrides.hasNext()) {
                    Template eOverride = (Template)eOverrides.next();
                    if (!overridesName.equalsIgnoreCase(eOverride.getName())) continue;
                    res = eOverride;
                }
            }
        }
        return res;
    }

    public static void showEObject(IWorkbenchPage page, URI fileURI, IRegion region, EObject eObject) {
        URI newFileURI;
        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
        if (fileURI != null && eObject != null && (newFileURI = OpenDeclarationUtils.formatURI(fileURI)) != null) {
            String lastSegment;
            IEditorDescriptor editorDescriptor;
            Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(newFileURI);
            if (fileObject instanceof IFile) {
                newFileURI = URI.createPlatformResourceURI((String)((IFile)fileObject).getFullPath().toString(), (boolean)false);
            }
            if ((editorDescriptor = (lastSegment = newFileURI.lastSegment()).endsWith("emtl") || lastSegment.endsWith(".ecore") || lastSegment.endsWith(".xmi") || lastSegment.endsWith(".uml") ? OpenDeclarationUtils.getXMIEditor() : workbench.getEditorRegistry().getDefaultEditor(lastSegment)) != null && !(eObject instanceof ASTNode) && !(eObject instanceof Module)) {
                try {
                    IEditorPart newEditor = page.openEditor((IEditorInput)new URIEditorInput(newFileURI), editorDescriptor.getId());
                    OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                }
                catch (PartInitException partInitException) {}
            }
        }
        if (fileURI != null && (eObject instanceof ASTNode || eObject instanceof Module)) {
            Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(fileURI);
            IFile file = null;
            File absoluteFile = null;
            if (fileObject instanceof IFile) {
                file = (IFile)fileObject;
            } else if (fileObject instanceof File) {
                absoluteFile = (File)fileObject;
            }
            if (file == null && absoluteFile != null) {
                URIEditorInput input = new URIEditorInput(fileURI);
                IEditorDescriptor editor = OpenDeclarationUtils.getXMIEditor();
                String editorID = editor != null ? editor.getId() : "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
                File[] siblings = absoluteFile.getParentFile().listFiles();
                int i = 0;
                while (i < siblings.length) {
                    if (siblings[i].getName().equals(new Path(absoluteFile.getName()).removeFileExtension().addFileExtension("mtl").lastSegment())) {
                        input = new LocalFileStorageEditorInput(new LocalFileStorage(siblings[i]));
                        editorID = "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
                        break;
                    }
                    ++i;
                }
                try {
                    IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editorID);
                    OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                }
                catch (PartInitException partInitException) {}
            } else if (file != null) {
                try {
                    IEditorDescriptor editorDescriptor;
                    IPath filePath = file.getFullPath();
                    if ("emtl".equals(filePath.getFileExtension())) {
                        filePath = new AcceleoProject(file.getProject()).getInputFilePath(filePath);
                        file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    }
                    if ((editorDescriptor = workbench.getEditorRegistry().getDefaultEditor(file.getName())) != null) {
                        IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorDescriptor.getId());
                        OpenDeclarationUtils.selectAndReveal(newEditor, region, eObject);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public static Object getIFileXorIOFile(URI fileURI) {
        IFile tmpFile;
        String absolutePath;
        IFile workspaceFile = null;
        File absoluteFile = null;
        String platformString = fileURI.toPlatformString(true);
        Path platformPath = platformString != null ? new Path(platformString) : null;
        if (platformPath != null && platformPath.segmentCount() > 1) {
            if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)platformPath)) {
                workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformPath);
            } else {
                String pluginName = platformPath.segment(0);
                Bundle bundle = Platform.getBundle((String)pluginName);
                if (bundle != null) {
                    OpenDeclarationUtils.getAbsoluteFile(bundle, platformPath.removeFirstSegments(1).removeFileExtension().addFileExtension("mtl").toString());
                    absoluteFile = OpenDeclarationUtils.getAbsoluteFile(bundle, platformPath.removeFirstSegments(1).toString());
                }
            }
        }
        if ((absolutePath = fileURI.toFileString()) != null) {
            absoluteFile = new File(absolutePath);
        }
        if (workspaceFile == null && fileURI.isFile() && absoluteFile != null && (tmpFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(absolutePath))) != null && tmpFile.exists()) {
            workspaceFile = tmpFile;
        }
        if (absoluteFile != null && !absoluteFile.exists()) {
            absoluteFile = null;
        }
        if (workspaceFile != null) {
            return workspaceFile;
        }
        return absoluteFile;
    }

    private static File getAbsoluteFile(Bundle bundle, String entryPath) {
        File absoluteFile;
        block5: {
            URL entry = bundle.getEntry(entryPath);
            if (entry != null) {
                try {
                    entry = FileLocator.toFileURL((URL)entry);
                    if (entry != null) {
                        absoluteFile = new Path(entry.getPath()).toFile();
                        break block5;
                    }
                    absoluteFile = null;
                }
                catch (IOException iOException) {
                    absoluteFile = null;
                }
            } else {
                absoluteFile = null;
            }
        }
        return absoluteFile;
    }

    private static URI findEcore(Bundle bundle, String ecoreName) {
        Enumeration entries = bundle.findEntries("/", ecoreName, true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                if (entry == null) continue;
                IPath path = new Path(bundle.getSymbolicName()).append(entry.getPath());
                return URI.createPlatformPluginURI((String)path.toString(), (boolean)false);
            }
        }
        return null;
    }

    private static URI formatURI(URI fileURI) {
        if (fileURI.toString().startsWith("http")) {
            IConfigurationElement member;
            int j;
            IConfigurationElement[] members;
            IExtension extension;
            int i;
            IExtension[] extensions;
            URI result = null;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String mURI = member.getAttribute("uri");
                        String genModelPath = member.getAttribute("genModel");
                        String bundleID = member.getNamespaceIdentifier();
                        if (mURI != null && mURI.equals(fileURI.toString()) && Platform.getBundle((String)bundleID) != null && genModelPath != null) {
                            String ecoreName = new Path(genModelPath).removeFileExtension().addFileExtension("ecore").lastSegment();
                            result = OpenDeclarationUtils.findEcore(Platform.getBundle((String)bundleID), ecoreName);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.uri_mapping");
            if (result == null && extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String sourceURI = member.getAttribute("source");
                        String targetURI = member.getAttribute("target");
                        if (sourceURI != null && sourceURI.equals(fileURI.toString()) && targetURI != null) {
                            result = URI.createURI((String)targetURI, (boolean)false);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return result;
        }
        return fileURI;
    }

    private static IEditorDescriptor getXMIEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor editorDescriptor = workbench.getEditorRegistry().findEditor("org.eclipse.emf.ecore.presentation.EcoreEditorID");
        if (editorDescriptor == null && (editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.ecore")) == null) {
            editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.xmi");
        }
        return editorDescriptor;
    }

    private static void selectAndReveal(IEditorPart newEditor, IRegion aRegion, EObject eObject) {
        IRegion region = aRegion;
        if (newEditor instanceof AcceleoEditor) {
            AcceleoEditor acceleoEditor = (AcceleoEditor)newEditor;
            if (region != null && eObject instanceof ModuleElement) {
                int e = acceleoEditor.getContent().getText().indexOf("]", region.getOffset());
                if (e > -1) {
                    region = new Region(region.getOffset(), e + "]".length() - region.getOffset());
                }
                acceleoEditor.selectAndReveal(region.getOffset(), region.getLength());
            } else if (region != null) {
                acceleoEditor.selectAndReveal(region.getOffset(), region.getLength());
            } else {
                EObject newEObject = null;
                Module eModule = acceleoEditor.getContent().getAST();
                if (eModule != null && eModule.eResource() != null && eObject != null && eObject.eResource() != null) {
                    String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
                    newEObject = eModule.eResource().getEObject(eObjectFragmentURI);
                }
                if (newEObject instanceof TemplateExpression && ((TemplateExpression)newEObject).getStartPosition() > -1) {
                    int b = ((TemplateExpression)newEObject).getStartPosition();
                    int e = acceleoEditor.getContent().getText().indexOf("]", b) + 1;
                    acceleoEditor.selectAndReveal(b, e - b);
                }
            }
        } else if (newEditor instanceof EcoreEditor && eObject.eResource() != null) {
            EcoreEditor ecoreEditor = (EcoreEditor)newEditor;
            String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
            if (ecoreEditor.getEditingDomain() != null && ecoreEditor.getEditingDomain().getResourceSet() != null && ecoreEditor.getEditingDomain().getResourceSet().getResources().size() > 0 && eObjectFragmentURI != null) {
                EObject newObject = ((Resource)ecoreEditor.getEditingDomain().getResourceSet().getResources().get(0)).getEObject(eObjectFragmentURI);
                ecoreEditor.setSelectionToViewer(Collections.singleton(newObject));
            }
        }
    }
}

