/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class ReferencesSearchQuery
implements ISearchQuery {
    private ReferencesSearchResult searchResult;
    private EObject declaration;
    private AcceleoEditor editor;

    public ReferencesSearchQuery(AcceleoEditor editor, EObject declaration) {
        this.declaration = declaration;
        this.editor = editor;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Query.Label");
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new ReferencesSearchResult(this);
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.declaration != null) {
            this.findReferencesForFile();
        }
        return Status.OK_STATUS;
    }

    private void findReferencesForFile() {
        IProject project;
        ArrayList<URI> allURIs = new ArrayList<URI>();
        if (this.editor.getContent().getFile() != null && this.editor.getFile() != null) {
            URI newResourceURI = URI.createPlatformResourceURI((String)new AcceleoProject(this.editor.getContent().getFile().getProject()).getOutputFilePath(this.editor.getContent().getFile()).toString(), (boolean)false);
            allURIs.add(newResourceURI);
            project = this.editor.getFile().getProject();
            for (URI uri : new AcceleoProject(project).getOutputFiles()) {
                if (allURIs.contains(uri)) continue;
                allURIs.add(uri);
            }
        } else {
            project = null;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i] != project && projects[i].isAccessible() && projects[i].hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                    AcceleoProject acceleoProject = new AcceleoProject(projects[i]);
                    for (URI uri : acceleoProject.getOutputFiles()) {
                        if (allURIs.contains(uri)) continue;
                        allURIs.add(uri);
                    }
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            ++i;
        }
        ResourceSetImpl newResourceSet = new ResourceSetImpl();
        for (URI uri : allURIs) {
            try {
                ModelUtils.load((URI)uri, (ResourceSet)newResourceSet);
            }
            catch (IOException iOException) {}
        }
        EcoreUtil.resolveAll((ResourceSet)newResourceSet);
        for (Resource resource : newResourceSet.getResources()) {
            if (resource.getContents().size() <= 0 || !(resource.getContents().get(0) instanceof Module)) continue;
            this.scanModuleForDeclaration((Module)resource.getContents().get(0));
        }
        for (Resource resource : newResourceSet.getResources()) {
            resource.unload();
        }
    }

    private void scanModuleForDeclaration(Module module) {
        Path emtlPath = new Path(module.eResource().getURI().toPlatformString(true));
        if (emtlPath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().exists((IPath)emtlPath)) {
            IFile emtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)emtlPath);
            IPath mtlPath = new AcceleoProject(emtlFile.getProject()).getInputFilePath((IPath)emtlPath);
            IFile mtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(mtlPath);
            if (mtlFile.exists()) {
                StringBuffer acceleoText = FileContent.getFileContent((File)mtlFile.getLocation().toFile());
                this.scanModuleForDeclaration(mtlFile, acceleoText, module);
            }
        }
    }

    private void scanModuleForDeclaration(IFile mtlFile, StringBuffer acceleoText, Module module) {
        this.addASTNode(mtlFile, acceleoText, (EObject)module);
        TreeIterator it = module.eAllContents();
        while (it.hasNext()) {
            this.addASTNode(mtlFile, acceleoText, (EObject)it.next());
        }
    }

    private void addASTNode(IFile mtlFile, StringBuffer acceleoText, EObject astNode) {
        boolean isRef = this.isMatching(astNode, this.declaration);
        if (!isRef) {
            for (EObject eObj : astNode.eCrossReferences()) {
                if (!this.isMatching(eObj, this.declaration)) continue;
                isRef = true;
                break;
            }
        }
        if (isRef) {
            String message;
            Object region = astNode instanceof ASTNode ? this.createRegion((ASTNode)astNode) : new Region(0, 0);
            if (region != null && region.getOffset() > -1 && region.getOffset() + region.getLength() <= acceleoText.length()) {
                message = acceleoText.substring(region.getOffset(), region.getOffset() + region.getLength());
                if (message.startsWith("[") && message.indexOf("]") > -1) {
                    message = message.substring(0, message.indexOf("]") + 1);
                }
            } else {
                message = "";
            }
            assert (region != null);
            this.searchResult.addMatch(new Match((Object)new ReferenceEntry(mtlFile, astNode, this.editor, message), region.getOffset(), region.getLength()));
        }
    }

    private boolean isMatching(EObject o1, EObject o2) {
        boolean result = o1.eClass().getName().equals(o2.eClass().getName()) ? (o1 instanceof ModuleElement && o2 instanceof ModuleElement ? ((ModuleElement)o1).getName().equals(((ModuleElement)o2).getName()) : (o1 instanceof Variable && o2 instanceof Variable ? ((Variable)o1).getName().equals(((Variable)o2).getName()) : EcoreUtil.equals((EObject)o1, (EObject)o2))) : EcoreUtil.equals((EObject)o1, (EObject)o2);
        return result;
    }

    private IRegion createRegion(ASTNode astNode) {
        int b = astNode.getStartPosition();
        if (b > -1) {
            int e = astNode.getEndPosition();
            return new Region(b, e - b);
        }
        return null;
    }
}

